/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.api.client.json.GenericJson;
import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.recommendationengine.v1beta1.EventStoreName;
import com.google.cloud.recommendationengine.v1beta1.ImportUserEventsRequest;
import com.google.cloud.recommendationengine.v1beta1.ImportUserEventsResponse;
import com.google.cloud.recommendationengine.v1beta1.InputConfig;
import com.google.cloud.recommendationengine.v1beta1.UserEvent;
import com.google.cloud.recommendationengine.v1beta1.UserEventInlineSource;
import com.google.cloud.recommendationengine.v1beta1.UserEventServiceClient;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.beam.sdk.extensions.ml.AutoValue_RecommendationAIImportUserEvents;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.util.ShardedKey;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.json.JSONObject;

@AutoValue
public abstract class RecommendationAIImportUserEvents
extends PTransform<PCollection<KV<String, GenericJson>>, PCollectionTuple> {
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized UserEvent> SUCCESS_TAG = new TupleTag<UserEvent>(){};
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized UserEvent> FAILURE_TAG = new TupleTag<UserEvent>(){};

    static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
        return new AutoValue_RecommendationAIImportUserEvents.Builder().setCatalogName("default_catalog").setEventStore("default_event_store");
    }

    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    public abstract @Nullable @UnknownKeyFor @Initialized String projectId();

    public abstract @Nullable @UnknownKeyFor @Initialized String catalogName();

    public abstract @Nullable @UnknownKeyFor @Initialized String eventStore();

    public abstract @UnknownKeyFor @NonNull @Initialized Integer batchSize();

    public abstract @UnknownKeyFor @NonNull @Initialized Duration maxBufferingDuration();

    public @UnknownKeyFor @NonNull @Initialized RecommendationAIImportUserEvents withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
        return this.toBuilder().setProjectId(projectId).build();
    }

    public @UnknownKeyFor @NonNull @Initialized RecommendationAIImportUserEvents withCatalogName(@UnknownKeyFor @NonNull @Initialized String catalogName) {
        return this.toBuilder().setCatalogName(catalogName).build();
    }

    public @UnknownKeyFor @NonNull @Initialized RecommendationAIImportUserEvents withEventStore(@UnknownKeyFor @NonNull @Initialized String eventStore) {
        return this.toBuilder().setEventStore(eventStore).build();
    }

    public @UnknownKeyFor @NonNull @Initialized RecommendationAIImportUserEvents withBatchSize(@UnknownKeyFor @NonNull @Initialized Integer batchSize) {
        return this.toBuilder().setBatchSize(batchSize).build();
    }

    public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized GenericJson>> input) {
        return (PCollectionTuple)((PCollection)input.apply("Batch Contents", (PTransform)GroupIntoBatches.ofSize((long)this.batchSize().intValue()).withMaxBufferingDuration(this.maxBufferingDuration()).withShardedKey())).apply("Import CatalogItems", (PTransform)ParDo.of((DoFn)new ImportUserEvents(this.projectId(), this.catalogName(), this.eventStore())).withOutputTags(SUCCESS_TAG, TupleTagList.of(FAILURE_TAG)));
    }

    private static class ImportUserEvents
    extends DoFn<KV<ShardedKey<String>, Iterable<GenericJson>>, UserEvent> {
        private final @UnknownKeyFor @NonNull @Initialized String projectId;
        private final @UnknownKeyFor @NonNull @Initialized String catalogName;
        private final @UnknownKeyFor @NonNull @Initialized String eventStore;

        private ImportUserEvents(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String catalogName, @UnknownKeyFor @NonNull @Initialized String eventStore) {
            this.projectId = projectId;
            this.catalogName = catalogName;
            this.eventStore = eventStore;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
            EventStoreName parent = EventStoreName.of((String)this.projectId, (String)"global", (String)this.catalogName, (String)this.eventStore);
            ArrayList<UserEvent> userEvents = new ArrayList<UserEvent>();
            for (GenericJson element : (Iterable)((KV)c.element()).getValue()) {
                UserEvent.Builder userEventBuilder = UserEvent.newBuilder();
                JsonFormat.parser().merge(new JSONObject((Map)element).toString(), (Message.Builder)userEventBuilder);
                userEvents.add(userEventBuilder.build());
            }
            UserEventInlineSource userEventInlineSource = UserEventInlineSource.newBuilder().addAllUserEvents(userEvents).build();
            InputConfig inputConfig = InputConfig.newBuilder().mergeUserEventInlineSource(userEventInlineSource).build();
            ImportUserEventsRequest request = ImportUserEventsRequest.newBuilder().setParent(parent.toString()).setInputConfig(inputConfig).build();
            try (UserEventServiceClient userEventServiceClient = UserEventServiceClient.create();){
                ImportUserEventsResponse response = (ImportUserEventsResponse)userEventServiceClient.importUserEventsAsync(request).get();
                if (response.getErrorSamplesCount() > 0) {
                    for (UserEvent ci : userEvents) {
                        c.output(FAILURE_TAG, (Object)ci);
                    }
                } else {
                    for (UserEvent ci : userEvents) {
                        c.output(SUCCESS_TAG, (Object)ci);
                    }
                }
            }
            catch (ApiException e) {
                for (UserEvent ci : userEvents) {
                    c.output(FAILURE_TAG, (Object)ci);
                }
            }
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setProjectId(@Nullable @UnknownKeyFor @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCatalogName(@Nullable @UnknownKeyFor @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setEventStore(@Nullable @UnknownKeyFor @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setBatchSize(@UnknownKeyFor @NonNull @Initialized Integer var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxBufferingDuration(@UnknownKeyFor @NonNull @Initialized Duration var1);

        public abstract @UnknownKeyFor @NonNull @Initialized RecommendationAIImportUserEvents build();
    }
}

