/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.io.ObjectStreamClass;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.protobuf.DynamicProtoCoder;
import org.apache.beam.sdk.extensions.protobuf.IsDynamicMessageEqual;
import org.apache.beam.sdk.extensions.protobuf.Proto2CoderTestMessages;
import org.apache.beam.sdk.testing.CoderProperties;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DynamicProtoCoderTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testDynamicMessage() throws Exception {
        DynamicMessage message = DynamicMessage.newBuilder((Descriptors.Descriptor)Proto2CoderTestMessages.MessageA.getDescriptor()).setField(Proto2CoderTestMessages.MessageA.getDescriptor().findFieldByNumber(1), (Object)"foo").build();
        DynamicProtoCoder coder = DynamicProtoCoder.of((Descriptors.Descriptor)message.getDescriptorForType());
        for (Coder.Context context : CoderProperties.ALL_CONTEXTS) {
            CoderProperties.coderDecodeEncodeInContext((Coder)coder, (Coder.Context)context, (Object)message, (Matcher)IsDynamicMessageEqual.equalTo(message));
        }
    }

    @Test
    public void testDynamicNestedRepeatedMessage() throws Exception {
        DynamicMessage message = DynamicMessage.newBuilder((Descriptors.Descriptor)Proto2CoderTestMessages.MessageA.getDescriptor()).setField(Proto2CoderTestMessages.MessageA.getDescriptor().findFieldByNumber(1), (Object)"foo").addRepeatedField(Proto2CoderTestMessages.MessageA.getDescriptor().findFieldByNumber(2), (Object)DynamicMessage.newBuilder((Descriptors.Descriptor)Proto2CoderTestMessages.MessageB.getDescriptor()).setField(Proto2CoderTestMessages.MessageB.getDescriptor().findFieldByNumber(1), (Object)true).build()).addRepeatedField(Proto2CoderTestMessages.MessageA.getDescriptor().findFieldByNumber(2), (Object)DynamicMessage.newBuilder((Descriptors.Descriptor)Proto2CoderTestMessages.MessageB.getDescriptor()).setField(Proto2CoderTestMessages.MessageB.getDescriptor().findFieldByNumber(1), (Object)false).build()).build();
        DynamicProtoCoder coder = DynamicProtoCoder.of((Descriptors.Descriptor)message.getDescriptorForType());
        for (Coder.Context context : CoderProperties.ALL_CONTEXTS) {
            CoderProperties.coderDecodeEncodeInContext((Coder)coder, (Coder.Context)context, (Object)message, (Matcher)IsDynamicMessageEqual.equalTo(message));
        }
    }

    @Test
    public void testSerialVersionID() {
        long serialVersionID = ObjectStreamClass.lookup(DynamicProtoCoder.class).getSerialVersionUID();
        Assert.assertEquals((long)1L, (long)serialVersionID);
    }
}

