/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import org.apache.beam.sdk.extensions.protobuf.ProtoByteBuddyUtils;
import org.apache.beam.sdk.extensions.protobuf.ProtoByteBuddyUtilsMessages;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ProtoByteBuddyUtilsTest {
    private static final String PROTO_PROPERTY_WITH_UNDERSCORE = "foo_bar_id";
    private static final String PROTO_PROPERTY_WITH_NUMBER = "foo2bar_id";
    private static final String JAVA_PROPERTY_FOR_PROTO_PROPERTY_WITH_UNDERSCORE = "FooBarId";
    private static final String JAVA_PROPERTY_FOR_PROTO_PROPERTY_WITH_NUMBER = "Foo2BarId";

    @Test
    public void testGetterNameCreationForProtoPropertyWithUnderscore() {
        Assert.assertEquals((Object)JAVA_PROPERTY_FOR_PROTO_PROPERTY_WITH_UNDERSCORE, (Object)ProtoByteBuddyUtils.convertProtoPropertyNameToJavaPropertyName((String)PROTO_PROPERTY_WITH_UNDERSCORE));
    }

    @Test
    public void testGetterNameCreationForProtoPropertyWithNumber() {
        Assert.assertEquals((Object)JAVA_PROPERTY_FOR_PROTO_PROPERTY_WITH_NUMBER, (Object)ProtoByteBuddyUtils.convertProtoPropertyNameToJavaPropertyName((String)PROTO_PROPERTY_WITH_NUMBER));
    }

    @Test
    public void testGetterExistenceForProtoPropertyWithUnderscore() {
        try {
            Assert.assertNotNull((Object)ProtoByteBuddyUtilsMessages.ProtoByteBuddyUtilsMessageWithUnderscore.class.getMethod("getFooBarId", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            Assert.fail((String)("Unable to find expected getter method for foo_bar_id -> " + e));
        }
    }

    @Test
    public void testGetterExistenceForProtoPropertyWithNumber() {
        try {
            Assert.assertNotNull((Object)ProtoByteBuddyUtilsMessages.ProtoByteBuddyUtilsMessageWithNumber.class.getMethod("getFoo2BarId", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            Assert.fail((String)("Unable to find expected getter method for Foo2BarId -> " + e));
        }
    }
}

