/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import java.util.Objects;
import org.apache.beam.sdk.extensions.protobuf.ProtoByteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ProtoByteUtilsTest {
    private static final String PROTO_STRING_SCHEMA = "syntax = \"proto3\";\n\nmessage MyMessage {\n  int32 id = 1;\n  string name = 2;\n  bool active = 3;\n\n  // Nested field\n  message Address {\n    string street = 1;\n    string city = 2;\n    string state = 3;\n    string zip_code = 4;\n  }\n\n  Address address = 4;\n}";
    private static final String PROTO_STRING_PACKAGE_SCHEMA = "syntax = \"proto3\";\npackage com.test.proto;\nmessage MyMessage {\n  int32 id = 1;\n  string name = 2;\n  bool active = 3;\n\n  // Nested field\n  message Address {\n    string street = 1;\n    string city = 2;\n    string state = 3;\n    string zip_code = 4;\n  }\n\n  Address address = 4;\n}";
    private static final String DESCRIPTOR_PATH = Objects.requireNonNull(ProtoByteUtilsTest.class.getResource("/proto_byte/file_descriptor/proto_byte_utils.pb")).getPath();
    private static final String MESSAGE_NAME = "MyMessage";
    private static final Schema SCHEMA = Schema.builder().addField("id", Schema.FieldType.INT32).addField("name", Schema.FieldType.STRING).addField("active", Schema.FieldType.BOOLEAN).addField("address", Schema.FieldType.row((Schema)Schema.builder().addField("city", Schema.FieldType.STRING).addField("street", Schema.FieldType.STRING).addField("state", Schema.FieldType.STRING).addField("zip_code", Schema.FieldType.STRING).build())).build();

    @Test
    public void testProtoSchemaToBeamSchema() {
        Schema schema = ProtoByteUtils.getBeamSchemaFromProto((String)DESCRIPTOR_PATH, (String)MESSAGE_NAME);
        Assert.assertEquals((Object)schema.getFieldNames(), (Object)SCHEMA.getFieldNames());
    }

    @Test
    public void testProtoSchemaStringToBeamSchema() {
        Schema schema = ProtoByteUtils.getBeamSchemaFromProtoSchema((String)PROTO_STRING_SCHEMA, (String)MESSAGE_NAME);
        Assert.assertEquals((Object)schema.getFieldNames(), (Object)SCHEMA.getFieldNames());
    }

    @Test
    public void testProtoSchemaWitPackageStringToBeamSchema() {
        Schema schema = ProtoByteUtils.getBeamSchemaFromProtoSchema((String)PROTO_STRING_PACKAGE_SCHEMA, (String)"com.test.proto.MyMessage");
        Assert.assertEquals((Object)schema.getFieldNames(), (Object)SCHEMA.getFieldNames());
    }

    @Test
    public void testProtoBytesToRowFunctionGenerateSerializableFunction() {
        SerializableFunction protoBytesToRowFunction = ProtoByteUtils.getProtoBytesToRowFunction((String)DESCRIPTOR_PATH, (String)MESSAGE_NAME);
        Assert.assertNotNull((Object)protoBytesToRowFunction);
    }

    @Test
    public void testProtoBytesToRowSchemaStringGenerateSerializableFunction() {
        SerializableFunction protoBytesToRowFunction = ProtoByteUtils.getProtoBytesToRowFromSchemaFunction((String)PROTO_STRING_SCHEMA, (String)MESSAGE_NAME);
        Assert.assertNotNull((Object)protoBytesToRowFunction);
    }

    @Test(expected=RuntimeException.class)
    public void testProtoBytesToRowFunctionReturnsRowFailure() {
        SerializableFunction protoBytesToRowFunction = ProtoByteUtils.getProtoBytesToRowFunction((String)DESCRIPTOR_PATH, (String)MESSAGE_NAME);
        byte[] inputBytes = new byte[]{1, 2, 3, 4, 5};
        protoBytesToRowFunction.apply((Object)inputBytes);
    }

    @Test
    public void testProtoBytesToRowFunctionReturnsRowSuccess() {
        SerializableFunction protoBytesToRowFunction = ProtoByteUtils.getProtoBytesToRowFunction((String)DESCRIPTOR_PATH, (String)MESSAGE_NAME);
        byte[] byteArray = new byte[]{8, -46, 9, 18, 3, 68, 111, 101, 34, 35, 10, 7, 115, 101, 97, 116, 116, 108, 101, 18, 11, 102, 97, 107, 101, 32, 115, 116, 114, 101, 101, 116, 26, 2, 119, 97, 34, 7, 84, 79, 45, 49, 50, 51, 52};
        Row row = (Row)protoBytesToRowFunction.apply((Object)byteArray);
        Assert.assertEquals((Object)"Doe", (Object)row.getValue("name"));
    }

    @Test
    public void testRowToProtoFunction() {
        Row row = Row.withSchema((Schema)SCHEMA).withFieldValue("id", (Object)1234).withFieldValue("name", (Object)"Doe").withFieldValue("active", (Object)false).withFieldValue("address.city", (Object)"seattle").withFieldValue("address.street", (Object)"fake street").withFieldValue("address.zip_code", (Object)"TO-1234").withFieldValue("address.state", (Object)"wa").build();
        Assert.assertNotNull((Object)ProtoByteUtils.getRowToProtoBytes((String)DESCRIPTOR_PATH, (String)MESSAGE_NAME).apply((Object)row));
    }

    @Test
    public void testRowToProtoSchemaFunction() {
        Row row = Row.withSchema((Schema)SCHEMA).withFieldValue("id", (Object)1234).withFieldValue("name", (Object)"Doe").withFieldValue("active", (Object)false).withFieldValue("address.city", (Object)"seattle").withFieldValue("address.street", (Object)"fake street").withFieldValue("address.zip_code", (Object)"TO-1234").withFieldValue("address.state", (Object)"wa").build();
        Assert.assertNotNull((Object)ProtoByteUtils.getRowToProtoBytesFromSchema((String)PROTO_STRING_SCHEMA, (String)MESSAGE_NAME).apply((Object)row));
    }

    @Test
    public void testRowToProtoSchemaWithPackageFunction() {
        Row row = Row.withSchema((Schema)SCHEMA).withFieldValue("id", (Object)1234).withFieldValue("name", (Object)"Doe").withFieldValue("active", (Object)false).withFieldValue("address.city", (Object)"seattle").withFieldValue("address.street", (Object)"fake street").withFieldValue("address.zip_code", (Object)"TO-1234").withFieldValue("address.state", (Object)"wa").build();
        byte[] byteArray = new byte[]{8, -46, 9, 18, 3, 68, 111, 101, 34, 35, 10, 7, 115, 101, 97, 116, 116, 108, 101, 18, 11, 102, 97, 107, 101, 32, 115, 116, 114, 101, 101, 116, 26, 2, 119, 97, 34, 7, 84, 79, 45, 49, 50, 51, 52};
        byte[] resultBytes = (byte[])ProtoByteUtils.getRowToProtoBytesFromSchema((String)PROTO_STRING_PACKAGE_SCHEMA, (String)"com.test.proto.MyMessage").apply((Object)row);
        Assert.assertNotNull((Object)resultBytes);
        Assert.assertArrayEquals((byte[])byteArray, (byte[])resultBytes);
    }
}

