/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface BeamRelNode
extends RelNode {
    default public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
        return this.getPCollectionInputs().stream().allMatch(rel -> BeamSqlRelUtils.getBeamRelInput(rel).isBounded() == PCollection.IsBounded.BOUNDED) ? PCollection.IsBounded.BOUNDED : PCollection.IsBounded.UNBOUNDED;
    }

    default public void withErrorsTransformer(@Nullable @UnknownKeyFor @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized POutput> ptransform) {
    }

    default public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RelNode> getPCollectionInputs() {
        return this.getInputs();
    }

    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildPTransform();

    default public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildPTransform(@Nullable @UnknownKeyFor @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized POutput> errorsTransformer) {
        return this.buildPTransform();
    }

    default public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getPipelineOptions() {
        Map<String, String> options = null;
        for (RelNode input : this.getInputs()) {
            Map<String, String> inputOptions = ((BeamRelNode)input).getPipelineOptions();
            if (!1.$assertionsDisabled && inputOptions == null) {
                throw new AssertionError();
            }
            if (!1.$assertionsDisabled && options != null && options != inputOptions) {
                throw new AssertionError();
            }
            options = inputOptions;
        }
        return options;
    }

    public @UnknownKeyFor @NonNull @Initialized NodeStats estimateNodeStats(@UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery var1);

    public @UnknownKeyFor @NonNull @Initialized BeamCostModel beamComputeSelfCost(@UnknownKeyFor @NonNull @Initialized RelOptPlanner var1, @UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery var2);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

