/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableUtils;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.Pair;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

public class TestUnboundedTable
extends TestTable {
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Pair<@UnknownKeyFor @NonNull @Initialized Duration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row>>> timestampedRows = new ArrayList<Pair<Duration, List<Row>>>();
    private @UnknownKeyFor @NonNull @Initialized int timestampField;
    private @UnknownKeyFor @NonNull @Initialized BeamTableStatistics statistics = BeamTableStatistics.UNBOUNDED_UNKNOWN;

    private TestUnboundedTable(@UnknownKeyFor @NonNull @Initialized Schema beamSchema) {
        super(beamSchema);
    }

    public static @UnknownKeyFor @NonNull @Initialized TestUnboundedTable of(Object ... args) {
        return new TestUnboundedTable(TestTableUtils.buildBeamSqlSchema(args));
    }

    public @UnknownKeyFor @NonNull @Initialized TestUnboundedTable setStatistics(@UnknownKeyFor @NonNull @Initialized BeamTableStatistics statistics) {
        this.statistics = statistics;
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamTableStatistics getTableStatistics(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return this.statistics;
    }

    public @UnknownKeyFor @NonNull @Initialized TestUnboundedTable timestampColumnIndex(@UnknownKeyFor @NonNull @Initialized int idx) {
        this.timestampField = idx;
        return this;
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.UNBOUNDED;
    }

    public @UnknownKeyFor @NonNull @Initialized TestUnboundedTable addRows(@UnknownKeyFor @NonNull @Initialized Duration duration, Object ... args) {
        List<Row> rows = TestTableUtils.buildRows(this.getSchema(), Arrays.asList(args));
        this.timestampedRows.add((Pair<Duration, List<Row>>)Pair.of((Object)duration, rows));
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> buildIOReader(@UnknownKeyFor @NonNull @Initialized PBegin begin) {
        TestStream.Builder values = TestStream.create((Schema)this.schema);
        for (Pair<Duration, List<Row>> pair : this.timestampedRows) {
            values = values.advanceWatermarkTo(new Instant(0L).plus((ReadableDuration)pair.getKey()));
            for (int i = 0; i < ((List)pair.getValue()).size(); ++i) {
                values = values.addElements(TimestampedValue.of((Object)((Row)((List)pair.getValue()).get(i)), (Instant)new Instant((Object)((Row)((List)pair.getValue()).get(i)).getDateTime(this.timestampField))), new TimestampedValue[0]);
            }
        }
        return ((PCollection)begin.apply("MockedUnboundedTable_" + COUNTER.incrementAndGet(), (PTransform)values.advanceWatermarkToInfinity())).setRowSchema(this.getSchema());
    }
}

