/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform.agg;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.VarianceAccumulator;
import org.apache.beam.sdk.extensions.sql.impl.utils.BigDecimalConverter;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.runtime.SqlFunctions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class VarianceFn<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized Number>
extends Combine.CombineFn<T, VarianceAccumulator, T> {
    static final @UnknownKeyFor @NonNull @Initialized MathContext MATH_CTX = new MathContext(10, RoundingMode.HALF_UP);
    private static final @UnknownKeyFor @NonNull @Initialized boolean SAMPLE = true;
    private static final @UnknownKeyFor @NonNull @Initialized boolean POP = false;
    private @UnknownKeyFor @NonNull @Initialized boolean isSample;
    private @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized BigDecimal, T> decimalConverter;

    public static <V extends Number> @UnknownKeyFor @NonNull @Initialized VarianceFn newPopulation(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.TypeName typeName) {
        return VarianceFn.newPopulation(BigDecimalConverter.forSqlType(typeName));
    }

    public static <V extends Number> @UnknownKeyFor @NonNull @Initialized VarianceFn newPopulation(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized BigDecimal, V> decimalConverter) {
        return new VarianceFn<V>(false, decimalConverter);
    }

    public static <V extends Number> @UnknownKeyFor @NonNull @Initialized VarianceFn newSample(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.TypeName typeName) {
        return VarianceFn.newSample(BigDecimalConverter.forSqlType(typeName));
    }

    public static <V extends Number> @UnknownKeyFor @NonNull @Initialized VarianceFn newSample(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized BigDecimal, V> decimalConverter) {
        return new VarianceFn<V>(true, decimalConverter);
    }

    private VarianceFn(@UnknownKeyFor @NonNull @Initialized boolean isSample, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized BigDecimal, T> decimalConverter) {
        this.isSample = isSample;
        this.decimalConverter = decimalConverter;
    }

    public @UnknownKeyFor @NonNull @Initialized VarianceAccumulator createAccumulator() {
        return VarianceAccumulator.ofZeroElements();
    }

    public @UnknownKeyFor @NonNull @Initialized VarianceAccumulator addInput(@UnknownKeyFor @NonNull @Initialized VarianceAccumulator currentVariance, T rawInput) {
        if (rawInput == null) {
            return currentVariance;
        }
        return currentVariance.combineWith(VarianceAccumulator.ofSingleElement(SqlFunctions.toBigDecimal(rawInput)));
    }

    public @UnknownKeyFor @NonNull @Initialized VarianceAccumulator mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized VarianceAccumulator> variances) {
        return StreamSupport.stream(variances.spliterator(), false).reduce(VarianceAccumulator.ofZeroElements(), VarianceAccumulator::combineWith);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized VarianceAccumulator> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<T> inputCoder) {
        return SerializableCoder.of(VarianceAccumulator.class);
    }

    public T extractOutput(@UnknownKeyFor @NonNull @Initialized VarianceAccumulator accumulator) {
        return (T)((Number)this.decimalConverter.apply((Object)this.getVariance(accumulator)));
    }

    private @UnknownKeyFor @NonNull @Initialized BigDecimal getVariance(@UnknownKeyFor @NonNull @Initialized VarianceAccumulator variance) {
        BigDecimal adjustedCount;
        BigDecimal bigDecimal = adjustedCount = this.isSample ? variance.count().subtract(BigDecimal.ONE) : variance.count();
        if (adjustedCount.equals(BigDecimal.ZERO)) {
            return BigDecimal.ZERO;
        }
        return variance.variance().divide(adjustedCount, MATH_CTX);
    }
}

