/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@ThreadSafe
public class CancellableQueue<@UnknownKeyFor T> {
    private final @UnknownKeyFor @NonNull @Initialized int capacity;
    private final @Nullable @UnknownKeyFor @Initialized Object @UnknownKeyFor @NonNull @Initialized [] elements;
    private final @UnknownKeyFor @NonNull @Initialized Lock lock;
    private final @UnknownKeyFor @NonNull @Initialized Condition notFull;
    private final @UnknownKeyFor @NonNull @Initialized Condition notEmpty;
    @UnknownKeyFor @NonNull @Initialized int addIndex;
    @UnknownKeyFor @NonNull @Initialized int takeIndex;
    @UnknownKeyFor @NonNull @Initialized int count;
    @Nullable @UnknownKeyFor @Initialized Exception cancellationException;

    public CancellableQueue(@UnknownKeyFor @NonNull @Initialized int capacity) {
        this.capacity = capacity;
        this.elements = new Object[capacity];
        this.lock = new ReentrantLock();
        this.notFull = this.lock.newCondition();
        this.notEmpty = this.lock.newCondition();
    }

    public void put(T t) throws @UnknownKeyFor @NonNull @Initialized Exception, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        try {
            this.lock.lockInterruptibly();
            while (this.count >= this.capacity && this.cancellationException == null) {
                this.notFull.await();
            }
            if (this.cancellationException != null) {
                throw this.cancellationException;
            }
            this.elements[this.addIndex] = t;
            this.addIndex = (this.addIndex + 1) % this.elements.length;
            ++this.count;
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public T take() throws @UnknownKeyFor @NonNull @Initialized Exception, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Object rval;
        try {
            this.lock.lockInterruptibly();
            while (this.count == 0 && this.cancellationException == null) {
                this.notEmpty.await();
            }
            if (this.cancellationException != null) {
                throw this.cancellationException;
            }
            rval = this.elements[this.takeIndex];
            this.elements[this.takeIndex] = null;
            this.takeIndex = (this.takeIndex + 1) % this.elements.length;
            --this.count;
            this.notFull.signal();
        }
        finally {
            this.lock.unlock();
        }
        return (T)rval;
    }

    public void cancel(@UnknownKeyFor @NonNull @Initialized Exception exception) {
        Preconditions.checkNotNull((Object)exception);
        this.lock.lock();
        try {
            if (this.cancellationException == null) {
                this.cancellationException = exception;
                this.clearElementsLocked();
            }
            this.notEmpty.signalAll();
            this.notFull.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void clearElementsLocked() {
        int i = this.takeIndex;
        while (this.count > 0) {
            this.elements[i] = null;
            --this.count;
            i = (i + 1) % this.elements.length;
        }
        this.addIndex = 0;
        this.takeIndex = 0;
    }

    public void reset() {
        this.lock.lock();
        try {
            this.cancellationException = null;
            this.clearElementsLocked();
        }
        finally {
            this.lock.unlock();
        }
    }
}

