/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonObjectParser;
import com.google.auth.RequestMetadataCallback;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.AwsCredentials;
import com.google.auth.oauth2.CredentialFormatException;
import com.google.auth.oauth2.EnvironmentProvider;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.IdentityPoolCredentials;
import com.google.auth.oauth2.ImpersonatedCredentials;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.QuotaProjectIdProvider;
import com.google.auth.oauth2.StsRequestHandler;
import com.google.auth.oauth2.StsTokenExchangeRequest;
import com.google.auth.oauth2.StsTokenExchangeResponse;
import com.google.auth.oauth2.SystemEnvironmentProvider;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public abstract class ExternalAccountCredentials
extends GoogleCredentials
implements QuotaProjectIdProvider {
    private static final String CLOUD_PLATFORM_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    static final String EXTERNAL_ACCOUNT_FILE_TYPE = "external_account";
    private final String transportFactoryClassName;
    private final String audience;
    private final String subjectTokenType;
    private final String tokenUrl;
    private final CredentialSource credentialSource;
    private final Collection<String> scopes;
    @Nullable
    private final String tokenInfoUrl;
    @Nullable
    private final String serviceAccountImpersonationUrl;
    @Nullable
    private final String quotaProjectId;
    @Nullable
    private final String clientId;
    @Nullable
    private final String clientSecret;
    protected transient HttpTransportFactory transportFactory;
    @Nullable
    protected final ImpersonatedCredentials impersonatedCredentials;
    private EnvironmentProvider environmentProvider;

    protected ExternalAccountCredentials(HttpTransportFactory transportFactory, String audience, String subjectTokenType, String tokenUrl, CredentialSource credentialSource, @Nullable String tokenInfoUrl, @Nullable String serviceAccountImpersonationUrl, @Nullable String quotaProjectId, @Nullable String clientId, @Nullable String clientSecret, @Nullable Collection<String> scopes) {
        this(transportFactory, audience, subjectTokenType, tokenUrl, credentialSource, tokenInfoUrl, serviceAccountImpersonationUrl, quotaProjectId, clientId, clientSecret, scopes, null);
    }

    protected ExternalAccountCredentials(HttpTransportFactory transportFactory, String audience, String subjectTokenType, String tokenUrl, CredentialSource credentialSource, @Nullable String tokenInfoUrl, @Nullable String serviceAccountImpersonationUrl, @Nullable String quotaProjectId, @Nullable String clientId, @Nullable String clientSecret, @Nullable Collection<String> scopes, @Nullable EnvironmentProvider environmentProvider) {
        this.transportFactory = MoreObjects.firstNonNull(transportFactory, ExternalAccountCredentials.getFromServiceLoader(HttpTransportFactory.class, OAuth2Utils.HTTP_TRANSPORT_FACTORY));
        this.transportFactoryClassName = Preconditions.checkNotNull(this.transportFactory.getClass().getName());
        this.audience = Preconditions.checkNotNull(audience);
        this.subjectTokenType = Preconditions.checkNotNull(subjectTokenType);
        this.tokenUrl = Preconditions.checkNotNull(tokenUrl);
        this.credentialSource = Preconditions.checkNotNull(credentialSource);
        this.tokenInfoUrl = tokenInfoUrl;
        this.serviceAccountImpersonationUrl = serviceAccountImpersonationUrl;
        this.quotaProjectId = quotaProjectId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scopes = scopes == null || scopes.isEmpty() ? Arrays.asList(CLOUD_PLATFORM_SCOPE) : scopes;
        this.environmentProvider = environmentProvider == null ? SystemEnvironmentProvider.getInstance() : environmentProvider;
        ExternalAccountCredentials.validateTokenUrl(tokenUrl);
        if (serviceAccountImpersonationUrl != null) {
            ExternalAccountCredentials.validateServiceAccountImpersonationInfoUrl(serviceAccountImpersonationUrl);
        }
        this.impersonatedCredentials = this.initializeImpersonatedCredentials();
    }

    private ImpersonatedCredentials initializeImpersonatedCredentials() {
        if (this.serviceAccountImpersonationUrl == null) {
            return null;
        }
        ExternalAccountCredentials sourceCredentials = this instanceof AwsCredentials ? AwsCredentials.newBuilder((AwsCredentials)this).setServiceAccountImpersonationUrl(null).build() : IdentityPoolCredentials.newBuilder((IdentityPoolCredentials)this).setServiceAccountImpersonationUrl(null).build();
        String targetPrincipal = ImpersonatedCredentials.extractTargetPrincipal(this.serviceAccountImpersonationUrl);
        return ImpersonatedCredentials.newBuilder().setSourceCredentials(sourceCredentials).setHttpTransportFactory(this.transportFactory).setTargetPrincipal(targetPrincipal).setScopes(new ArrayList<String>(this.scopes)).setLifetime(3600).build();
    }

    @Override
    public void getRequestMetadata(URI uri, Executor executor, final RequestMetadataCallback callback) {
        super.getRequestMetadata(uri, executor, new RequestMetadataCallback(){

            @Override
            public void onSuccess(Map<String, List<String>> metadata) {
                metadata = GoogleCredentials.addQuotaProjectIdToRequestMetadata(ExternalAccountCredentials.this.quotaProjectId, metadata);
                callback.onSuccess(metadata);
            }

            @Override
            public void onFailure(Throwable exception) {
                callback.onFailure(exception);
            }
        });
    }

    @Override
    public Map<String, List<String>> getRequestMetadata(URI uri) throws IOException {
        Map<String, List<String>> requestMetadata = super.getRequestMetadata(uri);
        return ExternalAccountCredentials.addQuotaProjectIdToRequestMetadata(this.quotaProjectId, requestMetadata);
    }

    public static ExternalAccountCredentials fromStream(InputStream credentialsStream) throws IOException {
        return ExternalAccountCredentials.fromStream(credentialsStream, OAuth2Utils.HTTP_TRANSPORT_FACTORY);
    }

    public static ExternalAccountCredentials fromStream(InputStream credentialsStream, HttpTransportFactory transportFactory) throws IOException {
        Preconditions.checkNotNull(credentialsStream);
        Preconditions.checkNotNull(transportFactory);
        JsonObjectParser parser = new JsonObjectParser(OAuth2Utils.JSON_FACTORY);
        GenericJson fileContents = parser.parseAndClose(credentialsStream, StandardCharsets.UTF_8, GenericJson.class);
        try {
            return ExternalAccountCredentials.fromJson(fileContents, transportFactory);
        }
        catch (ClassCastException e) {
            throw new CredentialFormatException("An invalid input stream was provided.", e);
        }
    }

    static ExternalAccountCredentials fromJson(Map<String, Object> json, HttpTransportFactory transportFactory) {
        Preconditions.checkNotNull(json);
        Preconditions.checkNotNull(transportFactory);
        String audience = (String)json.get("audience");
        String subjectTokenType = (String)json.get("subject_token_type");
        String tokenUrl = (String)json.get("token_url");
        String serviceAccountImpersonationUrl = (String)json.get("service_account_impersonation_url");
        Map credentialSourceMap = (Map)json.get("credential_source");
        String tokenInfoUrl = (String)json.get("token_info_url");
        String clientId = (String)json.get("client_id");
        String clientSecret = (String)json.get("client_secret");
        String quotaProjectId = (String)json.get("quota_project_id");
        if (ExternalAccountCredentials.isAwsCredential(credentialSourceMap)) {
            return new AwsCredentials(transportFactory, audience, subjectTokenType, tokenUrl, new AwsCredentials.AwsCredentialSource(credentialSourceMap), tokenInfoUrl, serviceAccountImpersonationUrl, quotaProjectId, clientId, clientSecret, null, null);
        }
        return new IdentityPoolCredentials(transportFactory, audience, subjectTokenType, tokenUrl, new IdentityPoolCredentials.IdentityPoolCredentialSource(credentialSourceMap), tokenInfoUrl, serviceAccountImpersonationUrl, quotaProjectId, clientId, clientSecret, null, null);
    }

    private static boolean isAwsCredential(Map<String, Object> credentialSource) {
        return credentialSource.containsKey("environment_id") && ((String)credentialSource.get("environment_id")).startsWith("aws");
    }

    protected AccessToken exchangeExternalCredentialForAccessToken(StsTokenExchangeRequest stsTokenExchangeRequest) throws IOException {
        if (this.impersonatedCredentials != null) {
            return this.impersonatedCredentials.refreshAccessToken();
        }
        StsRequestHandler requestHandler = StsRequestHandler.newBuilder(this.tokenUrl, stsTokenExchangeRequest, this.transportFactory.create().createRequestFactory()).build();
        StsTokenExchangeResponse response = requestHandler.exchangeToken();
        return response.getAccessToken();
    }

    public abstract String retrieveSubjectToken() throws IOException;

    public String getAudience() {
        return this.audience;
    }

    public String getSubjectTokenType() {
        return this.subjectTokenType;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public String getTokenInfoUrl() {
        return this.tokenInfoUrl;
    }

    public CredentialSource getCredentialSource() {
        return this.credentialSource;
    }

    @Nullable
    public String getServiceAccountImpersonationUrl() {
        return this.serviceAccountImpersonationUrl;
    }

    @Override
    @Nullable
    public String getQuotaProjectId() {
        return this.quotaProjectId;
    }

    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Nullable
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Nullable
    public Collection<String> getScopes() {
        return this.scopes;
    }

    EnvironmentProvider getEnvironmentProvider() {
        return this.environmentProvider;
    }

    static void validateTokenUrl(String tokenUrl) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        patterns.add(Pattern.compile("^[^\\.\\s\\/\\\\]+\\.sts\\.googleapis\\.com$"));
        patterns.add(Pattern.compile("^sts\\.googleapis\\.com$"));
        patterns.add(Pattern.compile("^sts\\.[^\\.\\s\\/\\\\]+\\.googleapis\\.com$"));
        patterns.add(Pattern.compile("^[^\\.\\s\\/\\\\]+\\-sts\\.googleapis\\.com$"));
        if (!ExternalAccountCredentials.isValidUrl(patterns, tokenUrl)) {
            throw new IllegalArgumentException("The provided token URL is invalid.");
        }
    }

    static void validateServiceAccountImpersonationInfoUrl(String serviceAccountImpersonationUrl) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        patterns.add(Pattern.compile("^[^\\.\\s\\/\\\\]+\\.iamcredentials\\.googleapis\\.com$"));
        patterns.add(Pattern.compile("^iamcredentials\\.googleapis\\.com$"));
        patterns.add(Pattern.compile("^iamcredentials\\.[^\\.\\s\\/\\\\]+\\.googleapis\\.com$"));
        patterns.add(Pattern.compile("^[^\\.\\s\\/\\\\]+\\-iamcredentials\\.googleapis\\.com$"));
        if (!ExternalAccountCredentials.isValidUrl(patterns, serviceAccountImpersonationUrl)) {
            throw new IllegalArgumentException("The provided service account impersonation URL is invalid.");
        }
    }

    private static boolean isValidUrl(List<Pattern> patterns, String url) {
        URI uri;
        try {
            uri = URI.create(url);
        }
        catch (Exception e) {
            return false;
        }
        if (uri.getScheme() == null || uri.getHost() == null || !"https".equals(uri.getScheme().toLowerCase(Locale.US))) {
            return false;
        }
        for (Pattern pattern : patterns) {
            Matcher match = pattern.matcher(uri.getHost().toLowerCase(Locale.US));
            if (!match.matches()) continue;
            return true;
        }
        return false;
    }

    public static abstract class Builder
    extends GoogleCredentials.Builder {
        protected String audience;
        protected String subjectTokenType;
        protected String tokenUrl;
        protected String tokenInfoUrl;
        protected CredentialSource credentialSource;
        protected EnvironmentProvider environmentProvider;
        protected HttpTransportFactory transportFactory;
        @Nullable
        protected String serviceAccountImpersonationUrl;
        @Nullable
        protected String quotaProjectId;
        @Nullable
        protected String clientId;
        @Nullable
        protected String clientSecret;
        @Nullable
        protected Collection<String> scopes;

        protected Builder() {
        }

        protected Builder(ExternalAccountCredentials credentials) {
            this.transportFactory = credentials.transportFactory;
            this.audience = credentials.audience;
            this.subjectTokenType = credentials.subjectTokenType;
            this.tokenUrl = credentials.tokenUrl;
            this.tokenInfoUrl = credentials.tokenInfoUrl;
            this.serviceAccountImpersonationUrl = credentials.serviceAccountImpersonationUrl;
            this.credentialSource = credentials.credentialSource;
            this.quotaProjectId = credentials.quotaProjectId;
            this.clientId = credentials.clientId;
            this.clientSecret = credentials.clientSecret;
            this.scopes = credentials.scopes;
            this.environmentProvider = credentials.environmentProvider;
        }

        public Builder setAudience(String audience) {
            this.audience = audience;
            return this;
        }

        public Builder setSubjectTokenType(String subjectTokenType) {
            this.subjectTokenType = subjectTokenType;
            return this;
        }

        public Builder setTokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public Builder setTokenInfoUrl(String tokenInfoUrl) {
            this.tokenInfoUrl = tokenInfoUrl;
            return this;
        }

        public Builder setServiceAccountImpersonationUrl(String serviceAccountImpersonationUrl) {
            this.serviceAccountImpersonationUrl = serviceAccountImpersonationUrl;
            return this;
        }

        public Builder setCredentialSource(CredentialSource credentialSource) {
            this.credentialSource = credentialSource;
            return this;
        }

        public Builder setScopes(Collection<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder setQuotaProjectId(String quotaProjectId) {
            this.quotaProjectId = quotaProjectId;
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder setHttpTransportFactory(HttpTransportFactory transportFactory) {
            this.transportFactory = transportFactory;
            return this;
        }

        Builder setEnvironmentProvider(EnvironmentProvider environmentProvider) {
            this.environmentProvider = environmentProvider;
            return this;
        }

        @Override
        public abstract ExternalAccountCredentials build();
    }

    static abstract class CredentialSource {
        CredentialSource(Map<String, Object> credentialSourceMap) {
            Preconditions.checkNotNull(credentialSourceMap);
        }
    }
}

