/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ChainingHttpRequestInitializer
implements HttpRequestInitializer {
    private final List<HttpRequestInitializer> initializers;

    public ChainingHttpRequestInitializer(HttpRequestInitializer ... initializers) {
        this.initializers = ImmutableList.copyOf(initializers);
    }

    @Override
    public void initialize(HttpRequest request) throws IOException {
        ArrayList<HttpIOExceptionHandler> ioExceptionHandlers = new ArrayList<HttpIOExceptionHandler>();
        ArrayList<HttpUnsuccessfulResponseHandler> unsuccessfulResponseHandlers = new ArrayList<HttpUnsuccessfulResponseHandler>();
        ArrayList<HttpExecuteInterceptor> interceptors = new ArrayList<HttpExecuteInterceptor>();
        ArrayList<HttpResponseInterceptor> responseInterceptors = new ArrayList<HttpResponseInterceptor>();
        for (HttpRequestInitializer initializer : this.initializers) {
            initializer.initialize(request);
            if (request.getIOExceptionHandler() != null) {
                ioExceptionHandlers.add(request.getIOExceptionHandler());
                request.setIOExceptionHandler(null);
            }
            if (request.getUnsuccessfulResponseHandler() != null) {
                unsuccessfulResponseHandlers.add(request.getUnsuccessfulResponseHandler());
                request.setUnsuccessfulResponseHandler(null);
            }
            if (request.getInterceptor() != null) {
                interceptors.add(request.getInterceptor());
                request.setInterceptor(null);
            }
            if (request.getResponseInterceptor() == null) continue;
            responseInterceptors.add(request.getResponseInterceptor());
            request.setResponseInterceptor(null);
        }
        request.setIOExceptionHandler(this.makeIoExceptionHandler(ioExceptionHandlers));
        request.setUnsuccessfulResponseHandler(this.makeUnsuccessfulResponseHandler(unsuccessfulResponseHandlers));
        request.setInterceptor(this.makeInterceptor(interceptors));
        request.setResponseInterceptor(this.makeResponseInterceptor(responseInterceptors));
    }

    private HttpResponseInterceptor makeResponseInterceptor(final Iterable<HttpResponseInterceptor> responseInterceptors) {
        return new HttpResponseInterceptor(){

            @Override
            public void interceptResponse(HttpResponse response) throws IOException {
                for (HttpResponseInterceptor interceptor : responseInterceptors) {
                    interceptor.interceptResponse(response);
                }
            }
        };
    }

    private HttpExecuteInterceptor makeInterceptor(final Iterable<HttpExecuteInterceptor> interceptors) {
        return new HttpExecuteInterceptor(){

            @Override
            public void intercept(HttpRequest request) throws IOException {
                for (HttpExecuteInterceptor interceptor : interceptors) {
                    interceptor.intercept(request);
                }
            }
        };
    }

    private HttpUnsuccessfulResponseHandler makeUnsuccessfulResponseHandler(final Iterable<HttpUnsuccessfulResponseHandler> unsuccessfulResponseHandlers) {
        return new HttpUnsuccessfulResponseHandler(){

            @Override
            public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
                for (HttpUnsuccessfulResponseHandler handler : unsuccessfulResponseHandlers) {
                    if (!handler.handleResponse(request, response, supportsRetry)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private HttpIOExceptionHandler makeIoExceptionHandler(final Iterable<HttpIOExceptionHandler> ioExceptionHandlers) {
        return new HttpIOExceptionHandler(){

            @Override
            public boolean handleIOException(HttpRequest request, boolean supportsRetry) throws IOException {
                for (HttpIOExceptionHandler handler : ioExceptionHandlers) {
                    if (!handler.handleIOException(request, supportsRetry)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

