/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.collect.ImmutableList;
import io.grpc.CallCredentials;
import io.grpc.ChannelCredentials;
import io.grpc.CompositeChannelCredentials;
import io.grpc.Status;
import io.grpc.alts.FailingCallCredentials;
import io.grpc.alts.HandshakerServiceChannel;
import io.grpc.alts.internal.AltsProtocolNegotiator;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.internal.SharedResourcePool;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelCredentials;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.io.IOException;
import javax.net.ssl.SSLException;

public final class GoogleDefaultChannelCredentials {
    private GoogleDefaultChannelCredentials() {
    }

    public static ChannelCredentials create() {
        CallCredentials callCredentials;
        ChannelCredentials nettyCredentials = InternalNettyChannelCredentials.create(GoogleDefaultChannelCredentials.createClientFactory());
        try {
            callCredentials = MoreCallCredentials.from(GoogleCredentials.getApplicationDefault());
        }
        catch (IOException e) {
            callCredentials = new FailingCallCredentials(Status.UNAUTHENTICATED.withDescription("Failed to get Google default credentials").withCause(e));
        }
        return CompositeChannelCredentials.create(nettyCredentials, callCredentials);
    }

    private static InternalProtocolNegotiator.ClientFactory createClientFactory() {
        SslContext sslContext;
        try {
            sslContext = GrpcSslContexts.forClient().build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        return new AltsProtocolNegotiator.GoogleDefaultProtocolNegotiatorFactory(ImmutableList.of(), SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL), sslContext);
    }
}

