/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import java.util.Collections;
import org.apache.beam.fn.harness.FnHarness;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.fnexecution.v1.BeamFnExternalWorkerPoolGrpc;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.runners.core.construction.Environments;
import org.apache.beam.runners.core.construction.PipelineOptionsTranslation;
import org.apache.beam.sdk.fn.server.FnService;
import org.apache.beam.sdk.fn.server.GrpcFnServer;
import org.apache.beam.sdk.fn.server.ServerFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalWorkerService
extends BeamFnExternalWorkerPoolGrpc.BeamFnExternalWorkerPoolImplBase
implements FnService {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalWorkerService.class);
    private static final String PIPELINE_OPTIONS_ENV_VAR = "PIPELINE_OPTIONS";
    private final PipelineOptions options;
    private final ServerFactory serverFactory = ServerFactory.createDefault();

    public ExternalWorkerService(PipelineOptions options) {
        this.options = options;
    }

    @Override
    public void startWorker(BeamFnApi.StartWorkerRequest request, StreamObserver<BeamFnApi.StartWorkerResponse> responseObserver) {
        LOG.info("Starting worker {} pointing at {}.", (Object)request.getWorkerId(), (Object)request.getControlEndpoint().getUrl());
        LOG.debug("Worker request {}.", (Object)request);
        Thread th = new Thread(() -> {
            try {
                FnHarness.main(request.getWorkerId(), this.options, Collections.emptySet(), request.getLoggingEndpoint(), request.getControlEndpoint(), null);
                LOG.info("Successfully started worker {}.", (Object)request.getWorkerId());
            }
            catch (Exception exn) {
                LOG.error(String.format("Failed to start worker %s.", request.getWorkerId()), exn);
            }
        });
        th.setName("SDK-worker-" + request.getWorkerId());
        th.setDaemon(true);
        th.start();
        responseObserver.onNext(BeamFnApi.StartWorkerResponse.newBuilder().build());
        responseObserver.onCompleted();
    }

    @Override
    public void stopWorker(BeamFnApi.StopWorkerRequest request, StreamObserver<BeamFnApi.StopWorkerResponse> responseObserver) {
        responseObserver.onNext(BeamFnApi.StopWorkerResponse.newBuilder().build());
        responseObserver.onCompleted();
    }

    @Override
    public void close() {
    }

    public GrpcFnServer<ExternalWorkerService> start() throws Exception {
        String externalServiceAddress = Environments.getExternalServiceAddress(this.options.as(PortablePipelineOptions.class));
        GrpcFnServer<ExternalWorkerService> server = externalServiceAddress.isEmpty() ? GrpcFnServer.allocatePortAndCreateFor(this, this.serverFactory) : GrpcFnServer.create(this, Endpoints.ApiServiceDescriptor.newBuilder().setUrl(externalServiceAddress).build(), this.serverFactory);
        LOG.debug("Listening for worker start requests at {}.", (Object)server.getApiServiceDescriptor().getUrl());
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        LOG.info("Starting external worker service");
        String optionsEnv = Preconditions.checkArgumentNotNull(System.getenv(PIPELINE_OPTIONS_ENV_VAR), "No pipeline options provided in environment variables PIPELINE_OPTIONS");
        LOG.info("Pipeline options {}", (Object)optionsEnv);
        PipelineOptions options = PipelineOptionsTranslation.fromJson(optionsEnv);
        try (GrpcFnServer<ExternalWorkerService> server = new ExternalWorkerService(options).start();){
            LOG.info("External worker service started at address: {}", (Object)server.getApiServiceDescriptor().getUrl());
            Sleeper.DEFAULT.sleep(Long.MAX_VALUE);
        }
        catch (Exception e) {
            LOG.error("Error running worker service", e);
        }
        finally {
            LOG.info("External worker service stopped.");
        }
    }
}

