/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.beam.fn.harness.PTransformRunnerFactory;
import org.apache.beam.fn.harness.control.BundleSplitListener;
import org.apache.beam.fn.harness.data.BeamFnDataClient;
import org.apache.beam.fn.harness.data.BeamFnTimerClient;
import org.apache.beam.fn.harness.data.PCollectionConsumerRegistry;
import org.apache.beam.fn.harness.data.PTransformFunctionRegistry;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.RehydratedComponents;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.function.ThrowingRunnable;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;

public class FlattenRunner<InputT> {

    static class Factory<InputT>
    implements PTransformRunnerFactory<FlattenRunner<InputT>> {
        Factory() {
        }

        @Override
        public FlattenRunner<InputT> createRunnerForPTransform(PipelineOptions pipelineOptions, BeamFnDataClient beamFnDataClient, BeamFnStateClient beamFnStateClient, BeamFnTimerClient beamFnTimerClient, String pTransformId, RunnerApi.PTransform pTransform, Supplier<String> processBundleInstructionId, Map<String, RunnerApi.PCollection> pCollections, Map<String, RunnerApi.Coder> coders, Map<String, RunnerApi.WindowingStrategy> windowingStrategies, PCollectionConsumerRegistry pCollectionConsumerRegistry, PTransformFunctionRegistry startFunctionRegistry, PTransformFunctionRegistry finishFunctionRegistry, Consumer<ThrowingRunnable> addResetFunction, Consumer<ThrowingRunnable> tearDownFunctions, Consumer<PTransformRunnerFactory.ProgressRequestCallback> addProgressRequestCallback, BundleSplitListener splitListener, DoFn.BundleFinalizer bundleFinalizer) throws IOException {
            String output = Iterables.getOnlyElement(pTransform.getOutputsMap().values());
            FnDataReceiver receiver = pCollectionConsumerRegistry.getMultiplexingConsumer(output);
            RehydratedComponents components = RehydratedComponents.forComponents(RunnerApi.Components.newBuilder().putAllCoders(coders).build());
            FlattenRunner runner = new FlattenRunner();
            for (String pCollectionId : pTransform.getInputsMap().values()) {
                pCollectionConsumerRegistry.register(pCollectionId, pTransformId, receiver, this.getValueCoder(components, pCollections, pCollectionId));
            }
            return runner;
        }

        private Coder<?> getValueCoder(RehydratedComponents components, Map<String, RunnerApi.PCollection> pCollections, String pCollectionId) throws IOException {
            if (!pCollections.containsKey(pCollectionId)) {
                throw new IllegalArgumentException(String.format("Missing PCollection for id: %s", pCollectionId));
            }
            Coder<Object> coder = components.getCoder(pCollections.get(pCollectionId).getCoderId());
            if (coder instanceof WindowedValue.WindowedValueCoder) {
                coder = ((WindowedValue.WindowedValueCoder)coder).getValueCoder();
            }
            return coder;
        }
    }

    public static class Registrar
    implements PTransformRunnerFactory.Registrar {
        @Override
        public Map<String, PTransformRunnerFactory> getPTransformRunnerFactories() {
            return ImmutableMap.of("beam:transform:flatten:v1", new Factory());
        }
    }
}

