/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.data;

import org.apache.beam.fn.harness.data.BeamFnDataClient;
import org.apache.beam.fn.harness.data.BeamFnTimerClient;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.runners.core.construction.Timer;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.CloseableFnDataReceiver;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.fn.data.InboundDataClient;
import org.apache.beam.sdk.fn.data.LogicalEndpoint;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class BeamFnTimerGrpcClient
implements BeamFnTimerClient {
    private final BeamFnDataClient beamFnDataClient;
    private final Endpoints.ApiServiceDescriptor timerApiServiceDescriptor;

    public BeamFnTimerGrpcClient(BeamFnDataClient beamFnDataClient, Endpoints.ApiServiceDescriptor timerApiServiceDescriptor) {
        this.beamFnDataClient = beamFnDataClient;
        this.timerApiServiceDescriptor = timerApiServiceDescriptor;
    }

    @Override
    public <K> BeamFnTimerClient.TimerHandler<K> register(LogicalEndpoint timerEndpoint, Coder<Timer<K>> coder, FnDataReceiver<Timer<K>> receiver) {
        Preconditions.checkArgument(timerEndpoint.isTimer(), "Expected to receive timer endpoint but received %s", (Object)timerEndpoint);
        final InboundDataClient inbound = this.beamFnDataClient.receive(this.timerApiServiceDescriptor, timerEndpoint, coder, receiver);
        final CloseableFnDataReceiver<Timer<K>> outbound = this.beamFnDataClient.send(this.timerApiServiceDescriptor, timerEndpoint, coder);
        return new BeamFnTimerClient.TimerHandler<K>(){

            @Override
            public void flush() throws Exception {
                outbound.flush();
            }

            @Override
            public void close() throws Exception {
                outbound.close();
            }

            @Override
            public void accept(Timer<K> input) throws Exception {
                outbound.accept(input);
            }

            @Override
            public void awaitCompletion() throws InterruptedException, Exception {
                inbound.awaitCompletion();
            }

            @Override
            public void runWhenComplete(Runnable completeRunnable) {
                inbound.runWhenComplete(completeRunnable);
            }

            @Override
            public boolean isDone() {
                return inbound.isDone();
            }

            @Override
            public void cancel() {
                inbound.cancel();
            }

            @Override
            public void complete() {
                inbound.complete();
            }

            @Override
            public void fail(Throwable t) {
                inbound.fail(t);
            }
        };
    }
}

