/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.fn.harness.state.StateFetchingIterators;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.stream.PrefetchableIterable;
import org.apache.beam.sdk.fn.stream.PrefetchableIterables;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;

public class BagUserState<T> {
    private final BeamFnStateClient beamFnStateClient;
    private final BeamFnApi.StateRequest request;
    private final Coder<T> valueCoder;
    private PrefetchableIterable<T> oldValues;
    private ArrayList<T> newValues;
    private boolean isClosed;

    public BagUserState(BeamFnStateClient beamFnStateClient, String instructionId, String ptransformId, String stateId, ByteString encodedWindow, ByteString encodedKey, Coder<T> valueCoder) {
        this.beamFnStateClient = beamFnStateClient;
        this.valueCoder = valueCoder;
        BeamFnApi.StateRequest.Builder requestBuilder = BeamFnApi.StateRequest.newBuilder();
        requestBuilder.setInstructionId(instructionId).getStateKeyBuilder().getBagUserStateBuilder().setTransformId(ptransformId).setUserStateId(stateId).setWindow(encodedWindow).setKey(encodedKey);
        this.request = requestBuilder.build();
        this.oldValues = StateFetchingIterators.readAllAndDecodeStartingFrom(beamFnStateClient, this.request, valueCoder);
        this.newValues = new ArrayList();
    }

    public PrefetchableIterable<T> get() {
        Preconditions.checkState(!this.isClosed, "Bag user state is no longer usable because it is closed for %s", (Object)this.request.getStateKey());
        if (this.oldValues == null) {
            return PrefetchableIterables.limit(Collections.unmodifiableList(this.newValues), this.newValues.size());
        }
        if (this.newValues.isEmpty()) {
            return this.oldValues;
        }
        return PrefetchableIterables.concat(this.oldValues, Iterables.limit(Collections.unmodifiableList(this.newValues), this.newValues.size()));
    }

    public void append(T t) {
        Preconditions.checkState(!this.isClosed, "Bag user state is no longer usable because it is closed for %s", (Object)this.request.getStateKey());
        this.newValues.add(t);
    }

    public void clear() {
        Preconditions.checkState(!this.isClosed, "Bag user state is no longer usable because it is closed for %s", (Object)this.request.getStateKey());
        this.oldValues = null;
        this.newValues = new ArrayList();
    }

    public void asyncClose() throws Exception {
        Preconditions.checkState(!this.isClosed, "Bag user state is no longer usable because it is closed for %s", (Object)this.request.getStateKey());
        if (this.oldValues == null) {
            this.beamFnStateClient.handle(this.request.toBuilder().setClear(BeamFnApi.StateClearRequest.getDefaultInstance()));
        }
        if (!this.newValues.isEmpty()) {
            ByteString.Output out = ByteString.newOutput();
            for (T newValue : this.newValues) {
                this.valueCoder.encode(newValue, out);
            }
            this.beamFnStateClient.handle(this.request.toBuilder().setAppend(BeamFnApi.StateAppendRequest.newBuilder().setData(out.toByteString())));
        }
        this.isClosed = true;
    }
}

