/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.beam.fn.harness.data.BeamFnTimerClient;
import org.apache.beam.fn.harness.state.AutoValue_FnApiTimerBundleTracker_Modifications;
import org.apache.beam.fn.harness.state.AutoValue_FnApiTimerBundleTracker_TimerInfo;
import org.apache.beam.runners.core.construction.Timer;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ComparisonChain;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.HashBasedTable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Table;

public class FnApiTimerBundleTracker<K> {
    private final Supplier<ByteString> encodedCurrentKeySupplier;
    private final Supplier<ByteString> encodedCurrentWindowSupplier;
    private Table<ByteString, ByteString, Modifications<K>> timerModifications = HashBasedTable.create();

    public FnApiTimerBundleTracker(Coder<K> keyCoder, Coder<BoundedWindow> windowCoder, Supplier<K> currentKeySupplier, Supplier<BoundedWindow> currentWindowSupplier) {
        this.encodedCurrentKeySupplier = FnApiTimerBundleTracker.memoizeFunction(currentKeySupplier, key -> {
            Preconditions.checkState(keyCoder != null, "Accessing state in unkeyed context, no key coder available");
            ByteString.Output encodedKeyOut = ByteString.newOutput();
            try {
                keyCoder.encode(key, encodedKeyOut, Coder.Context.NESTED);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return encodedKeyOut.toByteString();
        });
        this.encodedCurrentWindowSupplier = FnApiTimerBundleTracker.memoizeFunction(currentWindowSupplier, window -> {
            ByteString.Output encodedWindowOut = ByteString.newOutput();
            try {
                windowCoder.encode((BoundedWindow)window, encodedWindowOut);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return encodedWindowOut.toByteString();
        });
    }

    public void timerModified(String timerFamilyOrId, TimeDomain timeDomain, Timer<K> timer) {
        ByteString windowString;
        ByteString keyString = this.encodedCurrentKeySupplier.get();
        Modifications<K> modifications = this.timerModifications.get(keyString, windowString = this.encodedCurrentWindowSupplier.get());
        if (modifications == null) {
            modifications = Modifications.create();
            this.timerModifications.put(keyString, windowString, modifications);
        }
        if (!timer.getClearBit()) {
            modifications.getModifiedTimersOrdered(timeDomain).add(TimerInfo.of(timer, timerFamilyOrId, timeDomain));
        }
        modifications.getModifiedTimerIds().put(timerFamilyOrId, timer.getDynamicTimerTag(), timer);
    }

    public Modifications<K> getBundleModifications() {
        ByteString windowString;
        ByteString keyString = this.encodedCurrentKeySupplier.get();
        Modifications<K> modifications = this.timerModifications.get(keyString, windowString = this.encodedCurrentWindowSupplier.get());
        if (modifications == null) {
            modifications = Modifications.create();
            this.timerModifications.put(keyString, windowString, modifications);
        }
        return modifications;
    }

    public void outputTimers(Function<String, BeamFnTimerClient.TimerHandler<K>> getHandler) {
        for (Table.Cell<ByteString, ByteString, Modifications<K>> cell : this.timerModifications.cellSet()) {
            Modifications<K> modifications = cell.getValue();
            if (modifications == null) continue;
            for (Table.Cell<String, String, Timer<K>> timerCell : modifications.getModifiedTimerIds().cellSet()) {
                String timerFamilyOrId = timerCell.getRowKey();
                Timer<K> timer = timerCell.getValue();
                try {
                    if (timerFamilyOrId == null || timer == null) continue;
                    getHandler.apply(timerFamilyOrId).accept(timer);
                }
                catch (Throwable t) {
                    throw UserCodeException.wrap(t);
                }
            }
        }
    }

    private static <ArgT, ResultT> Supplier<ResultT> memoizeFunction(final Supplier<ArgT> arg, final Function<ArgT, ResultT> f) {
        return new Supplier<ResultT>(){
            @Nullable
            private ArgT memoizedArg = null;
            @Nullable
            private ResultT memoizedResult = null;

            @Override
            public ResultT get() {
                Object currentArg = arg.get();
                if (this.memoizedArg == null || currentArg != this.memoizedArg) {
                    this.memoizedArg = currentArg;
                    this.memoizedResult = f.apply(currentArg);
                }
                if (this.memoizedResult != null) {
                    return this.memoizedResult;
                }
                throw new RuntimeException("Unexpected null result.");
            }
        };
    }

    @AutoValue
    public static abstract class Modifications<K> {
        public abstract NavigableSet<TimerInfo<K>> getModifiedEventTimersOrdered();

        public abstract NavigableSet<TimerInfo<K>> getModifiedProcessingTimersOrdered();

        public abstract NavigableSet<TimerInfo<K>> getModifiedSynchronizedProcessingTimersOrdered();

        public NavigableSet<TimerInfo<K>> getModifiedTimersOrdered(TimeDomain timeDomain) {
            switch (timeDomain) {
                case EVENT_TIME: {
                    return this.getModifiedEventTimersOrdered();
                }
                case PROCESSING_TIME: {
                    return this.getModifiedProcessingTimersOrdered();
                }
                case SYNCHRONIZED_PROCESSING_TIME: {
                    return this.getModifiedSynchronizedProcessingTimersOrdered();
                }
            }
            throw new RuntimeException("Unexpected time domain " + (Object)((Object)timeDomain));
        }

        public abstract Table<String, String, Timer<K>> getModifiedTimerIds();

        static <K> Modifications<K> create() {
            Comparator timeDomainComparator = (td1, td2) -> {
                if (td1 == TimeDomain.PROCESSING_TIME && td2 == TimeDomain.EVENT_TIME) {
                    return -1;
                }
                if (td1 == TimeDomain.EVENT_TIME && td2 == TimeDomain.PROCESSING_TIME) {
                    return 1;
                }
                return td1.compareTo(td2);
            };
            Comparator comparator = (o1, o2) -> {
                ComparisonChain chain = ComparisonChain.start().compare(o1.getTimeDomain(), o2.getTimeDomain(), timeDomainComparator).compareTrueFirst(o1.getTimer().getClearBit(), o2.getTimer().getClearBit()).compare(o1.getTimer().getFireTimestamp(), o2.getTimer().getFireTimestamp()).compare(o1.getTimer().getHoldTimestamp(), o2.getTimer().getHoldTimestamp()).compare((Comparable<?>)((Object)o1.getTimer().getDynamicTimerTag()), (Comparable<?>)((Object)o2.getTimer().getDynamicTimerTag()));
                return chain.result();
            };
            return new AutoValue_FnApiTimerBundleTracker_Modifications(Sets.newTreeSet(comparator), Sets.newTreeSet(comparator), Sets.newTreeSet(comparator), HashBasedTable.create());
        }
    }

    @AutoValue
    public static abstract class TimerInfo<K> {
        public abstract Timer<K> getTimer();

        public abstract String getTimerFamilyOrId();

        public abstract TimeDomain getTimeDomain();

        public static <K> TimerInfo<K> of(Timer<K> timer, String timerFamilyOrId, TimeDomain timeDomain) {
            return new AutoValue_FnApiTimerBundleTracker_TimerInfo<K>(timer, timerFamilyOrId, timeDomain);
        }
    }
}

