/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.fn.harness.state.StateFetchingIterators;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.Materializations;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.protobuf.ByteString;

public class IterableSideInput<T>
implements Materializations.IterableView<T> {
    private final BeamFnStateClient beamFnStateClient;
    private final String instructionId;
    private final String ptransformId;
    private final String sideInputId;
    private final ByteString encodedWindow;
    private final Coder<T> valueCoder;

    public IterableSideInput(BeamFnStateClient beamFnStateClient, String instructionId, String ptransformId, String sideInputId, ByteString encodedWindow, Coder<T> valueCoder) {
        this.beamFnStateClient = beamFnStateClient;
        this.instructionId = instructionId;
        this.ptransformId = ptransformId;
        this.sideInputId = sideInputId;
        this.encodedWindow = encodedWindow;
        this.valueCoder = valueCoder;
    }

    @Override
    public Iterable<T> get() {
        BeamFnApi.StateRequest.Builder requestBuilder = BeamFnApi.StateRequest.newBuilder();
        requestBuilder.setInstructionId(this.instructionId).getStateKeyBuilder().getIterableSideInputBuilder().setTransformId(this.ptransformId).setSideInputId(this.sideInputId).setWindow(this.encodedWindow);
        return StateFetchingIterators.readAllAndDecodeStartingFrom(this.beamFnStateClient, requestBuilder.build(), this.valueCoder);
    }
}

