/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import java.io.IOException;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.fn.harness.state.StateFetchingIterators;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.Materializations;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.protobuf.ByteString;

public class MultimapSideInput<K, V>
implements Materializations.MultimapView<K, V> {
    private final BeamFnStateClient beamFnStateClient;
    private final String instructionId;
    private final String ptransformId;
    private final String sideInputId;
    private final ByteString encodedWindow;
    private final Coder<K> keyCoder;
    private final Coder<V> valueCoder;

    public MultimapSideInput(BeamFnStateClient beamFnStateClient, String instructionId, String ptransformId, String sideInputId, ByteString encodedWindow, Coder<K> keyCoder, Coder<V> valueCoder) {
        this.beamFnStateClient = beamFnStateClient;
        this.instructionId = instructionId;
        this.ptransformId = ptransformId;
        this.sideInputId = sideInputId;
        this.encodedWindow = encodedWindow;
        this.keyCoder = keyCoder;
        this.valueCoder = valueCoder;
    }

    @Override
    public Iterable<K> get() {
        BeamFnApi.StateRequest.Builder requestBuilder = BeamFnApi.StateRequest.newBuilder();
        requestBuilder.setInstructionId(this.instructionId).getStateKeyBuilder().getMultimapKeysSideInputBuilder().setTransformId(this.ptransformId).setSideInputId(this.sideInputId).setWindow(this.encodedWindow);
        return StateFetchingIterators.readAllAndDecodeStartingFrom(this.beamFnStateClient, requestBuilder.build(), this.keyCoder);
    }

    @Override
    public Iterable<V> get(K k) {
        ByteString.Output output = ByteString.newOutput();
        try {
            this.keyCoder.encode(k, output);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Failed to encode key %s for side input id %s.", k, this.sideInputId), e);
        }
        BeamFnApi.StateRequest.Builder requestBuilder = BeamFnApi.StateRequest.newBuilder();
        requestBuilder.setInstructionId(this.instructionId).getStateKeyBuilder().getMultimapSideInputBuilder().setTransformId(this.ptransformId).setSideInputId(this.sideInputId).setWindow(this.encodedWindow).setKey(output.toByteString());
        return StateFetchingIterators.readAllAndDecodeStartingFrom(this.beamFnStateClient, requestBuilder.build(), this.valueCoder);
    }
}

