/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.runners.core.AutoValue_InMemoryBundleFinalizer_Finalization;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.joda.time.Instant;

public class InMemoryBundleFinalizer
implements DoFn.BundleFinalizer {
    private final List<Finalization> requestedFinalizations = new ArrayList<Finalization>();

    @Override
    public void afterBundleCommit(Instant callbackExpiry, DoFn.BundleFinalizer.Callback callback) {
        this.requestedFinalizations.add(Finalization.of(callbackExpiry, callback));
    }

    public List<Finalization> getAndClearFinalizations() {
        ImmutableList<Finalization> rval = ImmutableList.copyOf(this.requestedFinalizations);
        this.requestedFinalizations.clear();
        return rval;
    }

    @AutoValue
    public static abstract class Finalization {
        public static Finalization of(Instant expiryTime, DoFn.BundleFinalizer.Callback callback) {
            return new AutoValue_InMemoryBundleFinalizer_Finalization(expiryTime, callback);
        }

        public abstract Instant getExpiryTime();

        public abstract DoFn.BundleFinalizer.Callback getCallback();
    }
}

