/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValues;
import org.apache.beam.sdk.values.TaggedPValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;

public class ReplacementOutputs {
    private ReplacementOutputs() {
    }

    public static Map<PCollection<?>, PTransformOverrideFactory.ReplacementOutput> singleton(Map<TupleTag<?>, PCollection<?>> original, POutput replacement) {
        Map.Entry<TupleTag<?>, PCollection<?>> originalElement = Iterables.getOnlyElement(original.entrySet());
        Map.Entry<TupleTag<?>, PCollection<?>> replacementElement = Iterables.getOnlyElement(PValues.expandOutput(replacement).entrySet());
        return Collections.singletonMap(replacementElement.getValue(), PTransformOverrideFactory.ReplacementOutput.of(TaggedPValue.of(originalElement.getKey(), originalElement.getValue()), TaggedPValue.of(replacementElement.getKey(), replacementElement.getValue())));
    }

    public static Map<PCollection<?>, PTransformOverrideFactory.ReplacementOutput> tagged(Map<TupleTag<?>, PCollection<?>> original, POutput replacement) {
        HashMap originalTags = new HashMap();
        for (Map.Entry<TupleTag<?>, PCollection<?>> originalValue : original.entrySet()) {
            originalTags.put(originalValue.getKey(), TaggedPValue.of(originalValue.getKey(), originalValue.getValue()));
        }
        ImmutableMap.Builder<PCollection<?>, PTransformOverrideFactory.ReplacementOutput> resultBuilder = ImmutableMap.builder();
        HashMap remainingTaggedOriginals = new HashMap(original);
        Map<TupleTag<?>, PCollection<?>> taggedReplacements = PValues.expandOutput(replacement);
        for (Map.Entry<TupleTag<?>, PCollection<?>> replacementValue : taggedReplacements.entrySet()) {
            TaggedPValue mapped = (TaggedPValue)originalTags.get(replacementValue.getKey());
            Preconditions.checkArgument(mapped != null, "Missing original output for Tag %s and Value %s Between original %s and replacement %s", replacementValue.getKey(), replacementValue.getValue(), original, replacement.expand());
            resultBuilder.put(replacementValue.getValue(), PTransformOverrideFactory.ReplacementOutput.of(mapped, TaggedPValue.of(replacementValue.getKey(), replacementValue.getValue())));
            remainingTaggedOriginals.remove(replacementValue.getKey());
        }
        Preconditions.checkArgument(remainingTaggedOriginals.isEmpty(), "Missing replacement for tagged values %s. Replacement was: %s", remainingTaggedOriginals, taggedReplacements);
        return resultBuilder.build();
    }
}

