/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.beam.runners.core.construction.PTransformReplacements;
import org.apache.beam.runners.core.construction.ReplacementOutputs;
import org.apache.beam.runners.core.construction.SplittableParDo;
import org.apache.beam.sdk.fn.splittabledofn.RestrictionTrackers;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.Timer;
import org.apache.beam.sdk.state.TimerMap;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimator;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.Uninterruptibles;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

public class SplittableParDoNaiveBounded {

    static class NaiveProcessFn<InputT, OutputT, RestrictionT, PositionT, WatermarkEstimatorStateT>
    extends DoFn<KV<InputT, RestrictionT>, OutputT> {
        private final DoFn<InputT, OutputT> fn;
        private transient @Nullable DoFnInvoker<InputT, OutputT> invoker;

        NaiveProcessFn(DoFn<InputT, OutputT> fn) {
            this.fn = fn;
        }

        @DoFn.Setup
        public void setup(final PipelineOptions options) {
            this.invoker = DoFnInvokers.invokerFor(this.fn);
            this.invoker.invokeSetup(new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

                @Override
                public PipelineOptions pipelineOptions() {
                    return options;
                }

                @Override
                public String getErrorContext() {
                    return "SplittableParDoNaiveBounded/Setup";
                }
            });
        }

        @DoFn.StartBundle
        public void startBundle(final DoFn.StartBundleContext c) {
            this.invoker.invokeStartBundle(new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

                @Override
                public DoFn.StartBundleContext startBundleContext(DoFn<InputT, OutputT> doFn) {
                    return new DoFn.StartBundleContext(){

                        @Override
                        public PipelineOptions getPipelineOptions() {
                            return c.getPipelineOptions();
                        }
                    };
                }

                @Override
                public PipelineOptions pipelineOptions() {
                    return c.getPipelineOptions();
                }

                @Override
                public String getErrorContext() {
                    return "SplittableParDoNaiveBounded/StartBundle";
                }
            });
        }

        @DoFn.ProcessElement
        public void process(final DoFn.ProcessContext c, final BoundedWindow w) {
            Object initialWatermarkEstimatorState = this.invoker.invokeGetInitialWatermarkEstimatorState(new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

                @Override
                public InputT element(DoFn<InputT, OutputT> doFn) {
                    return ((KV)c.element()).getKey();
                }

                @Override
                public Object restriction() {
                    return ((KV)c.element()).getValue();
                }

                @Override
                public Instant timestamp(DoFn<InputT, OutputT> doFn) {
                    return c.timestamp();
                }

                @Override
                public PipelineOptions pipelineOptions() {
                    return c.getPipelineOptions();
                }

                @Override
                public PaneInfo paneInfo(DoFn<InputT, OutputT> doFn) {
                    return c.pane();
                }

                @Override
                public BoundedWindow window() {
                    return w;
                }

                @Override
                public String getErrorContext() {
                    return NaiveProcessFn.class.getSimpleName() + ".invokeGetInitialWatermarkEstimatorState";
                }
            });
            Object restriction = ((KV)c.element()).getValue();
            Object watermarkEstimatorState = initialWatermarkEstimatorState;
            while (true) {
                final Object currentRestriction = restriction;
                final Object currentWatermarkEstimatorState = watermarkEstimatorState;
                RestrictionTracker tracker = RestrictionTrackers.observe(this.invoker.invokeNewTracker(new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

                    @Override
                    public InputT element(DoFn<InputT, OutputT> doFn) {
                        return ((KV)c.element()).getKey();
                    }

                    @Override
                    public RestrictionT restriction() {
                        return currentRestriction;
                    }

                    @Override
                    public Instant timestamp(DoFn<InputT, OutputT> doFn) {
                        return c.timestamp();
                    }

                    @Override
                    public PipelineOptions pipelineOptions() {
                        return c.getPipelineOptions();
                    }

                    @Override
                    public PaneInfo paneInfo(DoFn<InputT, OutputT> doFn) {
                        return c.pane();
                    }

                    @Override
                    public BoundedWindow window() {
                        return w;
                    }

                    @Override
                    public String getErrorContext() {
                        return NaiveProcessFn.class.getSimpleName() + ".invokeNewTracker";
                    }
                }), new RestrictionTrackers.ClaimObserver<PositionT>(){

                    @Override
                    public void onClaimed(PositionT position) {
                    }

                    @Override
                    public void onClaimFailed(PositionT position) {
                    }
                });
                WatermarkEstimator watermarkEstimator = this.invoker.invokeNewWatermarkEstimator(new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

                    @Override
                    public InputT element(DoFn<InputT, OutputT> doFn) {
                        return ((KV)c.element()).getKey();
                    }

                    @Override
                    public RestrictionT restriction() {
                        return currentRestriction;
                    }

                    @Override
                    public WatermarkEstimatorStateT watermarkEstimatorState() {
                        return currentWatermarkEstimatorState;
                    }

                    @Override
                    public Instant timestamp(DoFn<InputT, OutputT> doFn) {
                        return c.timestamp();
                    }

                    @Override
                    public PipelineOptions pipelineOptions() {
                        return c.getPipelineOptions();
                    }

                    @Override
                    public PaneInfo paneInfo(DoFn<InputT, OutputT> doFn) {
                        return c.pane();
                    }

                    @Override
                    public BoundedWindow window() {
                        return w;
                    }

                    @Override
                    public String getErrorContext() {
                        return NaiveProcessFn.class.getSimpleName() + ".invokeNewWatermarkEstimator";
                    }
                });
                DoFn.ProcessContinuation continuation = this.invoker.invokeProcessElement(new NestedProcessContext(this.fn, c, ((KV)c.element()).getKey(), w, tracker, watermarkEstimator, null));
                if (!continuation.shouldResume()) break;
                watermarkEstimatorState = watermarkEstimator.getState();
                SplitResult split = tracker.trySplit(0.0);
                if (split == null) break;
                restriction = split.getResidual();
                Uninterruptibles.sleepUninterruptibly(continuation.resumeDelay().getMillis(), TimeUnit.MILLISECONDS);
            }
        }

        @DoFn.FinishBundle
        public void finishBundle(final DoFn.FinishBundleContext c) {
            this.invoker.invokeFinishBundle(new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

                @Override
                public DoFn.FinishBundleContext finishBundleContext(DoFn<InputT, OutputT> doFn) {
                    return new DoFn.FinishBundleContext(){

                        @Override
                        public PipelineOptions getPipelineOptions() {
                            return c.getPipelineOptions();
                        }

                        @Override
                        public void output(@Nullable OutputT output, Instant timestamp, BoundedWindow window) {
                            throw new UnsupportedOperationException("Output from FinishBundle for SDF is not supported in naive implementation");
                        }

                        @Override
                        public <T> void output(TupleTag<T> tag, T output, Instant timestamp, BoundedWindow window) {
                            throw new UnsupportedOperationException("Output from FinishBundle for SDF is not supported in naive implementation");
                        }
                    };
                }

                @Override
                public PipelineOptions pipelineOptions() {
                    return c.getPipelineOptions();
                }

                @Override
                public String getErrorContext() {
                    return "SplittableParDoNaiveBounded/StartBundle";
                }
            });
        }

        @DoFn.Teardown
        public void teardown() {
            this.invoker.invokeTeardown();
        }

        private static class NestedProcessContext<InputT, OutputT, RestrictionT, TrackerT extends RestrictionTracker<RestrictionT, ?>, WatermarkEstimatorStateT, WatermarkEstimatorT extends WatermarkEstimator<WatermarkEstimatorStateT>>
        extends DoFn.ProcessContext
        implements DoFnInvoker.ArgumentProvider<InputT, OutputT> {
            private final BoundedWindow window;
            private final DoFn.ProcessContext outerContext;
            private final InputT element;
            private final TrackerT tracker;
            private final WatermarkEstimatorT watermarkEstimator;

            private NestedProcessContext(DoFn<InputT, OutputT> fn, DoFn.ProcessContext outerContext, InputT element, BoundedWindow window, TrackerT tracker, WatermarkEstimatorT watermarkEstimator) {
                super(fn);
                this.window = window;
                this.outerContext = outerContext;
                this.element = element;
                this.tracker = tracker;
                this.watermarkEstimator = watermarkEstimator;
            }

            @Override
            public BoundedWindow window() {
                return this.window;
            }

            @Override
            public PaneInfo paneInfo(DoFn<InputT, OutputT> doFn) {
                return this.outerContext.pane();
            }

            @Override
            public PipelineOptions pipelineOptions() {
                return this.outerContext.getPipelineOptions();
            }

            @Override
            public DoFn.ProcessContext processContext(DoFn<InputT, OutputT> doFn) {
                return this;
            }

            @Override
            public DoFn.OnTimerContext onTimerContext(DoFn<InputT, OutputT> doFn) {
                throw new IllegalStateException();
            }

            @Override
            public InputT element(DoFn<InputT, OutputT> doFn) {
                return this.element;
            }

            @Override
            public Object key() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object sideInput(String tagId) {
                throw new UnsupportedOperationException();
            }

            @Override
            public TimerMap timerFamily(String tagId) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object schemaElement(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Instant timestamp(DoFn<InputT, OutputT> doFn) {
                return this.outerContext.timestamp();
            }

            @Override
            public String timerId(DoFn<InputT, OutputT> doFn) {
                throw new UnsupportedOperationException();
            }

            @Override
            public DoFn.OutputReceiver<OutputT> outputReceiver(DoFn<InputT, OutputT> doFn) {
                return new DoFn.OutputReceiver<OutputT>(){

                    @Override
                    public void output(OutputT output) {
                        outerContext.output(output);
                    }

                    @Override
                    public void outputWithTimestamp(OutputT output, Instant timestamp) {
                        outerContext.outputWithTimestamp(output, timestamp);
                    }
                };
            }

            @Override
            public DoFn.MultiOutputReceiver taggedOutputReceiver(DoFn<InputT, OutputT> doFn) {
                return new DoFn.MultiOutputReceiver(){

                    @Override
                    public <T> DoFn.OutputReceiver<T> get(final TupleTag<T> tag) {
                        return new DoFn.OutputReceiver<T>(){

                            @Override
                            public void output(T output) {
                                outerContext.output(tag, output);
                            }

                            @Override
                            public void outputWithTimestamp(T output, Instant timestamp) {
                                outerContext.outputWithTimestamp(tag, output, timestamp);
                            }
                        };
                    }

                    @Override
                    public <T> DoFn.OutputReceiver<Row> getRowReceiver(TupleTag<T> tag) {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public DoFn.BundleFinalizer bundleFinalizer() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object restriction() {
                return ((RestrictionTracker)this.tracker).currentRestriction();
            }

            @Override
            public RestrictionTracker<?, ?> restrictionTracker() {
                return this.tracker;
            }

            @Override
            public PipelineOptions getPipelineOptions() {
                return this.outerContext.getPipelineOptions();
            }

            @Override
            public void output(OutputT output) {
                this.outerContext.output(output);
            }

            @Override
            public void outputWithTimestamp(OutputT output, Instant timestamp) {
                this.outerContext.outputWithTimestamp(output, timestamp);
            }

            @Override
            public <T> void output(TupleTag<T> tag, T output) {
                this.outerContext.output(tag, output);
            }

            @Override
            public <T> void outputWithTimestamp(TupleTag<T> tag, T output, Instant timestamp) {
                this.outerContext.outputWithTimestamp(tag, output, timestamp);
            }

            @Override
            public InputT element() {
                return this.element;
            }

            @Override
            public <T> T sideInput(PCollectionView<T> view) {
                return this.outerContext.sideInput(view);
            }

            @Override
            public Instant timestamp() {
                return this.outerContext.timestamp();
            }

            @Override
            public PaneInfo pane() {
                return this.outerContext.pane();
            }

            @Override
            public Object watermarkEstimatorState() {
                throw new UnsupportedOperationException("@WatermarkEstimatorState parameters are not supported.");
            }

            @Override
            public WatermarkEstimator<?> watermarkEstimator() {
                return this.watermarkEstimator;
            }

            @Override
            public DoFn.StartBundleContext startBundleContext(DoFn<InputT, OutputT> doFn) {
                throw new IllegalStateException();
            }

            @Override
            public DoFn.FinishBundleContext finishBundleContext(DoFn<InputT, OutputT> doFn) {
                throw new IllegalStateException();
            }

            @Override
            public DoFn.OutputReceiver<Row> outputRowReceiver(DoFn<InputT, OutputT> doFn) {
                throw new UnsupportedOperationException();
            }

            @Override
            public TimeDomain timeDomain(DoFn<InputT, OutputT> doFn) {
                throw new IllegalStateException();
            }

            @Override
            public State state(String stateId, boolean alwaysFetched) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Timer timer(String timerId) {
                throw new UnsupportedOperationException();
            }

            /* synthetic */ NestedProcessContext(DoFn x0, DoFn.ProcessContext x1, Object x2, BoundedWindow x3, RestrictionTracker x4, WatermarkEstimator x5, 1 x6) {
                this(x0, x1, x2, x3, x4, x5);
            }
        }
    }

    static class SplittableProcessNaive<InputT, OutputT, RestrictionT, PositionT, WatermarkEstimatorStateT>
    extends PTransform<PCollection<KV<byte[], KV<InputT, RestrictionT>>>, PCollectionTuple> {
        private final SplittableParDo.ProcessKeyedElements<InputT, OutputT, RestrictionT, WatermarkEstimatorStateT> original;

        SplittableProcessNaive(SplittableParDo.ProcessKeyedElements<InputT, OutputT, RestrictionT, WatermarkEstimatorStateT> original) {
            this.original = original;
        }

        @Override
        public PCollectionTuple expand(PCollection<KV<byte[], KV<InputT, RestrictionT>>> input) {
            return (PCollectionTuple)((PCollection)((PCollection)input.apply("Reshuffle", Reshuffle.of())).apply("Drop key", Values.create())).apply("NaiveProcess", ParDo.of(new NaiveProcessFn(this.original.getFn())).withSideInputs(this.original.getSideInputs()).withOutputTags(this.original.getMainOutputTag(), this.original.getAdditionalOutputTags()));
        }
    }

    public static class OverrideFactory<InputT, OutputT, RestrictionT, WatermarkEstimatorStateT>
    implements PTransformOverrideFactory<PCollection<KV<byte[], KV<InputT, RestrictionT>>>, PCollectionTuple, SplittableParDo.ProcessKeyedElements<InputT, OutputT, RestrictionT, WatermarkEstimatorStateT>> {
        @Override
        public PTransformOverrideFactory.PTransformReplacement<PCollection<KV<byte[], KV<InputT, RestrictionT>>>, PCollectionTuple> getReplacementTransform(AppliedPTransform<PCollection<KV<byte[], KV<InputT, RestrictionT>>>, PCollectionTuple, SplittableParDo.ProcessKeyedElements<InputT, OutputT, RestrictionT, WatermarkEstimatorStateT>> transform) {
            Preconditions.checkArgument(DoFnSignatures.signatureForDoFn(transform.getTransform().getFn()).isBoundedPerElement() == PCollection.IsBounded.BOUNDED, "Expecting a bounded-per-element splittable DoFn");
            return PTransformOverrideFactory.PTransformReplacement.of(PTransformReplacements.getSingletonMainInput(transform), new SplittableProcessNaive(transform.getTransform()));
        }

        @Override
        public Map<PCollection<?>, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PCollection<?>> outputs, PCollectionTuple newOutput) {
            return ReplacementOutputs.tagged(outputs, newOutput);
        }
    }
}

