/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction.graph;

import java.util.HashMap;
import java.util.Set;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;

public class PipelineValidator {
    private static final ImmutableMap<String, TransformValidator> VALIDATORS = ImmutableMap.builder().put("beam:transform:pardo:v1", PipelineValidator::validateParDo).put("beam:transform:window_into:v1", PipelineValidator::validateAssignWindows).put("beam:transform:teststream:v1", PipelineValidator::validateTestStream).put("beam:transform:combine_per_key:v1", PipelineValidator::validateCombine).put("beam:transform:combine_globally:v1", PipelineValidator::validateCombine).put("beam:transform:combine_per_key_precombine:v1", PipelineValidator::validateCombine).put("beam:transform:combine_per_key_merge_accumulators:v1", PipelineValidator::validateCombine).put("beam:transform:combine_per_key_extract_outputs:v1", PipelineValidator::validateCombine).put("beam:transform:combine_grouped_values:v1", PipelineValidator::validateCombine).put("beam:transform:sdf_pair_with_restriction:v1", PipelineValidator::validateParDo).put("beam:transform:sdf_process_keyed_elements:v1", PipelineValidator::validateParDo).put("beam:runner:executable_stage:v1", PipelineValidator::validateExecutableStage).build();

    public static void validate(RunnerApi.Pipeline p) {
        RunnerApi.Components components = p.getComponents();
        for (String transformId : p.getRootTransformIdsList()) {
            Preconditions.checkArgument(components.containsTransforms(transformId), "Root transform id %s is unknown", (Object)transformId);
        }
        PipelineValidator.validateComponents("pipeline", components, ImmutableSet.copyOf(p.getRequirementsList()));
    }

    private static void validateComponents(String context, RunnerApi.Components components, Set<String> requirements) {
        String previousId;
        HashMap<String, String> uniqueNamesById = Maps.newHashMap();
        for (String transformId : components.getTransformsMap().keySet()) {
            RunnerApi.PTransform transform = components.getTransformsOrThrow(transformId);
            previousId = uniqueNamesById.put(transform.getUniqueName(), transformId);
            Preconditions.checkArgument(previousId == null, "%s: Transforms %s and %s both have unique_name \"%s\"", (Object)context, (Object)transformId, (Object)previousId, (Object)transform.getUniqueName());
            PipelineValidator.validateTransform(transformId, transform, components, requirements);
        }
        uniqueNamesById = Maps.newHashMap();
        for (String pcollectionId : components.getPcollectionsMap().keySet()) {
            RunnerApi.PCollection pc = components.getPcollectionsOrThrow(pcollectionId);
            Preconditions.checkArgument(!pc.getUniqueName().isEmpty(), "%s: PCollection %s does not have a unique_name set", (Object)context, (Object)pcollectionId);
            previousId = uniqueNamesById.put(pc.getUniqueName(), pcollectionId);
            Preconditions.checkArgument(previousId == null, "%s: PCollections %s and %s both have unique_name \"%s\"", (Object)context, (Object)pcollectionId, (Object)previousId, (Object)pc.getUniqueName());
            Preconditions.checkArgument(components.containsCoders(pc.getCoderId()), "%s: PCollection %s uses unknown coder %s", (Object)context, (Object)pcollectionId, (Object)pc.getCoderId());
            Preconditions.checkArgument(components.containsWindowingStrategies(pc.getWindowingStrategyId()), "%s: PCollection %s uses unknown windowing strategy %s", (Object)context, (Object)pcollectionId, (Object)pc.getWindowingStrategyId());
        }
        for (String strategyId : components.getWindowingStrategiesMap().keySet()) {
            RunnerApi.WindowingStrategy strategy = components.getWindowingStrategiesOrThrow(strategyId);
            Preconditions.checkArgument(components.containsCoders(strategy.getWindowCoderId()), "%s: WindowingStrategy %s uses unknown coder %s", (Object)context, (Object)strategyId, (Object)strategy.getWindowCoderId());
        }
        for (String coderId : components.getCodersMap().keySet()) {
            for (String componentCoderId : components.getCodersOrThrow(coderId).getComponentCoderIdsList()) {
                Preconditions.checkArgument(components.containsCoders(componentCoderId), "%s: Coder %s uses unknown component coder %s", (Object)context, (Object)coderId, (Object)componentCoderId);
            }
        }
    }

    private static void validateTransform(String id, RunnerApi.PTransform transform, RunnerApi.Components components, Set<String> requirements) {
        String pcollectionId;
        for (String subtransformId : transform.getSubtransformsList()) {
            Preconditions.checkArgument(components.containsTransforms(subtransformId), "Transform %s references unknown subtransform %s", (Object)id, (Object)subtransformId);
        }
        for (String inputId : transform.getInputsMap().keySet()) {
            pcollectionId = transform.getInputsOrThrow(inputId);
            Preconditions.checkArgument(components.containsPcollections(pcollectionId), "Transform %s input %s points to unknown PCollection %s", (Object)id, (Object)inputId, (Object)pcollectionId);
        }
        for (String outputId : transform.getOutputsMap().keySet()) {
            pcollectionId = transform.getOutputsOrThrow(outputId);
            Preconditions.checkArgument(components.containsPcollections(pcollectionId), "Transform %s output %s points to unknown PCollection %s", (Object)id, (Object)outputId, (Object)pcollectionId);
        }
        String urn = transform.getSpec().getUrn();
        if (PTransformTranslation.RUNNER_IMPLEMENTED_TRANSFORMS.contains(urn)) {
            Preconditions.checkArgument(transform.getEnvironmentId().isEmpty(), "Transform %s references environment %s when no environment should be specified since it is a required runner implemented transform %s.", (Object)id, (Object)transform.getEnvironmentId(), (Object)urn);
        }
        if (VALIDATORS.containsKey(urn)) {
            try {
                VALIDATORS.get(urn).validate(id, transform, components, requirements);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to validate transform %s", id), e);
            }
        }
    }

    private static void validateParDo(String id, RunnerApi.PTransform transform, RunnerApi.Components components, Set<String> requirements) throws Exception {
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom(transform.getSpec().getPayload());
        for (String sideInputId : payload.getSideInputsMap().keySet()) {
            Preconditions.checkArgument(transform.containsInputs(sideInputId), "Transform %s side input %s is not listed in the transform's inputs", (Object)id, (Object)sideInputId);
        }
        if (payload.getStateSpecsCount() > 0 || payload.getTimerFamilySpecsCount() > 0) {
            Preconditions.checkArgument(requirements.contains("beam:requirement:pardo:stateful:v1"));
        }
        if (!payload.getRestrictionCoderId().isEmpty()) {
            Preconditions.checkArgument(components.containsCoders(payload.getRestrictionCoderId()));
            Preconditions.checkArgument(requirements.contains("beam:requirement:pardo:splittable_dofn:v1"));
        }
        if (payload.getRequestsFinalization()) {
            Preconditions.checkArgument(requirements.contains("beam:requirement:pardo:finalization:v1"));
        }
        if (payload.getRequiresStableInput()) {
            Preconditions.checkArgument(requirements.contains("beam:requirement:pardo:stable_input:v1"));
        }
        if (payload.getRequiresTimeSortedInput()) {
            Preconditions.checkArgument(requirements.contains("beam:requirement:pardo:time_sorted_input:v1"));
        }
    }

    private static void validateAssignWindows(String id, RunnerApi.PTransform transform, RunnerApi.Components components, Set<String> requirements) throws Exception {
        RunnerApi.WindowIntoPayload.parseFrom(transform.getSpec().getPayload());
    }

    private static void validateTestStream(String id, RunnerApi.PTransform transform, RunnerApi.Components components, Set<String> requirements) throws Exception {
        RunnerApi.TestStreamPayload.parseFrom(transform.getSpec().getPayload());
    }

    private static void validateCombine(String id, RunnerApi.PTransform transform, RunnerApi.Components components, Set<String> requirements) throws Exception {
        RunnerApi.CombinePayload payload = RunnerApi.CombinePayload.parseFrom(transform.getSpec().getPayload());
        Preconditions.checkArgument(components.containsCoders(payload.getAccumulatorCoderId()), "Transform %s uses unknown accumulator coder id %s", (Object)id, (Object)payload.getAccumulatorCoderId());
    }

    private static void validateExecutableStage(String id, RunnerApi.PTransform transform, RunnerApi.Components outerComponents, Set<String> requirements) throws Exception {
        RunnerApi.ExecutableStagePayload payload = RunnerApi.ExecutableStagePayload.parseFrom(transform.getSpec().getPayload());
        RunnerApi.Components components = payload.getComponents();
        Preconditions.checkArgument(transform.getInputsMap().values().contains(payload.getInput()), "ExecutableStage %s uses unknown input %s", (Object)id, (Object)payload.getInput());
        Preconditions.checkArgument(!payload.getTransformsList().isEmpty(), "ExecutableStage %s contains no transforms", (Object)id);
        for (String subtransformId : payload.getTransformsList()) {
            Preconditions.checkArgument(components.containsTransforms(subtransformId), "ExecutableStage %s uses unknown transform %s", (Object)id, (Object)subtransformId);
        }
        for (String outputId : payload.getOutputsList()) {
            Preconditions.checkArgument(components.containsPcollections(outputId), "ExecutableStage %s uses unknown output %s", (Object)id, (Object)outputId);
        }
        PipelineValidator.validateComponents("ExecutableStage " + id, components, requirements);
    }

    @FunctionalInterface
    private static interface TransformValidator {
        public void validate(String var1, RunnerApi.PTransform var2, RunnerApi.Components var3, Set<String> var4) throws Exception;
    }
}

