/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import java.io.IOException;
import java.io.InputStream;
import org.apache.beam.runners.core.metrics.DistributionData;
import org.apache.beam.runners.core.metrics.GaugeData;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.protobuf.ByteString;
import org.joda.time.Instant;

public class MonitoringInfoEncodings {
    private static final Coder<Long> VARINT_CODER = VarLongCoder.of();
    private static final Coder<Double> DOUBLE_CODER = DoubleCoder.of();

    public static ByteString encodeInt64Distribution(DistributionData data) {
        ByteString.Output output = ByteString.newOutput();
        try {
            VARINT_CODER.encode(data.count(), output);
            VARINT_CODER.encode(data.sum(), output);
            VARINT_CODER.encode(data.min(), output);
            VARINT_CODER.encode(data.max(), output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output.toByteString();
    }

    public static DistributionData decodeInt64Distribution(ByteString payload) {
        InputStream input = payload.newInput();
        try {
            long count = VARINT_CODER.decode(input);
            long sum = VARINT_CODER.decode(input);
            long min2 = VARINT_CODER.decode(input);
            long max = VARINT_CODER.decode(input);
            return DistributionData.create(sum, count, min2, max);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteString encodeDoubleDistribution(long count, double sum, double min2, double max) {
        ByteString.Output output = ByteString.newOutput();
        try {
            VARINT_CODER.encode(count, output);
            DOUBLE_CODER.encode(sum, output);
            DOUBLE_CODER.encode(min2, output);
            DOUBLE_CODER.encode(max, output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output.toByteString();
    }

    public static ByteString encodeInt64Gauge(GaugeData data) {
        ByteString.Output output = ByteString.newOutput();
        try {
            VARINT_CODER.encode(data.timestamp().getMillis(), output);
            VARINT_CODER.encode(data.value(), output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output.toByteString();
    }

    public static GaugeData decodeInt64Gauge(ByteString payload) {
        InputStream input = payload.newInput();
        try {
            Instant timestamp = new Instant(VARINT_CODER.decode(input));
            return GaugeData.create(VARINT_CODER.decode(input), timestamp);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteString encodeInt64Counter(long value) {
        ByteString.Output output = ByteString.newOutput();
        try {
            VARINT_CODER.encode(value, output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output.toByteString();
    }

    public static long decodeInt64Counter(ByteString payload) {
        try {
            return VarLongCoder.of().decode(payload.newInput());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteString encodeDoubleCounter(double value) {
        ByteString.Output output = ByteString.newOutput();
        try {
            DOUBLE_CODER.encode(value, output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output.toByteString();
    }

    public static double decodeDoubleCounter(ByteString payload) {
        try {
            return DOUBLE_CODER.decode(payload.newInput());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

