/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.runners.core.metrics.ExecutionStateTracker;
import org.apache.beam.runners.core.metrics.MonitoringInfoEncodings;
import org.apache.beam.runners.core.metrics.ShortIdMap;
import org.apache.beam.runners.core.metrics.SimpleMonitoringInfoBuilder;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.joda.time.Duration;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleExecutionState
extends ExecutionStateTracker.ExecutionState {
    private long totalMillis = 0L;
    private HashMap<String, String> labelsMetadata;
    private String urn;
    private String shortId;
    private static final Logger LOG = LoggerFactory.getLogger(SimpleExecutionState.class);
    private static final PeriodFormatter DURATION_FORMATTER = new PeriodFormatterBuilder().appendDays().appendSuffix("d").minimumPrintedDigits(2).appendHours().appendSuffix("h").printZeroAlways().appendMinutes().appendSuffix("m").appendSeconds().appendSuffix("s").toFormatter();

    public SimpleExecutionState(String stateName, String urn, HashMap<String, String> labelsMetadata) {
        super(stateName);
        this.urn = urn;
        this.labelsMetadata = labelsMetadata;
        if (this.labelsMetadata == null) {
            this.labelsMetadata = new HashMap();
        }
    }

    public void reset() {
        this.totalMillis = 0L;
    }

    public String getUrn() {
        return this.urn;
    }

    public String getTotalMillisShortId(ShortIdMap shortIds) {
        if (this.shortId == null) {
            this.shortId = shortIds.getOrCreateShortId(this.getTotalMillisMonitoringMetadata());
        }
        return this.shortId;
    }

    public ByteString getTotalMillisPayload() {
        return MonitoringInfoEncodings.encodeInt64Counter(this.getTotalMillis());
    }

    public ByteString mergeTotalMillisPayload(ByteString other) {
        return MonitoringInfoEncodings.encodeInt64Counter(this.getTotalMillis() + MonitoringInfoEncodings.decodeInt64Counter(other));
    }

    private MetricsApi.MonitoringInfo getTotalMillisMonitoringMetadata() {
        SimpleMonitoringInfoBuilder builder = new SimpleMonitoringInfoBuilder();
        builder.setUrn(this.getUrn());
        for (Map.Entry<String, String> entry : this.getLabels().entrySet()) {
            builder.setLabel(entry.getKey(), entry.getValue());
        }
        builder.setType("beam:metrics:sum_int64:v1");
        return builder.build();
    }

    public Map<String, String> getLabels() {
        return Collections.unmodifiableMap(this.labelsMetadata);
    }

    @Override
    public void takeSample(long millisSinceLastSample) {
        this.totalMillis += millisSinceLastSample;
    }

    public long getTotalMillis() {
        return this.totalMillis;
    }

    @VisibleForTesting
    public String getLullMessage(Thread trackedThread, Duration millis) {
        StackTraceElement[] fullTrace;
        String userStepName = this.labelsMetadata.getOrDefault("PTRANSFORM", null);
        StringBuilder message = new StringBuilder();
        message.append("Operation ongoing");
        if (userStepName != null) {
            message.append(" in step ").append(userStepName);
        }
        message.append(" for at least ").append(SimpleExecutionState.formatDuration(millis)).append(" without outputting or completing in state ").append(this.getStateName());
        message.append("\n");
        for (StackTraceElement e : fullTrace = trackedThread.getStackTrace()) {
            message.append("  at ").append(e).append("\n");
        }
        return message.toString();
    }

    @Override
    public void reportLull(Thread trackedThread, long millis) {
        LOG.warn(this.getLullMessage(trackedThread, Duration.millis(millis)));
    }

    @VisibleForTesting
    static String formatDuration(Duration duration) {
        return DURATION_FORMATTER.print(duration.toPeriod());
    }
}

