/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.beam.runners.core.MergingStateAccessor;
import org.apache.beam.runners.core.StateAccessor;
import org.apache.beam.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.runners.core.triggers.OrFinallyStateMachine;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

public abstract class TriggerStateMachine
implements Serializable {
    protected final @Nullable List<TriggerStateMachine> subTriggers;

    protected TriggerStateMachine(@Nullable List<TriggerStateMachine> subTriggers) {
        this.subTriggers = subTriggers;
    }

    public abstract void prefetchOnElement(PrefetchContext var1);

    public abstract void onElement(OnElementContext var1) throws Exception;

    public abstract void prefetchOnMerge(MergingPrefetchContext var1);

    public abstract void onMerge(OnMergeContext var1) throws Exception;

    public abstract void prefetchShouldFire(PrefetchContext var1);

    public abstract boolean shouldFire(TriggerContext var1) throws Exception;

    public abstract void onFire(TriggerContext var1) throws Exception;

    public void clear(TriggerContext c) throws Exception {
        if (this.subTriggers != null) {
            for (ExecutableTriggerStateMachine trigger : c.trigger().subTriggers()) {
                trigger.invokeClear(c);
            }
        }
    }

    public Iterable<TriggerStateMachine> subTriggers() {
        return this.subTriggers;
    }

    public boolean isCompatible(TriggerStateMachine other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        if (this.subTriggers == null) {
            return other.subTriggers == null;
        }
        if (other.subTriggers == null) {
            return false;
        }
        if (this.subTriggers.size() != other.subTriggers.size()) {
            return false;
        }
        for (int i = 0; i < this.subTriggers.size(); ++i) {
            if (this.subTriggers.get(i).isCompatible(other.subTriggers.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String simpleName = this.getClass().getSimpleName();
        if (this.getClass().getEnclosingClass() != null) {
            simpleName = this.getClass().getEnclosingClass().getSimpleName() + "." + simpleName;
        }
        if (this.subTriggers == null || this.subTriggers.isEmpty()) {
            return simpleName;
        }
        return simpleName + "(" + Joiner.on(", ").join(this.subTriggers) + ")";
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TriggerStateMachine)) {
            return false;
        }
        TriggerStateMachine that = (TriggerStateMachine)obj;
        return Objects.equals(this.getClass(), that.getClass()) && Objects.equals(this.subTriggers, that.subTriggers);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.subTriggers);
    }

    public TriggerStateMachine orFinally(TriggerStateMachine until) {
        return new OrFinallyStateMachine(this, until);
    }

    public static abstract class MergingPrefetchContext
    extends PrefetchContext {
        @Override
        public abstract MergingPrefetchContext forTrigger(ExecutableTriggerStateMachine var1);

        public abstract MergingStateAccessor<?, ?> state();
    }

    public static abstract class PrefetchContext {
        public abstract StateAccessor<?> state();

        public abstract BoundedWindow window();

        public abstract ExecutableTriggerStateMachine trigger();

        public abstract PrefetchContext forTrigger(ExecutableTriggerStateMachine var1);
    }

    public static abstract class OnMergeContext
    extends TriggerContext {
        public abstract void setTimer(Instant var1, TimeDomain var2);

        @Override
        public abstract OnMergeContext forTrigger(ExecutableTriggerStateMachine var1);

        public abstract MergingStateAccessor<?, ?> state();

        @Override
        public abstract MergingTriggerInfo trigger();
    }

    public static abstract class OnElementContext
    extends TriggerContext {
        public abstract Instant eventTimestamp();

        public abstract void setTimer(Instant var1, TimeDomain var2);

        @Override
        public abstract OnElementContext forTrigger(ExecutableTriggerStateMachine var1);
    }

    public static abstract class TriggerContext {
        public abstract TriggerInfo trigger();

        public abstract StateAccessor<?> state();

        public abstract BoundedWindow window();

        public abstract TriggerContext forTrigger(ExecutableTriggerStateMachine var1);

        public abstract void deleteTimer(Instant var1, TimeDomain var2);

        public abstract Instant currentProcessingTime();

        public abstract @Nullable Instant currentSynchronizedProcessingTime();

        public abstract @Nullable Instant currentEventTime();
    }

    public static interface MergingTriggerInfo
    extends TriggerInfo {
        public boolean finishedInAnyMergingWindow();

        public boolean finishedInAllMergingWindows();
    }

    public static interface TriggerInfo {
        public boolean isMerging();

        public Iterable<ExecutableTriggerStateMachine> subTriggers();

        public ExecutableTriggerStateMachine subTrigger(int var1);

        public boolean isFinished();

        public boolean isFinished(int var1);

        public boolean areAllSubtriggersFinished();

        public Iterable<ExecutableTriggerStateMachine> unfinishedSubTriggers();

        public ExecutableTriggerStateMachine firstUnfinishedSubTrigger();

        public void resetTree() throws Exception;

        public void setFinished(boolean var1);

        public void setFinished(boolean var1, int var2);
    }
}

