/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.AvroEncode;
import org.apache.avro.reflect.AvroName;
import org.apache.avro.reflect.AvroSchema;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.reflect.Union;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.util.ClassUtils;
import org.apache.avro.util.Utf8;
import org.apache.beam.sdk.coders.AvroGenericCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.util.EmptyOnDeserializationThreadLocal;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Suppliers;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class AvroCoder<T>
extends CustomCoder<T> {
    private final Class<T> type;
    private final SerializableSchemaSupplier schemaSupplier;
    private final TypeDescriptor<T> typeDescriptor;
    private final List<String> nonDeterministicReasons;
    private static final EncoderFactory ENCODER_FACTORY = EncoderFactory.get();
    private static final DecoderFactory DECODER_FACTORY = DecoderFactory.get();
    private final EmptyOnDeserializationThreadLocal<BinaryDecoder> decoder;
    private final EmptyOnDeserializationThreadLocal<BinaryEncoder> encoder;
    private final EmptyOnDeserializationThreadLocal<DatumWriter<T>> writer;
    private final EmptyOnDeserializationThreadLocal<DatumReader<T>> reader;
    private final Supplier<ReflectData> reflectData;

    public static <T> AvroCoder<T> of(TypeDescriptor<T> type) {
        return AvroCoder.of(type, true);
    }

    public static <T> AvroCoder<T> of(TypeDescriptor<T> type, boolean useReflectApi) {
        Class<T> clazz = type.getRawType();
        return AvroCoder.of(clazz, useReflectApi);
    }

    public static <T> AvroCoder<T> of(Class<T> clazz) {
        return AvroCoder.of(clazz, true);
    }

    public static AvroGenericCoder of(Schema schema) {
        return AvroGenericCoder.of(schema);
    }

    public static <T> AvroCoder<T> of(Class<T> type, boolean useReflectApi) {
        return AvroCoder.of(type, new ReflectData(type.getClassLoader()).getSchema(type), useReflectApi);
    }

    public static <T> AvroCoder<T> of(Class<T> type, Schema schema) {
        return AvroCoder.of(type, schema, true);
    }

    public static <T> AvroCoder<T> of(Class<T> type, Schema schema, boolean useReflectApi) {
        return new AvroCoder<T>(type, schema, useReflectApi);
    }

    public static CoderProvider getCoderProvider() {
        return new AvroCoderProvider();
    }

    protected AvroCoder(Class<T> type, Schema schema) {
        this(type, schema, false);
    }

    protected AvroCoder(Class<T> type, Schema schema, final boolean useReflectApi) {
        this.type = type;
        this.schemaSupplier = new SerializableSchemaSupplier(schema);
        this.typeDescriptor = TypeDescriptor.of(type);
        this.nonDeterministicReasons = new AvroDeterminismChecker().check(TypeDescriptor.of(type), schema);
        this.decoder = new EmptyOnDeserializationThreadLocal();
        this.encoder = new EmptyOnDeserializationThreadLocal();
        this.reflectData = Suppliers.memoize(new SerializableReflectDataSupplier(this.getType()));
        this.reader = new EmptyOnDeserializationThreadLocal<DatumReader<T>>(){
            private final AvroCoder<T> myCoder;
            {
                this.myCoder = AvroCoder.this;
            }

            @Override
            public DatumReader<T> initialValue() {
                if (this.myCoder.getType().equals(GenericRecord.class)) {
                    return new GenericDatumReader(this.myCoder.getSchema());
                }
                if (SpecificRecord.class.isAssignableFrom(this.myCoder.getType()) && !useReflectApi) {
                    return new SpecificDatumReader(this.myCoder.getType());
                }
                return new ReflectDatumReader(this.myCoder.getSchema(), this.myCoder.getSchema(), (ReflectData)this.myCoder.reflectData.get());
            }
        };
        this.writer = new EmptyOnDeserializationThreadLocal<DatumWriter<T>>(){
            private final AvroCoder<T> myCoder;
            {
                this.myCoder = AvroCoder.this;
            }

            @Override
            public DatumWriter<T> initialValue() {
                if (this.myCoder.getType().equals(GenericRecord.class)) {
                    return new GenericDatumWriter(this.myCoder.getSchema());
                }
                if (SpecificRecord.class.isAssignableFrom(this.myCoder.getType()) && !useReflectApi) {
                    return new SpecificDatumWriter(this.myCoder.getType());
                }
                return new ReflectDatumWriter(this.myCoder.getSchema(), (ReflectData)this.myCoder.reflectData.get());
            }
        };
    }

    public Class<T> getType() {
        return this.type;
    }

    @Override
    public void encode(T value, OutputStream outStream) throws IOException {
        BinaryEncoder encoderInstance = ENCODER_FACTORY.directBinaryEncoder(outStream, (BinaryEncoder)this.encoder.get());
        this.encoder.set(encoderInstance);
        ((DatumWriter)this.writer.get()).write(value, encoderInstance);
    }

    @Override
    public T decode(InputStream inStream) throws IOException {
        BinaryDecoder decoderInstance = DECODER_FACTORY.directBinaryDecoder(inStream, (BinaryDecoder)this.decoder.get());
        this.decoder.set(decoderInstance);
        return ((DatumReader)this.reader.get()).read(null, decoderInstance);
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        if (!this.nonDeterministicReasons.isEmpty()) {
            throw new Coder.NonDeterministicException(this, this.nonDeterministicReasons);
        }
    }

    public Schema getSchema() {
        return this.schemaSupplier.get();
    }

    @Override
    public TypeDescriptor<T> getEncodedTypeDescriptor() {
        return this.typeDescriptor;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AvroCoder)) {
            return false;
        }
        AvroCoder that = (AvroCoder)other;
        return Objects.equals(this.schemaSupplier.get(), that.schemaSupplier.get()) && Objects.equals(this.typeDescriptor, that.typeDescriptor);
    }

    public int hashCode() {
        return Objects.hash(this.schemaSupplier.get(), this.typeDescriptor);
    }

    public static class JodaTimestampConversion
    extends Conversion<DateTime> {
        @Override
        public Class<DateTime> getConvertedType() {
            return DateTime.class;
        }

        @Override
        public String getLogicalTypeName() {
            return "timestamp-millis";
        }

        @Override
        public DateTime fromLong(Long millisFromEpoch, Schema schema, LogicalType type) {
            return new DateTime((Object)millisFromEpoch, DateTimeZone.UTC);
        }

        @Override
        public Long toLong(DateTime timestamp, Schema schema, LogicalType type) {
            return timestamp.getMillis();
        }
    }

    private static class AvroDeterminismChecker {
        private List<String> reasons = new ArrayList<String>();
        private Set<TypeDescriptor<?>> activeTypes = new HashSet();
        private Set<Schema> activeSchemas = new HashSet<Schema>();
        private static final Set<Class<?>> DETERMINISTIC_STRINGABLE_CLASSES = new HashSet();
        private static final Schema AVRO_NULL_SCHEMA;

        private void reportError(String context, String fmt, Object ... args) {
            String message = String.format(fmt, args);
            this.reasons.add(context + ": " + message);
        }

        private static boolean isSubtypeOf(TypeDescriptor<?> type, Class<?> ... parents) {
            for (Class<?> parent : parents) {
                if (!type.isSubtypeOf(TypeDescriptor.of(parent))) continue;
                return true;
            }
            return false;
        }

        protected AvroDeterminismChecker() {
        }

        public List<String> check(TypeDescriptor<?> type, Schema schema) {
            this.recurse(type.getRawType().getName(), type, schema);
            return this.reasons;
        }

        private void recurse(String context, TypeDescriptor<?> type, Schema schema) {
            if (type.getRawType().isAnnotationPresent(AvroSchema.class)) {
                this.reportError(context, "Custom schemas are not supported -- remove @AvroSchema.", new Object[0]);
                return;
            }
            if (!this.activeTypes.add(type)) {
                this.reportError(context, "%s appears recursively", type);
                return;
            }
            if (AvroDeterminismChecker.isSubtypeOf(type, IndexedRecord.class)) {
                this.checkIndexedRecord(context, schema, null);
            } else {
                this.doCheck(context, type, schema);
            }
            this.activeTypes.remove(type);
        }

        private void doCheck(String context, TypeDescriptor<?> type, Schema schema) {
            switch (schema.getType()) {
                case ARRAY: {
                    this.checkArray(context, type, schema);
                    break;
                }
                case ENUM: {
                    break;
                }
                case FIXED: {
                    this.reportError(context, "FIXED encodings are not guaranteed to be deterministic", new Object[0]);
                    break;
                }
                case MAP: {
                    this.checkMap(context, type, schema);
                    break;
                }
                case RECORD: {
                    if (!(type.getType() instanceof Class)) {
                        this.reportError(context, "Cannot determine type from generic %s due to erasure", type);
                        return;
                    }
                    this.checkRecord(type, schema);
                    break;
                }
                case UNION: {
                    this.checkUnion(context, type, schema);
                    break;
                }
                case STRING: {
                    this.checkString(context, type);
                    break;
                }
                case BOOLEAN: 
                case BYTES: 
                case DOUBLE: 
                case INT: 
                case FLOAT: 
                case LONG: 
                case NULL: {
                    break;
                }
                default: {
                    this.reportError(context, "Unknown schema type %s may be non-deterministic", new Object[]{schema.getType()});
                }
            }
        }

        private void checkString(String context, TypeDescriptor<?> type) {
            if (!DETERMINISTIC_STRINGABLE_CLASSES.contains(type.getRawType())) {
                this.reportError(context, "%s may not have deterministic #toString()", type);
            }
        }

        private void checkUnion(String context, TypeDescriptor<?> type, Schema schema) {
            List<Schema> unionTypes = schema.getTypes();
            if (!type.getRawType().isAnnotationPresent(Union.class)) {
                if (unionTypes.size() == 2 && unionTypes.contains(AVRO_NULL_SCHEMA)) {
                    Schema nullableFieldSchema = unionTypes.get(0).equals(AVRO_NULL_SCHEMA) ? unionTypes.get(1) : unionTypes.get(0);
                    this.doCheck(context, type, nullableFieldSchema);
                    return;
                }
                this.reportError(context, "Expected type %s to have @Union annotation", type);
                return;
            }
            String baseClassContext = type.getRawType().getName();
            for (Schema concrete : unionTypes) {
                TypeDescriptor unionType = TypeDescriptor.of(ReflectData.get().getClass(concrete));
                this.recurse(baseClassContext, unionType, concrete);
            }
        }

        private void checkRecord(TypeDescriptor<?> type, Schema schema) {
            Class<?> clazz = type.getRawType();
            for (Schema.Field fieldSchema : schema.getFields()) {
                Field field = AvroDeterminismChecker.getField(clazz, fieldSchema.name());
                String fieldContext = field.getDeclaringClass().getName() + "#" + field.getName();
                if (field.isAnnotationPresent(AvroEncode.class)) {
                    this.reportError(fieldContext, "Custom encoders may be non-deterministic -- remove @AvroEncode", new Object[0]);
                    continue;
                }
                if (!IndexedRecord.class.isAssignableFrom(field.getType()) && field.isAnnotationPresent(AvroSchema.class)) {
                    this.reportError(fieldContext, "Custom schemas are only supported for subtypes of IndexedRecord.", new Object[0]);
                    continue;
                }
                TypeDescriptor<?> fieldType = type.resolveType(field.getGenericType());
                this.recurse(fieldContext, fieldType, fieldSchema.schema());
            }
        }

        private void checkIndexedRecord(String context, Schema schema, @Nullable String specificClassStr) {
            if (!this.activeSchemas.add(schema)) {
                this.reportError(context, "%s appears recursively", schema.getName());
                return;
            }
            switch (schema.getType()) {
                case ARRAY: {
                    this.checkIndexedRecord(context, schema.getElementType(), null);
                    break;
                }
                case ENUM: {
                    break;
                }
                case FIXED: {
                    break;
                }
                case MAP: {
                    this.reportError(context, "GenericRecord and SpecificRecords use a HashMap to represent MAPs, so it is non-deterministic", new Object[0]);
                    break;
                }
                case RECORD: {
                    for (Schema.Field field : schema.getFields()) {
                        this.checkIndexedRecord(schema.getName() + "." + field.name(), field.schema(), field.getProp("java-class"));
                    }
                    break;
                }
                case STRING: {
                    if (specificClassStr == null) break;
                    try {
                        Class<?> specificClass = ClassUtils.forName(specificClassStr);
                        if (DETERMINISTIC_STRINGABLE_CLASSES.contains(specificClass)) break;
                        this.reportError(context, "Specific class %s is not known to be deterministic", specificClassStr);
                    }
                    catch (ClassNotFoundException e) {
                        this.reportError(context, "Specific class %s is not known to be deterministic", specificClassStr);
                    }
                    break;
                }
                case UNION: {
                    for (Schema subschema : schema.getTypes()) {
                        this.checkIndexedRecord(subschema.getName(), subschema, null);
                    }
                    break;
                }
                case BOOLEAN: 
                case BYTES: 
                case DOUBLE: 
                case INT: 
                case FLOAT: 
                case LONG: 
                case NULL: {
                    break;
                }
                default: {
                    this.reportError(context, "Unknown schema type %s may be non-deterministic", new Object[]{schema.getType()});
                }
            }
            this.activeSchemas.remove(schema);
        }

        private void checkMap(String context, TypeDescriptor<?> type, Schema schema) {
            Class<?> keyType;
            if (!AvroDeterminismChecker.isSubtypeOf(type, SortedMap.class)) {
                this.reportError(context, "%s may not be deterministically ordered", type);
            }
            if (!String.class.equals(keyType = type.resolveType(Map.class.getTypeParameters()[0]).getRawType())) {
                this.reportError(context, "map keys should be Strings, but was %s", keyType);
            }
            this.recurse(context, type.resolveType(Map.class.getTypeParameters()[1]), schema.getValueType());
        }

        /*
         * Enabled aggressive block sorting
         */
        private void checkArray(String context, TypeDescriptor<?> type, Schema schema) {
            TypeDescriptor<?> elementType = null;
            if (type.isArray()) {
                elementType = type.getComponentType();
            } else {
                if (!AvroDeterminismChecker.isSubtypeOf(type, Collection.class)) {
                    this.reportError(context, "encoding %s as an ARRAY was unexpected", type);
                    return;
                }
                if (!AvroDeterminismChecker.isSubtypeOf(type, List.class, SortedSet.class)) {
                    this.reportError(context, "%s may not be deterministically ordered", type);
                    return;
                }
                elementType = type.resolveType(Collection.class.getTypeParameters()[0]);
            }
            this.recurse(context, elementType, schema.getElementType());
        }

        private static Field getField(Class<?> originalClazz, String name) {
            for (Class<?> clazz = originalClazz; clazz != null; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    AvroName avroName = field.getAnnotation(AvroName.class);
                    if (avroName != null && name.equals(avroName.value())) {
                        return field;
                    }
                    if (avroName != null || !name.equals(field.getName())) continue;
                    return field;
                }
            }
            throw new IllegalArgumentException("Unable to get field " + name + " from " + originalClazz);
        }

        static {
            DETERMINISTIC_STRINGABLE_CLASSES.add(String.class);
            DETERMINISTIC_STRINGABLE_CLASSES.add(Utf8.class);
            DETERMINISTIC_STRINGABLE_CLASSES.add(BigDecimal.class);
            DETERMINISTIC_STRINGABLE_CLASSES.add(BigInteger.class);
            DETERMINISTIC_STRINGABLE_CLASSES.add(URI.class);
            DETERMINISTIC_STRINGABLE_CLASSES.add(URL.class);
            AVRO_NULL_SCHEMA = Schema.create(Schema.Type.NULL);
        }
    }

    private static class SerializableReflectDataSupplier
    implements Serializable,
    Supplier<ReflectData> {
        private final Class<?> clazz;

        private SerializableReflectDataSupplier(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public ReflectData get() {
            ReflectData reflectData = new ReflectData(this.clazz.getClassLoader());
            reflectData.addLogicalTypeConversion(new JodaTimestampConversion());
            return reflectData;
        }
    }

    private static class SerializableSchemaSupplier
    implements Serializable,
    Supplier<Schema> {
        @SuppressFBWarnings(value={"SE_BAD_FIELD"})
        private final Schema schema;

        private SerializableSchemaSupplier(Schema schema) {
            this.schema = schema;
        }

        private Object writeReplace() {
            return new SerializableSchemaString(this.schema.toString());
        }

        @Override
        public Schema get() {
            return this.schema;
        }
    }

    private static class SerializableSchemaString
    implements Serializable {
        private final String schema;

        private SerializableSchemaString(String schema) {
            this.schema = schema;
        }

        private Object readResolve() throws IOException, ClassNotFoundException {
            return new SerializableSchemaSupplier(new Schema.Parser().parse(this.schema));
        }
    }

    static class AvroCoderProvider
    extends CoderProvider {
        AvroCoderProvider() {
        }

        @Override
        public <T> Coder<T> coderFor(TypeDescriptor<T> typeDescriptor, List<? extends Coder<?>> componentCoders) throws CannotProvideCoderException {
            try {
                return AvroCoder.of(typeDescriptor);
            }
            catch (AvroRuntimeException e) {
                throw new CannotProvideCoderException(String.format("%s is not compatible with Avro", typeDescriptor), e);
            }
        }
    }
}

