/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.values.TypeDescriptor;

public class BigEndianLongCoder
extends AtomicCoder<Long> {
    private static final BigEndianLongCoder INSTANCE = new BigEndianLongCoder();
    private static final TypeDescriptor<Long> TYPE_DESCRIPTOR = new TypeDescriptor<Long>(){};

    public static BigEndianLongCoder of() {
        return INSTANCE;
    }

    private BigEndianLongCoder() {
    }

    @Override
    public void encode(Long value, OutputStream outStream) throws IOException, CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null Long");
        }
        new DataOutputStream(outStream).writeLong(value);
    }

    @Override
    public Long decode(InputStream inStream) throws IOException, CoderException {
        try {
            return new DataInputStream(inStream).readLong();
        }
        catch (EOFException | UTFDataFormatException exn) {
            throw new CoderException(exn);
        }
    }

    @Override
    public void verifyDeterministic() {
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(Long value) {
        return true;
    }

    @Override
    public TypeDescriptor<Long> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    protected long getEncodedElementByteSize(Long value) throws Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null Long");
        }
        return 8L;
    }
}

