/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;

public class LengthPrefixCoder<T>
extends StructuredCoder<T> {
    private final Coder<T> valueCoder;

    public static <T> LengthPrefixCoder<T> of(Coder<T> valueCoder) {
        Preconditions.checkNotNull(valueCoder, "Coder not expected to be null");
        return new LengthPrefixCoder<T>(valueCoder);
    }

    private LengthPrefixCoder(Coder<T> valueCoder) {
        this.valueCoder = valueCoder;
    }

    @Override
    public void encode(T value, OutputStream outStream) throws CoderException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.valueCoder.encode(value, bos, Coder.Context.OUTER);
        VarInt.encode(bos.size(), outStream);
        bos.writeTo(outStream);
    }

    @Override
    public T decode(InputStream inStream) throws CoderException, IOException {
        long size = VarInt.decodeLong(inStream);
        return this.valueCoder.decode(ByteStreams.limit(inStream, size), Coder.Context.OUTER);
    }

    @Override
    public List<? extends Coder<?>> getCoderArguments() {
        return ImmutableList.of(this.valueCoder);
    }

    public Coder<T> getValueCoder() {
        return this.valueCoder;
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.valueCoder.verifyDeterministic();
    }

    @Override
    public boolean consistentWithEquals() {
        return this.valueCoder.consistentWithEquals();
    }

    @Override
    protected long getEncodedElementByteSize(T value) throws Exception {
        if (this.valueCoder instanceof StructuredCoder) {
            long valueSize = ((StructuredCoder)this.valueCoder).getEncodedElementByteSize(value);
            return (long)VarInt.getLength(valueSize) + valueSize;
        }
        return super.getEncodedElementByteSize(value);
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(T value) {
        return this.valueCoder.isRegisterByteSizeObserverCheap(value);
    }
}

