/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;
import java.util.UUID;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.BitSetCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.ByteBuddy;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.field.FieldDescription;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.field.FieldList;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.method.MethodDescription;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.method.MethodList;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.modifier.FieldManifestation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.modifier.Ownership;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.modifier.Visibility;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.type.TypeDescription;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.dynamic.DynamicType;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.FixedValue;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.Implementation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.Duplication;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.FieldAccess;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.MethodReturn;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.matcher.ElementMatchers;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SCHEMAS)
public abstract class RowCoderGenerator {
    private static final ByteBuddy BYTE_BUDDY = new ByteBuddy();
    private static final BitSetCoder NULL_LIST_CODER = BitSetCoder.of();
    private static final VarIntCoder VAR_INT_CODER = VarIntCoder.of();
    private static final BitSet EMPTY_BIT_SET = new BitSet(0);
    private static final String CODERS_FIELD_NAME = "FIELD_CODERS";
    private static final String POSITIONS_FIELD_NAME = "FIELD_ENCODING_POSITIONS";
    private static final Map<UUID, Coder<Row>> GENERATED_CODERS = Maps.newConcurrentMap();
    private static final Map<UUID, Map<String, Integer>> ENCODING_POSITION_OVERRIDES = Maps.newConcurrentMap();
    private static final Logger LOG = LoggerFactory.getLogger(RowCoderGenerator.class);

    public static void overrideEncodingPositions(UUID uuid, Map<String, Integer> encodingPositions) {
        ENCODING_POSITION_OVERRIDES.put(uuid, encodingPositions);
    }

    public static Coder<Row> generate(Schema schema) {
        Coder rowCoder = GENERATED_CODERS.get(schema.getUUID());
        if (rowCoder == null) {
            TypeDescription.Generic coderType = TypeDescription.Generic.Builder.parameterizedType(Coder.class, new Type[]{Row.class}).build();
            DynamicType.Builder<Coder> builder = BYTE_BUDDY.subclass(coderType);
            builder = RowCoderGenerator.implementMethods(schema, builder);
            int[] encodingPosToRowIndex = new int[schema.getFieldCount()];
            Map<String, Integer> encodingPositions = ENCODING_POSITION_OVERRIDES.getOrDefault(schema.getUUID(), schema.getEncodingPositions());
            int recordIndex = 0;
            while (recordIndex < schema.getFieldCount()) {
                String name = schema.getField(recordIndex).getName();
                int encodingPosition = encodingPositions.get(name);
                encodingPosToRowIndex[encodingPosition] = recordIndex++;
            }
            Preconditions.checkState((long)schema.getFieldCount() == Arrays.stream(encodingPosToRowIndex).distinct().count());
            Coder[] componentCoders = new Coder[schema.getFieldCount()];
            for (int i = 0; i < schema.getFieldCount(); ++i) {
                int rowIndex = encodingPosToRowIndex[i];
                componentCoders[i] = SchemaCoder.coderForFieldType(schema.getField(rowIndex).getType().withNullable(false));
            }
            builder = builder.defineField(CODERS_FIELD_NAME, (Type)((Object)Coder[].class), Visibility.PRIVATE, FieldManifestation.FINAL).defineField(POSITIONS_FIELD_NAME, (Type)((Object)int[].class), Visibility.PRIVATE, FieldManifestation.FINAL).defineConstructor(1).withParameters(new Type[]{Coder[].class, int[].class}).intercept(new GeneratedCoderConstructor());
            try {
                rowCoder = builder.make().load(Coder.class.getClassLoader(), ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(Coder[].class, int[].class).newInstance(componentCoders, encodingPosToRowIndex);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Unable to generate coder for schema " + schema, e);
            }
            GENERATED_CODERS.put(schema.getUUID(), rowCoder);
        }
        return rowCoder;
    }

    private static DynamicType.Builder<Coder> implementMethods(Schema schema, DynamicType.Builder<Coder> builder) {
        boolean hasNullableFields = schema.getFields().stream().map(Schema.Field::getType).anyMatch(Schema.FieldType::getNullable);
        return builder.defineMethod("getSchema", (Type)((Object)Schema.class), Visibility.PRIVATE, Ownership.STATIC).intercept(FixedValue.reference(schema)).defineMethod("hasNullableFields", Boolean.TYPE, Visibility.PRIVATE, Ownership.STATIC).intercept(FixedValue.reference(hasNullableFields)).method(ElementMatchers.named("encode")).intercept(new EncodeInstruction()).method(ElementMatchers.named("decode")).intercept(new DecodeInstruction());
    }

    private static class DecodeInstruction
    implements Implementation {
        static final TypeDescription.ForLoadedType LOADED_TYPE = new TypeDescription.ForLoadedType(DecodeInstruction.class);

        private DecodeInstruction() {
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                StackManipulation.Compound manipulation = new StackManipulation.Compound(MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)implementationContext.getInstrumentedType().getDeclaredMethods().filter(ElementMatchers.named("getSchema"))).getOnly()), MethodVariableAccess.loadThis(), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)implementationContext.getInstrumentedType().getDeclaredFields().filter(ElementMatchers.named(RowCoderGenerator.CODERS_FIELD_NAME))).getOnly()).read(), MethodVariableAccess.loadThis(), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)implementationContext.getInstrumentedType().getDeclaredFields().filter(ElementMatchers.named(RowCoderGenerator.POSITIONS_FIELD_NAME))).getOnly()).read(), MethodVariableAccess.REFERENCE.loadFrom(1), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)LOADED_TYPE.getDeclaredMethods().filter(ElementMatchers.isStatic().and(ElementMatchers.named("decodeDelegate")))).getOnly()), MethodReturn.REFERENCE);
                StackManipulation.Size size = manipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), instrumentedMethod.getStackSize());
            };
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        static Row decodeDelegate(Schema schema, Coder[] coders, int[] encodingPosToIndex, InputStream inputStream) throws IOException {
            int rowIndex;
            int encodingPos;
            int fieldCount = VAR_INT_CODER.decode(inputStream);
            BitSet nullFields = NULL_LIST_CODER.decode(inputStream);
            Object[] fieldValues = new Object[coders.length];
            for (encodingPos = 0; encodingPos < fieldCount; ++encodingPos) {
                if (encodingPos >= coders.length) continue;
                rowIndex = encodingPosToIndex[encodingPos];
                if (nullFields.get(rowIndex)) {
                    fieldValues[rowIndex] = null;
                    continue;
                }
                Object fieldValue = coders[encodingPos].decode(inputStream);
                fieldValues[rowIndex] = fieldValue;
            }
            for (encodingPos = fieldCount; encodingPos < coders.length; ++encodingPos) {
                rowIndex = encodingPosToIndex[encodingPos];
                fieldValues[rowIndex] = null;
            }
            return Row.withSchema(schema).attachValues(fieldValues);
        }
    }

    private static class EncodeInstruction
    implements Implementation {
        static final TypeDescription.ForLoadedType LOADED_TYPE = new TypeDescription.ForLoadedType(EncodeInstruction.class);

        private EncodeInstruction() {
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                StackManipulation.Compound manipulation = new StackManipulation.Compound(MethodVariableAccess.loadThis(), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)implementationContext.getInstrumentedType().getDeclaredFields().filter(ElementMatchers.named(RowCoderGenerator.CODERS_FIELD_NAME))).getOnly()).read(), MethodVariableAccess.loadThis(), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)implementationContext.getInstrumentedType().getDeclaredFields().filter(ElementMatchers.named(RowCoderGenerator.POSITIONS_FIELD_NAME))).getOnly()).read(), MethodVariableAccess.REFERENCE.loadFrom(1), MethodVariableAccess.REFERENCE.loadFrom(2), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)implementationContext.getInstrumentedType().getDeclaredMethods().filter(ElementMatchers.named("hasNullableFields"))).getOnly()), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)LOADED_TYPE.getDeclaredMethods().filter(ElementMatchers.isStatic().and(ElementMatchers.named("encodeDelegate")))).getOnly()), MethodReturn.VOID);
                StackManipulation.Size size = manipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), instrumentedMethod.getStackSize());
            };
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        static void encodeDelegate(Coder[] coders, int[] encodingPosToIndex, Row value, OutputStream outputStream, boolean hasNullableFields) throws IOException {
            Preconditions.checkState(value.getFieldCount() == value.getSchema().getFieldCount());
            Preconditions.checkState(encodingPosToIndex.length == value.getFieldCount());
            VAR_INT_CODER.encode(value.getFieldCount(), outputStream);
            if (hasNullableFields) {
                Object[] fieldValues = new Object[value.getFieldCount()];
                for (int idx = 0; idx < fieldValues.length; ++idx) {
                    fieldValues[idx] = value.getValue(idx);
                }
                NULL_LIST_CODER.encode(EncodeInstruction.scanNullFields(fieldValues), outputStream);
                for (int encodingPos = 0; encodingPos < fieldValues.length; ++encodingPos) {
                    Object fieldValue = fieldValues[encodingPosToIndex[encodingPos]];
                    if (fieldValue == null) continue;
                    coders[encodingPos].encode(fieldValue, outputStream);
                }
            } else {
                NULL_LIST_CODER.encode(EMPTY_BIT_SET, outputStream);
                for (int encodingPos = 0; encodingPos < value.getFieldCount(); ++encodingPos) {
                    Object fieldValue = value.getValue(encodingPosToIndex[encodingPos]);
                    if (fieldValue == null) continue;
                    coders[encodingPos].encode(fieldValue, outputStream);
                }
            }
        }

        private static BitSet scanNullFields(Object[] fieldValues) {
            BitSet nullFields = new BitSet(fieldValues.length);
            for (int idx = 0; idx < fieldValues.length; ++idx) {
                if (fieldValues[idx] != null) continue;
                nullFields.set(idx);
            }
            return nullFields;
        }
    }

    private static class GeneratedCoderConstructor
    implements Implementation {
        private GeneratedCoderConstructor() {
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                int numLocals = 1 + instrumentedMethod.getParameters().size();
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.loadThis(), Duplication.SINGLE, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(Coder.class).getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0)))).getOnly()), Duplication.SINGLE, MethodVariableAccess.REFERENCE.loadFrom(1), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)implementationTarget.getInstrumentedType().getDeclaredFields().filter(ElementMatchers.named(RowCoderGenerator.CODERS_FIELD_NAME))).getOnly()).write(), MethodVariableAccess.REFERENCE.loadFrom(2), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)implementationTarget.getInstrumentedType().getDeclaredFields().filter(ElementMatchers.named(RowCoderGenerator.POSITIONS_FIELD_NAME))).getOnly()).write(), MethodReturn.VOID);
                StackManipulation.Size size = stackManipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), numLocals);
            };
        }
    }
}

