/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.storage;

import org.apache.beam.sdk.extensions.gcp.storage.GcsCreateOptions;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_GcsCreateOptions
extends GcsCreateOptions {
    private final String mimeType;
    private final Boolean expectFileToNotExist;
    private final @Nullable Integer gcsUploadBufferSizeBytes;

    private AutoValue_GcsCreateOptions(String mimeType, Boolean expectFileToNotExist, @Nullable Integer gcsUploadBufferSizeBytes) {
        this.mimeType = mimeType;
        this.expectFileToNotExist = expectFileToNotExist;
        this.gcsUploadBufferSizeBytes = gcsUploadBufferSizeBytes;
    }

    @Override
    public String mimeType() {
        return this.mimeType;
    }

    @Override
    public Boolean expectFileToNotExist() {
        return this.expectFileToNotExist;
    }

    @Override
    public @Nullable Integer gcsUploadBufferSizeBytes() {
        return this.gcsUploadBufferSizeBytes;
    }

    public String toString() {
        return "GcsCreateOptions{mimeType=" + this.mimeType + ", expectFileToNotExist=" + this.expectFileToNotExist + ", gcsUploadBufferSizeBytes=" + this.gcsUploadBufferSizeBytes + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GcsCreateOptions) {
            GcsCreateOptions that = (GcsCreateOptions)o;
            return this.mimeType.equals(that.mimeType()) && this.expectFileToNotExist.equals(that.expectFileToNotExist()) && (this.gcsUploadBufferSizeBytes == null ? that.gcsUploadBufferSizeBytes() == null : this.gcsUploadBufferSizeBytes.equals(that.gcsUploadBufferSizeBytes()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.mimeType.hashCode();
        h$ *= 1000003;
        h$ ^= this.expectFileToNotExist.hashCode();
        h$ *= 1000003;
        return h$ ^= this.gcsUploadBufferSizeBytes == null ? 0 : this.gcsUploadBufferSizeBytes.hashCode();
    }

    static final class Builder
    extends GcsCreateOptions.Builder {
        private String mimeType;
        private Boolean expectFileToNotExist;
        private @Nullable Integer gcsUploadBufferSizeBytes;

        Builder() {
        }

        @Override
        public GcsCreateOptions.Builder setMimeType(String mimeType) {
            if (mimeType == null) {
                throw new NullPointerException("Null mimeType");
            }
            this.mimeType = mimeType;
            return this;
        }

        @Override
        public GcsCreateOptions.Builder setExpectFileToNotExist(Boolean expectFileToNotExist) {
            if (expectFileToNotExist == null) {
                throw new NullPointerException("Null expectFileToNotExist");
            }
            this.expectFileToNotExist = expectFileToNotExist;
            return this;
        }

        @Override
        public GcsCreateOptions.Builder setGcsUploadBufferSizeBytes(@Nullable Integer gcsUploadBufferSizeBytes) {
            this.gcsUploadBufferSizeBytes = gcsUploadBufferSizeBytes;
            return this;
        }

        @Override
        public GcsCreateOptions build() {
            String missing = "";
            if (this.mimeType == null) {
                missing = missing + " mimeType";
            }
            if (this.expectFileToNotExist == null) {
                missing = missing + " expectFileToNotExist";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_GcsCreateOptions(this.mimeType, this.expectFileToNotExist, this.gcsUploadBufferSizeBytes);
        }
    }
}

