/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.server;

import org.apache.beam.sdk.fn.server.HeaderAccessor;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.Context;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.Contexts;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.Metadata;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.ServerCall;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.ServerCallHandler;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.ServerInterceptor;

public class GrpcContextHeaderAccessorProvider {
    private static final Metadata.Key<String> WORKER_ID_KEY = Metadata.Key.of("worker_id", Metadata.ASCII_STRING_MARSHALLER);
    private static final Context.Key<String> SDK_WORKER_CONTEXT_KEY = Context.key("worker_id");
    private static final GrpcHeaderAccessor HEADER_ACCESSOR = new GrpcHeaderAccessor();
    private static final ServerInterceptor INTERCEPTOR = new ServerInterceptor(){

        @Override
        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata requestHeaders, ServerCallHandler<ReqT, RespT> next) {
            String workerId = (String)requestHeaders.get(WORKER_ID_KEY);
            Context context = Context.current().withValue(SDK_WORKER_CONTEXT_KEY, workerId);
            return Contexts.interceptCall(context, call, requestHeaders, next);
        }
    };

    public static ServerInterceptor interceptor() {
        return INTERCEPTOR;
    }

    public static HeaderAccessor getHeaderAccessor() {
        return HEADER_ACCESSOR;
    }

    private static class GrpcHeaderAccessor
    implements HeaderAccessor {
        private GrpcHeaderAccessor() {
        }

        @Override
        public String getSdkWorkerId() {
            String workerId = (String)SDK_WORKER_CONTEXT_KEY.get();
            if (workerId == null) {
                return "";
            }
            return workerId;
        }
    }
}

