/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.server;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.sdk.fn.channel.SocketAddressFactory;
import org.apache.beam.sdk.fn.server.GrpcContextHeaderAccessorProvider;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.BindableService;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.Server;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.ServerBuilder;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.ServerInterceptors;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.netty.NettyServerBuilder;
import org.apache.beam.vendor.grpc.v1p36p0.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.beam.vendor.grpc.v1p36p0.io.netty.channel.epoll.EpollServerDomainSocketChannel;
import org.apache.beam.vendor.grpc.v1p36p0.io.netty.channel.epoll.EpollServerSocketChannel;
import org.apache.beam.vendor.grpc.v1p36p0.io.netty.channel.unix.DomainSocketAddress;
import org.apache.beam.vendor.grpc.v1p36p0.io.netty.util.internal.ThreadLocalRandom;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.net.HostAndPort;

public abstract class ServerFactory {
    private static final int KEEP_ALIVE_TIME_SEC = 20;

    public static ServerFactory createDefault() {
        return new InetSocketAddressServerFactory(UrlFactory.createDefault());
    }

    public static ServerFactory createWithUrlFactory(UrlFactory urlFactory) {
        return new InetSocketAddressServerFactory(urlFactory);
    }

    public static ServerFactory createWithPortSupplier(Supplier<Integer> portSupplier) {
        return new InetSocketAddressServerFactory(UrlFactory.createDefault(), portSupplier);
    }

    public static ServerFactory createWithUrlFactoryAndPortSupplier(UrlFactory urlFactory, Supplier<Integer> portSupplier) {
        return new InetSocketAddressServerFactory(urlFactory, portSupplier);
    }

    public static ServerFactory createEpollSocket() {
        return new EpollSocket();
    }

    public static ServerFactory createEpollDomainSocket() {
        return new EpollDomainSocket();
    }

    public abstract Server allocateAddressAndCreate(List<BindableService> var1, Endpoints.ApiServiceDescriptor.Builder var2) throws IOException;

    public abstract Server create(List<BindableService> var1, Endpoints.ApiServiceDescriptor var2) throws IOException;

    @FunctionalInterface
    public static interface UrlFactory {
        public String createUrl(String var1, int var2);

        public static UrlFactory createDefault() {
            return (host, port) -> HostAndPort.fromParts(host, port).toString();
        }
    }

    private static class EpollSocket
    extends ServerFactory {
        private EpollSocket() {
        }

        @Override
        public Server allocateAddressAndCreate(List<BindableService> services, Endpoints.ApiServiceDescriptor.Builder apiServiceDescriptor) throws IOException {
            InetSocketAddress address = new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
            Server server = EpollSocket.createServer(services, address);
            apiServiceDescriptor.setUrl(HostAndPort.fromParts(address.getHostName(), server.getPort()).toString());
            return server;
        }

        @Override
        public Server create(List<BindableService> services, Endpoints.ApiServiceDescriptor serviceDescriptor) throws IOException {
            SocketAddress socketAddress = SocketAddressFactory.createFrom(serviceDescriptor.getUrl());
            Preconditions.checkArgument(socketAddress instanceof InetSocketAddress, "%s requires a host:port socket address, got %s", (Object)EpollSocket.class.getSimpleName(), (Object)serviceDescriptor.getUrl());
            return EpollSocket.createServer(services, (InetSocketAddress)socketAddress);
        }

        private static Server createServer(List<BindableService> services, InetSocketAddress socket) throws IOException {
            NettyServerBuilder builder = NettyServerBuilder.forAddress(socket).channelType(EpollServerSocketChannel.class).workerEventLoopGroup(new EpollEventLoopGroup()).bossEventLoopGroup(new EpollEventLoopGroup()).maxMessageSize(Integer.MAX_VALUE).permitKeepAliveTime(20L, TimeUnit.SECONDS);
            for (BindableService service : services) {
                ((ServerBuilder)builder).addService(ServerInterceptors.intercept(service, GrpcContextHeaderAccessorProvider.interceptor()));
            }
            return ((ServerBuilder)builder).build().start();
        }
    }

    private static class EpollDomainSocket
    extends ServerFactory {
        private EpollDomainSocket() {
        }

        private static File chooseRandomTmpFile(int port) {
            return new File(System.getProperty("java.io.tmpdir"), String.format("fnapi%d.sock", port));
        }

        @Override
        public Server allocateAddressAndCreate(List<BindableService> services, Endpoints.ApiServiceDescriptor.Builder apiServiceDescriptor) throws IOException {
            File tmp;
            while ((tmp = EpollDomainSocket.chooseRandomTmpFile(ThreadLocalRandom.current().nextInt(10000))).exists()) {
            }
            apiServiceDescriptor.setUrl("unix://" + tmp.getAbsolutePath());
            return this.create(services, apiServiceDescriptor.build());
        }

        @Override
        public Server create(List<BindableService> services, Endpoints.ApiServiceDescriptor serviceDescriptor) throws IOException {
            SocketAddress socketAddress = SocketAddressFactory.createFrom(serviceDescriptor.getUrl());
            Preconditions.checkArgument(socketAddress instanceof DomainSocketAddress, "%s requires a Unix domain socket address, got %s", (Object)EpollDomainSocket.class.getSimpleName(), (Object)serviceDescriptor.getUrl());
            return EpollDomainSocket.createServer(services, (DomainSocketAddress)socketAddress);
        }

        private static Server createServer(List<BindableService> services, DomainSocketAddress domainSocket) throws IOException {
            NettyServerBuilder builder = NettyServerBuilder.forAddress(domainSocket).channelType(EpollServerDomainSocketChannel.class).workerEventLoopGroup(new EpollEventLoopGroup()).bossEventLoopGroup(new EpollEventLoopGroup()).maxMessageSize(Integer.MAX_VALUE).permitKeepAliveTime(20L, TimeUnit.SECONDS);
            for (BindableService service : services) {
                builder.addService(ServerInterceptors.intercept(service, GrpcContextHeaderAccessorProvider.interceptor()));
            }
            return builder.build().start();
        }
    }

    public static class InetSocketAddressServerFactory
    extends ServerFactory {
        private final UrlFactory urlFactory;
        private final Supplier<Integer> portSupplier;

        private InetSocketAddressServerFactory(UrlFactory urlFactory) {
            this(urlFactory, () -> 0);
        }

        private InetSocketAddressServerFactory(UrlFactory urlFactory, Supplier<Integer> portSupplier) {
            this.urlFactory = urlFactory;
            this.portSupplier = portSupplier;
        }

        @Override
        public Server allocateAddressAndCreate(List<BindableService> services, Endpoints.ApiServiceDescriptor.Builder apiServiceDescriptor) throws IOException {
            InetSocketAddress address = new InetSocketAddress(InetAddress.getLoopbackAddress(), (int)this.portSupplier.get());
            Server server = InetSocketAddressServerFactory.createServer(services, address);
            apiServiceDescriptor.setUrl(this.urlFactory.createUrl(address.getHostName(), server.getPort()));
            return server;
        }

        @Override
        public Server create(List<BindableService> services, Endpoints.ApiServiceDescriptor serviceDescriptor) throws IOException {
            SocketAddress socketAddress = SocketAddressFactory.createFrom(serviceDescriptor.getUrl());
            Preconditions.checkArgument(socketAddress instanceof InetSocketAddress, "%s %s requires a host:port socket address, got %s", (Object)this.getClass().getSimpleName(), (Object)ServerFactory.class.getSimpleName(), (Object)serviceDescriptor.getUrl());
            return InetSocketAddressServerFactory.createServer(services, (InetSocketAddress)socketAddress);
        }

        private static Server createServer(List<BindableService> services, InetSocketAddress socket) throws IOException {
            NettyServerBuilder builder = NettyServerBuilder.forPort(socket.getPort()).maxMessageSize(Integer.MAX_VALUE).permitKeepAliveTime(20L, TimeUnit.SECONDS);
            services.stream().forEach(service -> {
                NettyServerBuilder cfr_ignored_0 = (NettyServerBuilder)builder.addService(ServerInterceptors.intercept(service, GrpcContextHeaderAccessorProvider.interceptor()));
            });
            return builder.build().start();
        }
    }
}

