/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import org.apache.avro.Schema;
import org.apache.beam.sdk.io.AvroIO;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.options.ValueProvider;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_AvroIO_Read<T>
extends AvroIO.Read<T> {
    private final @Nullable ValueProvider<String> filepattern;
    private final FileIO.MatchConfiguration matchConfiguration;
    private final @Nullable Class<T> recordClass;
    private final @Nullable Schema schema;
    private final boolean inferBeamSchema;
    private final boolean hintMatchesManyFiles;

    private AutoValue_AvroIO_Read(@Nullable ValueProvider<String> filepattern, FileIO.MatchConfiguration matchConfiguration, @Nullable Class<T> recordClass, @Nullable Schema schema, boolean inferBeamSchema, boolean hintMatchesManyFiles) {
        this.filepattern = filepattern;
        this.matchConfiguration = matchConfiguration;
        this.recordClass = recordClass;
        this.schema = schema;
        this.inferBeamSchema = inferBeamSchema;
        this.hintMatchesManyFiles = hintMatchesManyFiles;
    }

    @Override
    @Nullable ValueProvider<String> getFilepattern() {
        return this.filepattern;
    }

    @Override
    FileIO.MatchConfiguration getMatchConfiguration() {
        return this.matchConfiguration;
    }

    @Override
    @Nullable Class<T> getRecordClass() {
        return this.recordClass;
    }

    @Override
    @Nullable Schema getSchema() {
        return this.schema;
    }

    @Override
    boolean getInferBeamSchema() {
        return this.inferBeamSchema;
    }

    @Override
    boolean getHintMatchesManyFiles() {
        return this.hintMatchesManyFiles;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AvroIO.Read) {
            AvroIO.Read that = (AvroIO.Read)o;
            return (this.filepattern == null ? that.getFilepattern() == null : this.filepattern.equals(that.getFilepattern())) && this.matchConfiguration.equals(that.getMatchConfiguration()) && (this.recordClass == null ? that.getRecordClass() == null : this.recordClass.equals(that.getRecordClass())) && (this.schema == null ? that.getSchema() == null : this.schema.equals(that.getSchema())) && this.inferBeamSchema == that.getInferBeamSchema() && this.hintMatchesManyFiles == that.getHintMatchesManyFiles();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.filepattern == null ? 0 : this.filepattern.hashCode();
        h$ *= 1000003;
        h$ ^= this.matchConfiguration.hashCode();
        h$ *= 1000003;
        h$ ^= this.recordClass == null ? 0 : this.recordClass.hashCode();
        h$ *= 1000003;
        h$ ^= this.schema == null ? 0 : this.schema.hashCode();
        h$ *= 1000003;
        h$ ^= this.inferBeamSchema ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.hintMatchesManyFiles ? 1231 : 1237;
    }

    @Override
    AvroIO.Read.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends AvroIO.Read.Builder<T> {
        private @Nullable ValueProvider<String> filepattern;
        private FileIO.MatchConfiguration matchConfiguration;
        private @Nullable Class<T> recordClass;
        private @Nullable Schema schema;
        private Boolean inferBeamSchema;
        private Boolean hintMatchesManyFiles;

        Builder() {
        }

        private Builder(AvroIO.Read<T> source) {
            this.filepattern = source.getFilepattern();
            this.matchConfiguration = source.getMatchConfiguration();
            this.recordClass = source.getRecordClass();
            this.schema = source.getSchema();
            this.inferBeamSchema = source.getInferBeamSchema();
            this.hintMatchesManyFiles = source.getHintMatchesManyFiles();
        }

        @Override
        AvroIO.Read.Builder<T> setFilepattern(ValueProvider<String> filepattern) {
            this.filepattern = filepattern;
            return this;
        }

        @Override
        AvroIO.Read.Builder<T> setMatchConfiguration(FileIO.MatchConfiguration matchConfiguration) {
            if (matchConfiguration == null) {
                throw new NullPointerException("Null matchConfiguration");
            }
            this.matchConfiguration = matchConfiguration;
            return this;
        }

        @Override
        AvroIO.Read.Builder<T> setRecordClass(Class<T> recordClass) {
            this.recordClass = recordClass;
            return this;
        }

        @Override
        AvroIO.Read.Builder<T> setSchema(Schema schema) {
            this.schema = schema;
            return this;
        }

        @Override
        AvroIO.Read.Builder<T> setInferBeamSchema(boolean inferBeamSchema) {
            this.inferBeamSchema = inferBeamSchema;
            return this;
        }

        @Override
        AvroIO.Read.Builder<T> setHintMatchesManyFiles(boolean hintMatchesManyFiles) {
            this.hintMatchesManyFiles = hintMatchesManyFiles;
            return this;
        }

        @Override
        AvroIO.Read<T> build() {
            String missing = "";
            if (this.matchConfiguration == null) {
                missing = missing + " matchConfiguration";
            }
            if (this.inferBeamSchema == null) {
                missing = missing + " inferBeamSchema";
            }
            if (this.hintMatchesManyFiles == null) {
                missing = missing + " hintMatchesManyFiles";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AvroIO_Read(this.filepattern, this.matchConfiguration, this.recordClass, this.schema, this.inferBeamSchema, this.hintMatchesManyFiles);
        }
    }
}

