/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.util.Arrays;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.TextRowCountEstimator;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_TextRowCountEstimator
extends TextRowCountEstimator {
    private final long numSampledBytesPerFile;
    private final byte @Nullable [] delimiters;
    private final String filePattern;
    private final Compression compression;
    private final TextRowCountEstimator.SamplingStrategy samplingStrategy;
    private final EmptyMatchTreatment emptyMatchTreatment;
    private final FileIO.ReadMatches.DirectoryTreatment directoryTreatment;

    private AutoValue_TextRowCountEstimator(long numSampledBytesPerFile, byte @Nullable [] delimiters, String filePattern, Compression compression, TextRowCountEstimator.SamplingStrategy samplingStrategy, EmptyMatchTreatment emptyMatchTreatment, FileIO.ReadMatches.DirectoryTreatment directoryTreatment) {
        this.numSampledBytesPerFile = numSampledBytesPerFile;
        this.delimiters = delimiters;
        this.filePattern = filePattern;
        this.compression = compression;
        this.samplingStrategy = samplingStrategy;
        this.emptyMatchTreatment = emptyMatchTreatment;
        this.directoryTreatment = directoryTreatment;
    }

    @Override
    public long getNumSampledBytesPerFile() {
        return this.numSampledBytesPerFile;
    }

    @Override
    public byte @Nullable [] getDelimiters() {
        return this.delimiters;
    }

    @Override
    public String getFilePattern() {
        return this.filePattern;
    }

    @Override
    public Compression getCompression() {
        return this.compression;
    }

    @Override
    public TextRowCountEstimator.SamplingStrategy getSamplingStrategy() {
        return this.samplingStrategy;
    }

    @Override
    public EmptyMatchTreatment getEmptyMatchTreatment() {
        return this.emptyMatchTreatment;
    }

    @Override
    public FileIO.ReadMatches.DirectoryTreatment getDirectoryTreatment() {
        return this.directoryTreatment;
    }

    public String toString() {
        return "TextRowCountEstimator{numSampledBytesPerFile=" + this.numSampledBytesPerFile + ", delimiters=" + Arrays.toString(this.delimiters) + ", filePattern=" + this.filePattern + ", compression=" + (Object)((Object)this.compression) + ", samplingStrategy=" + this.samplingStrategy + ", emptyMatchTreatment=" + (Object)((Object)this.emptyMatchTreatment) + ", directoryTreatment=" + (Object)((Object)this.directoryTreatment) + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TextRowCountEstimator) {
            TextRowCountEstimator that = (TextRowCountEstimator)o;
            return this.numSampledBytesPerFile == that.getNumSampledBytesPerFile() && Arrays.equals(this.delimiters, that instanceof AutoValue_TextRowCountEstimator ? ((AutoValue_TextRowCountEstimator)that).delimiters : that.getDelimiters()) && this.filePattern.equals(that.getFilePattern()) && this.compression.equals((Object)that.getCompression()) && this.samplingStrategy.equals(that.getSamplingStrategy()) && this.emptyMatchTreatment.equals((Object)that.getEmptyMatchTreatment()) && this.directoryTreatment.equals((Object)that.getDirectoryTreatment());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= (int)(this.numSampledBytesPerFile >>> 32 ^ this.numSampledBytesPerFile);
        h$ *= 1000003;
        h$ ^= Arrays.hashCode(this.delimiters);
        h$ *= 1000003;
        h$ ^= this.filePattern.hashCode();
        h$ *= 1000003;
        h$ ^= this.compression.hashCode();
        h$ *= 1000003;
        h$ ^= this.samplingStrategy.hashCode();
        h$ *= 1000003;
        h$ ^= this.emptyMatchTreatment.hashCode();
        h$ *= 1000003;
        return h$ ^= this.directoryTreatment.hashCode();
    }

    static final class Builder
    extends TextRowCountEstimator.Builder {
        private Long numSampledBytesPerFile;
        private byte @Nullable [] delimiters;
        private String filePattern;
        private Compression compression;
        private TextRowCountEstimator.SamplingStrategy samplingStrategy;
        private EmptyMatchTreatment emptyMatchTreatment;
        private FileIO.ReadMatches.DirectoryTreatment directoryTreatment;

        Builder() {
        }

        @Override
        public TextRowCountEstimator.Builder setNumSampledBytesPerFile(long numSampledBytesPerFile) {
            this.numSampledBytesPerFile = numSampledBytesPerFile;
            return this;
        }

        @Override
        public TextRowCountEstimator.Builder setDelimiters(byte @Nullable [] delimiters) {
            this.delimiters = delimiters;
            return this;
        }

        @Override
        public TextRowCountEstimator.Builder setFilePattern(String filePattern) {
            if (filePattern == null) {
                throw new NullPointerException("Null filePattern");
            }
            this.filePattern = filePattern;
            return this;
        }

        @Override
        public TextRowCountEstimator.Builder setCompression(Compression compression) {
            if (compression == null) {
                throw new NullPointerException("Null compression");
            }
            this.compression = compression;
            return this;
        }

        @Override
        public TextRowCountEstimator.Builder setSamplingStrategy(TextRowCountEstimator.SamplingStrategy samplingStrategy) {
            if (samplingStrategy == null) {
                throw new NullPointerException("Null samplingStrategy");
            }
            this.samplingStrategy = samplingStrategy;
            return this;
        }

        @Override
        public TextRowCountEstimator.Builder setEmptyMatchTreatment(EmptyMatchTreatment emptyMatchTreatment) {
            if (emptyMatchTreatment == null) {
                throw new NullPointerException("Null emptyMatchTreatment");
            }
            this.emptyMatchTreatment = emptyMatchTreatment;
            return this;
        }

        @Override
        public TextRowCountEstimator.Builder setDirectoryTreatment(FileIO.ReadMatches.DirectoryTreatment directoryTreatment) {
            if (directoryTreatment == null) {
                throw new NullPointerException("Null directoryTreatment");
            }
            this.directoryTreatment = directoryTreatment;
            return this;
        }

        @Override
        public TextRowCountEstimator build() {
            String missing = "";
            if (this.numSampledBytesPerFile == null) {
                missing = missing + " numSampledBytesPerFile";
            }
            if (this.filePattern == null) {
                missing = missing + " filePattern";
            }
            if (this.compression == null) {
                missing = missing + " compression";
            }
            if (this.samplingStrategy == null) {
                missing = missing + " samplingStrategy";
            }
            if (this.emptyMatchTreatment == null) {
                missing = missing + " emptyMatchTreatment";
            }
            if (this.directoryTreatment == null) {
                missing = missing + " directoryTreatment";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_TextRowCountEstimator(this.numSampledBytesPerFile, this.delimiters, this.filePattern, this.compression, this.samplingStrategy, this.emptyMatchTreatment, this.directoryTreatment);
        }
    }
}

