/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.FileSystem;
import org.apache.beam.sdk.io.FileSystemRegistrar;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClassLoaderFileSystem
extends FileSystem<ClassLoaderResourceId> {
    public static final String SCHEMA = "classpath";
    private static final String PREFIX = "classpath://";

    ClassLoaderFileSystem() {
    }

    @Override
    protected List<MatchResult> match(List<String> specs) throws IOException {
        throw new UnsupportedOperationException("Un-globbable filesystem.");
    }

    @Override
    protected WritableByteChannel create(ClassLoaderResourceId resourceId, CreateOptions createOptions) throws IOException {
        throw new UnsupportedOperationException("Read-only filesystem.");
    }

    @Override
    protected ReadableByteChannel open(ClassLoaderResourceId resourceId) throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(resourceId.path.substring(PREFIX.length()));
        if (inputStream == null) {
            throw new IOException("Unable to load " + resourceId.path + " with " + classLoader + " URL " + classLoader.getResource(resourceId.path.substring(PREFIX.length())));
        }
        return Channels.newChannel(inputStream);
    }

    @Override
    protected void copy(List<ClassLoaderResourceId> srcResourceIds, List<ClassLoaderResourceId> destResourceIds) throws IOException {
        throw new UnsupportedOperationException("Read-only filesystem.");
    }

    @Override
    protected void rename(List<ClassLoaderResourceId> srcResourceIds, List<ClassLoaderResourceId> destResourceIds, MoveOptions ... moveOptions) throws IOException {
        throw new UnsupportedOperationException("Read-only filesystem.");
    }

    @Override
    protected void delete(Collection<ClassLoaderResourceId> resourceIds) throws IOException {
        throw new UnsupportedOperationException("Read-only filesystem.");
    }

    @Override
    protected ClassLoaderResourceId matchNewResource(String path, boolean isDirectory) {
        return new ClassLoaderResourceId(path);
    }

    @Override
    protected String getScheme() {
        return SCHEMA;
    }

    @Experimental(value=Experimental.Kind.FILESYSTEM)
    public static class ClassLoaderFileSystemRegistrar
    implements FileSystemRegistrar {
        @Override
        public Iterable<FileSystem<?>> fromOptions(@Nullable PipelineOptions options) {
            return ImmutableList.of(new ClassLoaderFileSystem());
        }
    }

    public static class ClassLoaderResourceId
    implements ResourceId {
        private final String path;

        private ClassLoaderResourceId(String path) {
            Preconditions.checkArgument(path.startsWith(ClassLoaderFileSystem.PREFIX), path);
            this.path = path;
        }

        @Override
        public ClassLoaderResourceId resolve(String other, ResolveOptions resolveOptions) {
            if (other.startsWith(ClassLoaderFileSystem.PREFIX)) {
                return new ClassLoaderResourceId(other);
            }
            if (other.startsWith("/")) {
                return new ClassLoaderResourceId("classpath:/" + other);
            }
            return new ClassLoaderResourceId(this.path + "/" + other);
        }

        @Override
        public ClassLoaderResourceId getCurrentDirectory() {
            int ix = this.path.lastIndexOf(47);
            if (ix <= ClassLoaderFileSystem.PREFIX.length()) {
                return new ClassLoaderResourceId(ClassLoaderFileSystem.PREFIX);
            }
            return new ClassLoaderResourceId(this.path.substring(0, ix));
        }

        @Override
        public String getScheme() {
            return ClassLoaderFileSystem.SCHEMA;
        }

        @Override
        public @Nullable String getFilename() {
            return this.path;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }
    }
}

