/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import java.util.Set;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricNameFilter;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MetricFiltering {
    private MetricFiltering() {
    }

    public static boolean matches(MetricsFilter filter, MetricKey key) {
        if (filter == null) {
            return true;
        }
        @Nullable String stepName = key.stepName();
        if (stepName == null ? !filter.steps().isEmpty() : !MetricFiltering.matchesScope(stepName, filter.steps())) {
            return false;
        }
        return MetricFiltering.matchesName(key.metricName(), filter.names());
    }

    public static boolean subPathMatches(String haystack, String needle) {
        int location = haystack.indexOf(needle);
        int end = location + needle.length();
        if (location == -1) {
            return false;
        }
        if (location != 0 && haystack.charAt(location - 1) != '/') {
            return false;
        }
        return end == haystack.length() || haystack.charAt(end) == '/';
    }

    public static boolean matchesScope(String actualScope, Set<String> scopes) {
        if (scopes.isEmpty() || scopes.contains(actualScope)) {
            return true;
        }
        for (String scope : scopes) {
            if (!MetricFiltering.subPathMatches(actualScope, scope)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesName(MetricName metricName, Set<MetricNameFilter> nameFilters) {
        if (nameFilters.isEmpty()) {
            return true;
        }
        for (MetricNameFilter nameFilter : nameFilters) {
            @Nullable String name = nameFilter.getName();
            if (name != null && !name.equals(metricName.getName()) || !Objects.equal(metricName.getNamespace(), nameFilter.getNamespace())) continue;
            return true;
        }
        return false;
    }
}

