/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import java.io.Serializable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.DelegatingCounter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Gauge;
import org.apache.beam.sdk.metrics.Metric;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;

@Experimental(value=Experimental.Kind.METRICS)
public class Metrics {
    private Metrics() {
    }

    public static Counter counter(String namespace, String name) {
        return new DelegatingCounter(MetricName.named(namespace, name));
    }

    public static Counter counter(Class<?> namespace, String name) {
        return new DelegatingCounter(MetricName.named(namespace, name));
    }

    public static Distribution distribution(String namespace, String name) {
        return new DelegatingDistribution(MetricName.named(namespace, name));
    }

    public static Distribution distribution(Class<?> namespace, String name) {
        return new DelegatingDistribution(MetricName.named(namespace, name));
    }

    public static Gauge gauge(String namespace, String name) {
        return new DelegatingGauge(MetricName.named(namespace, name));
    }

    public static Gauge gauge(Class<?> namespace, String name) {
        return new DelegatingGauge(MetricName.named(namespace, name));
    }

    private static class DelegatingGauge
    implements Metric,
    Gauge,
    Serializable {
        private final MetricName name;

        private DelegatingGauge(MetricName name) {
            this.name = name;
        }

        @Override
        public void set(long value) {
            MetricsContainer container = MetricsEnvironment.getCurrentContainer();
            if (container != null) {
                container.getGauge(this.name).set(value);
            }
        }

        @Override
        public MetricName getName() {
            return this.name;
        }
    }

    private static class DelegatingDistribution
    implements Metric,
    Distribution,
    Serializable {
        private final MetricName name;

        private DelegatingDistribution(MetricName name) {
            this.name = name;
        }

        @Override
        public void update(long value) {
            MetricsContainer container = MetricsEnvironment.getCurrentContainer();
            if (container != null) {
                container.getDistribution(this.name).update(value);
            }
        }

        @Override
        public void update(long sum, long count, long min2, long max) {
            MetricsContainer container = MetricsEnvironment.getCurrentContainer();
            if (container != null) {
                container.getDistribution(this.name).update(sum, count, min2, max);
            }
        }

        @Override
        public MetricName getName() {
            return this.name;
        }
    }
}

