/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.METRICS)
@Internal
public class MetricsEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsEnvironment.class);
    private static final AtomicBoolean METRICS_SUPPORTED = new AtomicBoolean(false);
    private static final AtomicBoolean REPORTED_MISSING_CONTAINER = new AtomicBoolean(false);
    private static final ThreadLocal<@Nullable MetricsContainerHolder> CONTAINER_FOR_THREAD = ThreadLocal.withInitial(() -> new MetricsContainerHolder());
    private static final AtomicReference<@Nullable MetricsContainer> PROCESS_WIDE_METRICS_CONTAINER = new AtomicReference();

    public static @Nullable MetricsContainer setCurrentContainer(@Nullable MetricsContainer container) {
        @NonNull MetricsContainerHolder holder = CONTAINER_FOR_THREAD.get();
        @Nullable MetricsContainer previous = holder.container;
        holder.container = container;
        return previous;
    }

    public static @Nullable MetricsContainer setProcessWideContainer(@Nullable MetricsContainer container) {
        return PROCESS_WIDE_METRICS_CONTAINER.getAndSet(container);
    }

    public static void setMetricsSupported(boolean supported) {
        METRICS_SUPPORTED.set(supported);
    }

    public static boolean isMetricsSupported() {
        return METRICS_SUPPORTED.get();
    }

    public static Closeable scopedMetricsContainer(MetricsContainer container) {
        return new ScopedContainer(container);
    }

    public static @Nullable MetricsContainer getCurrentContainer() {
        MetricsContainer container = MetricsEnvironment.CONTAINER_FOR_THREAD.get().container;
        if (container == null && REPORTED_MISSING_CONTAINER.compareAndSet(false, true)) {
            if (MetricsEnvironment.isMetricsSupported()) {
                LOG.error("Unable to update metrics on the current thread. Most likely caused by using metrics outside the managed work-execution thread.");
            } else {
                LOG.warn("Reporting metrics are not supported in the current execution environment.");
            }
        }
        return container;
    }

    public static @Nullable MetricsContainer getProcessWideContainer() {
        return PROCESS_WIDE_METRICS_CONTAINER.get();
    }

    static /* synthetic */ ThreadLocal access$100() {
        return CONTAINER_FOR_THREAD;
    }

    private static class MetricsContainerHolder {
        public @Nullable MetricsContainer container = null;

        private MetricsContainerHolder() {
        }
    }

    private static class ScopedContainer
    implements Closeable {
        private final MetricsContainerHolder holder = (MetricsContainerHolder)MetricsEnvironment.access$100().get();
        private final @Nullable MetricsContainer oldContainer;

        private ScopedContainer(MetricsContainer newContainer) {
            this.oldContainer = this.holder.container;
            this.holder.container = newContainer;
        }

        @Override
        public void close() throws IOException {
            this.holder.container = this.oldContainer;
        }
    }
}

