/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.CachingFactory;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.GetterBasedSchemaProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.schemas.logicaltypes.OneOfType;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.RowWithGetters;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Collections2;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SCHEMAS)
class FromRowUsingCreator<T>
implements SerializableFunction<Row, T> {
    private final Class<T> clazz;
    private final GetterBasedSchemaProvider schemaProvider;
    private final Factory<SchemaUserTypeCreator> schemaTypeCreatorFactory;
    private final Factory<List<FieldValueTypeInformation>> fieldValueTypeInformationFactory;

    public FromRowUsingCreator(Class<T> clazz, GetterBasedSchemaProvider schemaProvider) {
        this.clazz = clazz;
        this.schemaProvider = schemaProvider;
        this.schemaTypeCreatorFactory = new CachingFactory<SchemaUserTypeCreator>(schemaProvider::schemaTypeCreator);
        this.fieldValueTypeInformationFactory = new CachingFactory<List>(schemaProvider::fieldValueTypeInformations);
    }

    @Override
    public T apply(Row row) {
        return this.fromRow(row, this.clazz, this.fieldValueTypeInformationFactory);
    }

    public <ValueT> ValueT fromRow(Row row, Class<ValueT> clazz, Factory<List<FieldValueTypeInformation>> typeFactory) {
        Object target;
        if (row instanceof RowWithGetters && (target = ((RowWithGetters)row).getGetterTarget()).getClass().equals(clazz)) {
            return (ValueT)target;
        }
        Object[] params = new Object[row.getFieldCount()];
        Schema schema = row.getSchema();
        List<FieldValueTypeInformation> typeInformations = typeFactory.create(clazz, schema);
        Preconditions.checkState(typeInformations.size() == row.getFieldCount(), "Did not have a matching number of type informations and fields.");
        for (int i = 0; i < row.getFieldCount(); ++i) {
            Schema.FieldType type = schema.getField(i).getType();
            FieldValueTypeInformation typeInformation = Preconditions.checkNotNull(typeInformations.get(i));
            params[i] = this.fromValue(type, row.getValue(i), typeInformation.getRawType(), typeInformation, typeFactory);
        }
        SchemaUserTypeCreator creator = this.schemaTypeCreatorFactory.create(clazz, schema);
        return (ValueT)creator.create(params);
    }

    private <ValueT> @Nullable ValueT fromValue(Schema.FieldType type, ValueT value, Type fieldType, FieldValueTypeInformation fieldValueTypeInformation, Factory<List<FieldValueTypeInformation>> typeFactory) {
        FieldValueTypeInformation elementType = fieldValueTypeInformation.getElementType();
        FieldValueTypeInformation keyType = fieldValueTypeInformation.getMapKeyType();
        FieldValueTypeInformation valueType = fieldValueTypeInformation.getMapValueType();
        if (value == null) {
            return null;
        }
        if (Schema.TypeName.ROW.equals((Object)type.getTypeName())) {
            return this.fromRow((Row)value, (Class)fieldType, typeFactory);
        }
        if (Schema.TypeName.ARRAY.equals((Object)type.getTypeName())) {
            return (ValueT)this.fromCollectionValue(type.getCollectionElementType(), (Collection)value, elementType, typeFactory);
        }
        if (Schema.TypeName.ITERABLE.equals((Object)type.getTypeName())) {
            return (ValueT)this.fromIterableValue(type.getCollectionElementType(), (Iterable)value, elementType, typeFactory);
        }
        if (Schema.TypeName.MAP.equals((Object)type.getTypeName())) {
            return (ValueT)this.fromMapValue(type.getMapKeyType(), type.getMapValueType(), (Map)value, keyType, valueType, typeFactory);
        }
        if (type.isLogicalType("OneOf")) {
            OneOfType oneOfType = type.getLogicalType(OneOfType.class);
            EnumerationType oneOfEnum = oneOfType.getCaseEnumType();
            OneOfType.Value oneOfValue = (OneOfType.Value)value;
            FieldValueTypeInformation oneOfFieldValueTypeInformation = Preconditions.checkNotNull(fieldValueTypeInformation.getOneOfTypes().get(oneOfEnum.toString(oneOfValue.getCaseType())));
            Object fromValue = this.fromValue(oneOfType.getFieldType(oneOfValue), oneOfValue.getValue(), oneOfFieldValueTypeInformation.getRawType(), oneOfFieldValueTypeInformation, typeFactory);
            return (ValueT)oneOfType.createValue(oneOfValue.getCaseType(), fromValue);
        }
        if (type.getTypeName().isLogicalType()) {
            return (ValueT)type.getLogicalType().toBaseType(value);
        }
        return value;
    }

    private static <SourceT, DestT> Collection<DestT> transformCollection(Collection<SourceT> collection, Function<SourceT, DestT> function) {
        if (collection instanceof List) {
            return Lists.transform((List)collection, function);
        }
        return Collections2.transform(collection, function);
    }

    private <ElementT> Collection fromCollectionValue(Schema.FieldType elementType, Collection<ElementT> rowCollection, FieldValueTypeInformation elementTypeInformation, Factory<List<FieldValueTypeInformation>> typeFactory) {
        return FromRowUsingCreator.transformCollection(rowCollection, element -> this.fromValue(elementType, element, elementTypeInformation.getType().getType(), elementTypeInformation, typeFactory));
    }

    private <ElementT> Iterable fromIterableValue(Schema.FieldType elementType, Iterable<ElementT> rowIterable, FieldValueTypeInformation elementTypeInformation, Factory<List<FieldValueTypeInformation>> typeFactory) {
        return Iterables.transform(rowIterable, element -> this.fromValue(elementType, element, elementTypeInformation.getType().getType(), elementTypeInformation, typeFactory));
    }

    private Map<?, ?> fromMapValue(Schema.FieldType keyType, Schema.FieldType valueType, Map<?, ?> map, FieldValueTypeInformation keyTypeInformation, FieldValueTypeInformation valueTypeInformation, Factory<List<FieldValueTypeInformation>> typeFactory) {
        HashMap<?, ?> newMap = Maps.newHashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = this.fromValue(keyType, entry.getKey(), keyTypeInformation.getType().getType(), keyTypeInformation, typeFactory);
            Object value = this.fromValue(valueType, entry.getValue(), valueTypeInformation.getType().getType(), valueTypeInformation, typeFactory);
            newMap.put(key, value);
        }
        return newMap;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FromRowUsingCreator that = (FromRowUsingCreator)o;
        return this.clazz.equals(that.clazz) && this.schemaProvider.equals(that.schemaProvider);
    }

    public int hashCode() {
        return Objects.hash(this.clazz, this.schemaProvider);
    }
}

