/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.coders.BigDecimalCoder;
import org.apache.beam.sdk.coders.BigEndianShortCoder;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.ByteCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.FloatCoder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.joda.time.ReadableInstant;

class SchemaCoderHelpers {
    private static final Map<Schema.TypeName, Coder> CODER_MAP = ImmutableMap.builder().put(Schema.TypeName.BYTE, ByteCoder.of()).put(Schema.TypeName.BYTES, (ByteCoder)((Object)ByteArrayCoder.of())).put(Schema.TypeName.INT16, (ByteCoder)((Object)BigEndianShortCoder.of())).put(Schema.TypeName.INT32, (ByteCoder)((Object)VarIntCoder.of())).put(Schema.TypeName.INT64, (ByteCoder)((Object)VarLongCoder.of())).put(Schema.TypeName.DECIMAL, (ByteCoder)((Object)BigDecimalCoder.of())).put(Schema.TypeName.FLOAT, (ByteCoder)((Object)FloatCoder.of())).put(Schema.TypeName.DOUBLE, (ByteCoder)((Object)DoubleCoder.of())).put(Schema.TypeName.STRING, (ByteCoder)((Object)StringUtf8Coder.of())).put(Schema.TypeName.DATETIME, (ByteCoder)((Object)InstantCoder.of())).put(Schema.TypeName.BOOLEAN, (ByteCoder)((Object)BooleanCoder.of())).build();

    SchemaCoderHelpers() {
    }

    public static <T> Coder<T> coderForFieldType(Schema.FieldType fieldType) {
        Coder coder;
        switch (fieldType.getTypeName()) {
            case ROW: {
                coder = SchemaCoder.of(fieldType.getRowSchema());
                break;
            }
            case ARRAY: {
                coder = ListCoder.of(SchemaCoderHelpers.coderForFieldType(fieldType.getCollectionElementType()));
                break;
            }
            case ITERABLE: {
                coder = IterableCoder.of(SchemaCoderHelpers.coderForFieldType(fieldType.getCollectionElementType()));
                break;
            }
            case MAP: {
                coder = MapCoder.of(SchemaCoderHelpers.coderForFieldType(fieldType.getMapKeyType()), SchemaCoderHelpers.coderForFieldType(fieldType.getMapValueType()));
                break;
            }
            case LOGICAL_TYPE: {
                coder = new LogicalTypeCoder(fieldType.getLogicalType(), SchemaCoderHelpers.coderForFieldType(fieldType.getLogicalType().getBaseType()));
                break;
            }
            default: {
                coder = CODER_MAP.get((Object)fieldType.getTypeName());
            }
        }
        Preconditions.checkNotNull(coder, "Unexpected field type " + (Object)((Object)fieldType.getTypeName()));
        if (fieldType.getNullable().booleanValue()) {
            coder = NullableCoder.of(coder);
        }
        return coder;
    }

    private static class LogicalTypeCoder<InputT, BaseT>
    extends Coder<InputT> {
        private final Schema.LogicalType<InputT, BaseT> logicalType;
        private final Coder<BaseT> baseTypeCoder;
        private final boolean isDateTime;

        LogicalTypeCoder(Schema.LogicalType<InputT, BaseT> logicalType, Coder baseTypeCoder) {
            this.logicalType = logicalType;
            this.baseTypeCoder = baseTypeCoder;
            this.isDateTime = logicalType.getBaseType().equals(Schema.FieldType.DATETIME);
        }

        @Override
        public void encode(InputT value, OutputStream outStream) throws CoderException, IOException {
            Object baseType = this.logicalType.toBaseType(value);
            if (this.isDateTime) {
                baseType = ((ReadableInstant)baseType).toInstant();
            }
            this.baseTypeCoder.encode(baseType, outStream);
        }

        @Override
        public InputT decode(InputStream inStream) throws CoderException, IOException {
            BaseT baseType = this.baseTypeCoder.decode(inStream);
            return this.logicalType.toInputType(baseType);
        }

        @Override
        public List<? extends Coder<?>> getCoderArguments() {
            return Collections.emptyList();
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            this.baseTypeCoder.verifyDeterministic();
        }

        @Override
        public boolean consistentWithEquals() {
            return false;
        }

        @Override
        public Object structuralValue(InputT value) {
            if (this.baseTypeCoder.consistentWithEquals()) {
                return this.logicalType.toBaseType(value);
            }
            return this.baseTypeCoder.structuralValue(this.logicalType.toBaseType(value));
        }

        @Override
        public boolean isRegisterByteSizeObserverCheap(InputT value) {
            return this.baseTypeCoder.isRegisterByteSizeObserverCheap(this.logicalType.toBaseType(value));
        }

        @Override
        public void registerByteSizeObserver(InputT value, ElementByteSizeObserver observer) throws Exception {
            this.baseTypeCoder.registerByteSizeObserver(this.logicalType.toBaseType(value), observer);
        }
    }
}

