/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.io;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

@Internal
@Experimental(value=Experimental.Kind.SCHEMAS)
public final class Providers {
    private Providers() {
    }

    public static <T extends Identifyable> Map<String, T> loadProviders(Class<T> klass) {
        HashMap<String, Identifyable> providers = new HashMap<String, Identifyable>();
        for (Identifyable provider : ServiceLoader.load(klass)) {
            Preconditions.checkArgument(!providers.containsKey(provider.identifier()), "Duplicate providers exist with identifier `%s` for class %s.", (Object)provider.identifier(), klass);
            providers.put(provider.identifier(), provider);
        }
        return providers;
    }

    public static interface Identifyable {
        public String identifier();
    }
}

