/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.Select;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_Select_Flattened<T>
extends Select.Flattened<T> {
    private final SerializableFunction<List<String>, String> nameFn;
    private final Map<String, String> nameOverrides;
    private final @Nullable Schema outputSchema;

    private AutoValue_Select_Flattened(SerializableFunction<List<String>, String> nameFn, Map<String, String> nameOverrides, @Nullable Schema outputSchema) {
        this.nameFn = nameFn;
        this.nameOverrides = nameOverrides;
        this.outputSchema = outputSchema;
    }

    @Override
    SerializableFunction<List<String>, String> getNameFn() {
        return this.nameFn;
    }

    @Override
    Map<String, String> getNameOverrides() {
        return this.nameOverrides;
    }

    @Override
    @Nullable Schema getOutputSchema() {
        return this.outputSchema;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Select.Flattened) {
            Select.Flattened that = (Select.Flattened)o;
            return this.nameFn.equals(that.getNameFn()) && this.nameOverrides.equals(that.getNameOverrides()) && (this.outputSchema == null ? that.getOutputSchema() == null : this.outputSchema.equals(that.getOutputSchema()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.nameFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.nameOverrides.hashCode();
        h$ *= 1000003;
        return h$ ^= this.outputSchema == null ? 0 : this.outputSchema.hashCode();
    }

    @Override
    Select.Flattened.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends Select.Flattened.Builder<T> {
        private SerializableFunction<List<String>, String> nameFn;
        private Map<String, String> nameOverrides;
        private @Nullable Schema outputSchema;

        Builder() {
        }

        private Builder(Select.Flattened<T> source) {
            this.nameFn = source.getNameFn();
            this.nameOverrides = source.getNameOverrides();
            this.outputSchema = source.getOutputSchema();
        }

        @Override
        Select.Flattened.Builder<T> setNameFn(SerializableFunction<List<String>, String> nameFn) {
            if (nameFn == null) {
                throw new NullPointerException("Null nameFn");
            }
            this.nameFn = nameFn;
            return this;
        }

        @Override
        Select.Flattened.Builder<T> setNameOverrides(Map<String, String> nameOverrides) {
            if (nameOverrides == null) {
                throw new NullPointerException("Null nameOverrides");
            }
            this.nameOverrides = nameOverrides;
            return this;
        }

        @Override
        Select.Flattened.Builder<T> setOutputSchema(@Nullable Schema outputSchema) {
            this.outputSchema = outputSchema;
            return this;
        }

        @Override
        Select.Flattened<T> build() {
            String missing = "";
            if (this.nameFn == null) {
                missing = missing + " nameFn";
            }
            if (this.nameOverrides == null) {
                missing = missing + " nameOverrides";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Select_Flattened(this.nameFn, this.nameOverrides, this.outputSchema);
        }
    }
}

