/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.schemas.utils.ByteBuddyUtils;
import org.apache.beam.sdk.schemas.utils.ConvertHelpers;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class Convert {
    public static <InputT> PTransform<PCollection<InputT>, PCollection<Row>> toRows() {
        return Convert.to(Row.class);
    }

    public static <OutputT> PTransform<PCollection<Row>, PCollection<OutputT>> fromRows(Class<OutputT> clazz) {
        return Convert.to(clazz);
    }

    public static <OutputT> PTransform<PCollection<Row>, PCollection<OutputT>> fromRows(TypeDescriptor<OutputT> typeDescriptor) {
        return Convert.to(typeDescriptor);
    }

    public static <InputT, OutputT> PTransform<PCollection<InputT>, PCollection<OutputT>> to(Class<OutputT> clazz) {
        return Convert.to(TypeDescriptor.of(clazz));
    }

    public static <InputT, OutputT> PTransform<PCollection<InputT>, PCollection<OutputT>> to(TypeDescriptor<OutputT> typeDescriptor) {
        return new ConvertTransform(typeDescriptor);
    }

    private static class ConvertTransform<InputT, OutputT>
    extends PTransform<PCollection<InputT>, PCollection<OutputT>> {
        TypeDescriptor<OutputT> outputTypeDescriptor;

        ConvertTransform(TypeDescriptor<OutputT> outputTypeDescriptor) {
            this.outputTypeDescriptor = outputTypeDescriptor;
        }

        private static @Nullable Schema getBoxedNestedSchema(Schema schema) {
            if (schema.getFieldCount() != 1) {
                return null;
            }
            Schema.FieldType fieldType = schema.getField(0).getType();
            if (!fieldType.getTypeName().isCompositeType()) {
                return null;
            }
            return fieldType.getRowSchema();
        }

        @Override
        public PCollection<OutputT> expand(PCollection<InputT> input) {
            PCollection output;
            boolean unbox;
            if (!input.hasSchema()) {
                throw new RuntimeException("Convert requires a schema on the input.");
            }
            SchemaCoder coder = (SchemaCoder)input.getCoder();
            if (coder.getEncodedTypeDescriptor().equals(this.outputTypeDescriptor)) {
                return input;
            }
            SchemaRegistry registry = input.getPipeline().getSchemaRegistry();
            final ConvertHelpers.ConvertedSchemaInformation<OutputT> converted = ConvertHelpers.getConvertedSchemaInformation(input.getSchema(), this.outputTypeDescriptor, registry);
            boolean bl = unbox = converted.unboxedType != null;
            if (converted.outputSchemaCoder != null) {
                output = (PCollection)input.apply(ParDo.of(new DoFn<InputT, OutputT>(){

                    @DoFn.ProcessElement
                    public void processElement(@DoFn.Element Row row, DoFn.OutputReceiver<OutputT> o) {
                        Row input = unbox ? row.getValue(0) : row;
                        o.output(converted.outputSchemaCoder.getFromRowFunction().apply(input));
                    }
                }));
                output.setCoder(converted.outputSchemaCoder);
            } else {
                final SerializableFunction convertPrimitive = ConvertHelpers.getConvertPrimitive(converted.unboxedType, this.outputTypeDescriptor, new ByteBuddyUtils.DefaultTypeConversionsFactory());
                output = (PCollection)input.apply(ParDo.of(new DoFn<InputT, OutputT>(){

                    @DoFn.ProcessElement
                    public void processElement(@DoFn.Element Row row, DoFn.OutputReceiver<OutputT> o) {
                        o.output(convertPrimitive.apply(row.getValue(0)));
                    }
                }));
                output.setTypeDescriptor(this.outputTypeDescriptor);
            }
            return output;
        }
    }
}

