/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.utils.RowSelector;
import org.apache.beam.sdk.schemas.utils.SelectByteBuddyHelpers;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class SelectHelpers {
    public static final SerializableFunction<List<String>, String> CONCAT_FIELD_NAMES = l -> String.join((CharSequence)"_", l);
    public static final SerializableFunction<List<String>, String> KEEP_NESTED_NAME = l -> (String)l.get(l.size() - 1);

    private static Schema union(Iterable<Schema> schemas) {
        Schema.Builder unioned = Schema.builder();
        for (Schema schema : schemas) {
            unioned.addFields(schema.getFields());
        }
        return unioned.build();
    }

    public static Schema getOutputSchema(Schema inputSchema, FieldAccessDescriptor fieldAccessDescriptor) {
        return SelectHelpers.getOutputSchemaTrackingNullable(inputSchema, fieldAccessDescriptor, false);
    }

    private static Schema getOutputSchemaTrackingNullable(Schema inputSchema, FieldAccessDescriptor fieldAccessDescriptor, boolean isNullable) {
        if (fieldAccessDescriptor.getAllFields()) {
            Schema schemaToReturn = inputSchema;
            if (isNullable) {
                schemaToReturn = inputSchema.getFields().stream().map(f -> f.withNullable(true)).collect(Schema.toSchema());
            }
            return schemaToReturn;
        }
        ArrayList<Schema> schemas = Lists.newArrayList();
        Schema.Builder builder = Schema.builder();
        for (FieldAccessDescriptor.FieldDescriptor fieldDescriptor : fieldAccessDescriptor.getFieldsAccessed()) {
            Schema.Field field = inputSchema.getField(fieldDescriptor.getFieldId());
            if (fieldDescriptor.getFieldRename() != null) {
                field = field.withName(fieldDescriptor.getFieldRename());
            }
            if (isNullable) {
                field = field.withNullable(true);
            }
            builder.addField(field);
        }
        schemas.add(builder.build());
        for (Map.Entry entry : fieldAccessDescriptor.getNestedFieldsAccessed().entrySet()) {
            FieldAccessDescriptor.FieldDescriptor fieldDescriptor = (FieldAccessDescriptor.FieldDescriptor)entry.getKey();
            FieldAccessDescriptor nestedAccess = (FieldAccessDescriptor)entry.getValue();
            Schema.Field field = inputSchema.getField(Preconditions.checkNotNull(fieldDescriptor.getFieldId()));
            if (fieldDescriptor.getFieldRename() != null) {
                field = field.withName(fieldDescriptor.getFieldRename());
            }
            Schema outputSchema = SelectHelpers.getOutputSchemaHelper(field.getType(), nestedAccess, fieldDescriptor.getQualifiers(), 0, isNullable || field.getType().getNullable() != false);
            schemas.add(outputSchema);
        }
        return SelectHelpers.union(schemas);
    }

    private static Schema getOutputSchemaHelper(Schema.FieldType inputFieldType, FieldAccessDescriptor fieldAccessDescriptor, List<FieldAccessDescriptor.FieldDescriptor.Qualifier> qualifiers, int qualifierPosition, boolean isNullable) {
        if (qualifierPosition >= qualifiers.size()) {
            Preconditions.checkArgument(inputFieldType.getTypeName().isCompositeType());
            return SelectHelpers.getOutputSchemaTrackingNullable(inputFieldType.getRowSchema(), fieldAccessDescriptor, isNullable);
        }
        FieldAccessDescriptor.FieldDescriptor.Qualifier qualifier = qualifiers.get(qualifierPosition);
        Schema.Builder builder = Schema.builder();
        switch (qualifier.getKind()) {
            case LIST: {
                Preconditions.checkArgument(qualifier.getList().equals((Object)FieldAccessDescriptor.FieldDescriptor.ListQualifier.ALL));
                Schema.FieldType componentType = Preconditions.checkNotNull(inputFieldType.getCollectionElementType());
                Schema outputComponent = SelectHelpers.getOutputSchemaHelper(componentType, fieldAccessDescriptor, qualifiers, qualifierPosition + 1, false);
                for (Schema.Field field : outputComponent.getFields()) {
                    Schema.Field newField;
                    if (Schema.TypeName.ARRAY.equals((Object)inputFieldType.getTypeName())) {
                        newField = Schema.Field.of(field.getName(), Schema.FieldType.array(field.getType()));
                    } else {
                        Preconditions.checkArgument(Schema.TypeName.ITERABLE.equals((Object)inputFieldType.getTypeName()));
                        newField = Schema.Field.of(field.getName(), Schema.FieldType.iterable(field.getType()));
                    }
                    builder.addField(newField.withNullable(isNullable));
                }
                return builder.build();
            }
            case MAP: {
                Preconditions.checkArgument(qualifier.getMap().equals((Object)FieldAccessDescriptor.FieldDescriptor.MapQualifier.ALL));
                Schema.FieldType keyType = Preconditions.checkNotNull(inputFieldType.getMapKeyType());
                Schema.FieldType valueType = Preconditions.checkNotNull(inputFieldType.getMapValueType());
                Schema outputValueSchema = SelectHelpers.getOutputSchemaHelper(valueType, fieldAccessDescriptor, qualifiers, qualifierPosition + 1, false);
                for (Schema.Field field : outputValueSchema.getFields()) {
                    Schema.Field newField = Schema.Field.of(field.getName(), Schema.FieldType.map(keyType, field.getType()));
                    builder.addField(newField.withNullable(isNullable));
                }
                return builder.build();
            }
        }
        throw new RuntimeException("unexpected");
    }

    public static RowSelector getRowSelectorOptimized(Schema inputSchema, FieldAccessDescriptor fieldAccessDescriptor) {
        return SelectByteBuddyHelpers.getRowSelector(inputSchema, fieldAccessDescriptor);
    }

    public static RowSelector getRowSelector(Schema inputSchema, FieldAccessDescriptor fieldAccessDescriptor) {
        Schema outputSchema = SelectHelpers.getOutputSchema(inputSchema, fieldAccessDescriptor);
        return input -> SelectHelpers.selectRow(input, fieldAccessDescriptor, inputSchema, outputSchema);
    }

    private static Row selectRow(Row input, FieldAccessDescriptor fieldAccessDescriptor, Schema inputSchema, Schema outputSchema) {
        if (fieldAccessDescriptor.getAllFields()) {
            return input;
        }
        Row.Builder output = Row.withSchema(outputSchema);
        SelectHelpers.selectIntoRow(inputSchema, input, output, fieldAccessDescriptor);
        return output.build();
    }

    private static void selectIntoRow(Schema inputSchema, Row input, Row.Builder output, FieldAccessDescriptor fieldAccessDescriptor) {
        if (fieldAccessDescriptor.getAllFields()) {
            List<Object> values = input != null ? input.getValues() : Collections.nCopies(inputSchema.getFieldCount(), null);
            output.addValues(values);
            return;
        }
        for (int fieldId : fieldAccessDescriptor.fieldIdsAccessed()) {
            output.addValue(input != null ? input.getValue(fieldId) : null);
        }
        Schema outputSchema = output.getSchema();
        for (Map.Entry<FieldAccessDescriptor.FieldDescriptor, FieldAccessDescriptor> nested : fieldAccessDescriptor.getNestedFieldsAccessed().entrySet()) {
            FieldAccessDescriptor.FieldDescriptor field = nested.getKey();
            FieldAccessDescriptor nestedAccess = nested.getValue();
            Schema.FieldType nestedInputType = inputSchema.getField(field.getFieldId()).getType();
            Schema.FieldType nestedOutputType = outputSchema.getField(output.nextFieldId()).getType();
            SelectHelpers.selectIntoRowWithQualifiers(field.getQualifiers(), 0, input.getValue(field.getFieldId()), output, nestedAccess, nestedInputType, nestedOutputType);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void selectIntoRowWithQualifiers(List<FieldAccessDescriptor.FieldDescriptor.Qualifier> qualifiers, int qualifierPosition, Object value, Row.Builder output, FieldAccessDescriptor fieldAccessDescriptor, Schema.FieldType inputType, Schema.FieldType outputType) {
        if (qualifierPosition >= qualifiers.size()) {
            Row row = (Row)value;
            SelectHelpers.selectIntoRow(inputType.getRowSchema(), row, output, fieldAccessDescriptor);
            return;
        }
        FieldAccessDescriptor.FieldDescriptor.Qualifier qualifier = qualifiers.get(qualifierPosition);
        switch (qualifier.getKind()) {
            case LIST: {
                void var15_26;
                Schema.FieldType nestedInputType = Preconditions.checkNotNull(inputType.getCollectionElementType());
                Schema.FieldType nestedOutputType = Preconditions.checkNotNull(outputType.getCollectionElementType());
                Iterable iterable = (Iterable)value;
                Schema tempSchema = Schema.builder().addField("a", nestedInputType).build();
                FieldAccessDescriptor tempAccessDescriptor = FieldAccessDescriptor.create().withNestedField("a", fieldAccessDescriptor).resolve(tempSchema);
                Schema nestedSchema = SelectHelpers.getOutputSchema(tempSchema, tempAccessDescriptor);
                ArrayList selectedLists = Lists.newArrayListWithCapacity(nestedSchema.getFieldCount());
                boolean bl = false;
                while (var15_26 < nestedSchema.getFieldCount()) {
                    if (iterable == null) {
                        selectedLists.add(null);
                    } else {
                        selectedLists.add(Lists.newArrayListWithCapacity(Iterables.size(iterable)));
                    }
                    ++var15_26;
                }
                if (iterable != null) {
                    for (Object t : iterable) {
                        Row.Builder selectElementBuilder = Row.withSchema(nestedSchema);
                        SelectHelpers.selectIntoRowWithQualifiers(qualifiers, qualifierPosition + 1, t, selectElementBuilder, fieldAccessDescriptor, nestedInputType, nestedOutputType);
                        Row elementBeforeDistribution = selectElementBuilder.build();
                        for (int i = 0; i < nestedSchema.getFieldCount(); ++i) {
                            ((List)selectedLists.get(i)).add(elementBeforeDistribution.getValue(i));
                        }
                    }
                }
                for (List list : selectedLists) {
                    output.addValue(list);
                }
                break;
            }
            case MAP: {
                Schema.FieldType nestedInputType = Preconditions.checkNotNull(inputType.getMapValueType());
                Schema.FieldType nestedOutputType = Preconditions.checkNotNull(outputType.getMapValueType());
                Schema tempSchema = Schema.builder().addField("a", nestedInputType).build();
                FieldAccessDescriptor tempAccessDescriptor = FieldAccessDescriptor.create().withNestedField("a", fieldAccessDescriptor).resolve(tempSchema);
                Schema nestedSchema = SelectHelpers.getOutputSchema(tempSchema, tempAccessDescriptor);
                ArrayList selectedMaps = Lists.newArrayListWithExpectedSize(nestedSchema.getFieldCount());
                for (int i = 0; i < nestedSchema.getFieldCount(); ++i) {
                    if (value == null) {
                        selectedMaps.add(null);
                        continue;
                    }
                    selectedMaps.add(Maps.newHashMap());
                }
                if (value != null) {
                    Map map = (Map)value;
                    for (Map.Entry entry : map.entrySet()) {
                        Row.Builder selectValueBuilder = Row.withSchema(nestedSchema);
                        SelectHelpers.selectIntoRowWithQualifiers(qualifiers, qualifierPosition + 1, entry.getValue(), selectValueBuilder, fieldAccessDescriptor, nestedInputType, nestedOutputType);
                        Row valueBeforeDistribution = selectValueBuilder.build();
                        for (int i = 0; i < nestedSchema.getFieldCount(); ++i) {
                            ((Map)selectedMaps.get(i)).put(entry.getKey(), valueBeforeDistribution.getValue(i));
                        }
                    }
                }
                for (Map map : selectedMaps) {
                    output.addValue(map);
                }
                break;
            }
            default: {
                throw new RuntimeException("Unexpected type " + (Object)((Object)qualifier.getKind()));
            }
        }
    }

    public static FieldAccessDescriptor allLeavesDescriptor(Schema schema, SerializableFunction<List<String>, String> nameFn) {
        ArrayList<String> nameComponents = Lists.newArrayList();
        LinkedHashMap<String, String> fieldsSelected = Maps.newLinkedHashMap();
        SelectHelpers.allLeafFields(schema, nameComponents, nameFn, fieldsSelected);
        return FieldAccessDescriptor.withFieldNamesAs(fieldsSelected).resolve(schema);
    }

    private static void allLeafFields(Schema schema, List<String> nameComponents, SerializableFunction<List<String>, String> nameFn, Map<String, String> fieldsSelected) {
        for (Schema.Field field : schema.getFields()) {
            nameComponents.add(field.getName());
            Schema.FieldType fieldType = field.getType();
            Schema.FieldType collectionElementType = fieldType.getCollectionElementType();
            if (fieldType.getTypeName().isCompositeType()) {
                SelectHelpers.allLeafFields(fieldType.getRowSchema(), nameComponents, nameFn, fieldsSelected);
            } else if (collectionElementType != null && collectionElementType.getTypeName().isCompositeType()) {
                SelectHelpers.allLeafFields(collectionElementType.getRowSchema(), nameComponents, nameFn, fieldsSelected);
            } else {
                String newName = nameFn.apply(nameComponents);
                fieldsSelected.put(String.join((CharSequence)".", nameComponents), newName);
            }
            nameComponents.remove(nameComponents.size() - 1);
        }
    }

    public static class RowSelectorContainer
    implements RowSelector,
    Serializable {
        private transient RowSelector rowSelector;
        private final Schema inputSchema;
        private final FieldAccessDescriptor fieldAccessDescriptor;
        private final boolean optimized;

        public RowSelectorContainer(Schema inputSchema, FieldAccessDescriptor fieldAccessDescriptor, boolean optimized) {
            this.inputSchema = inputSchema;
            this.fieldAccessDescriptor = fieldAccessDescriptor;
            this.optimized = optimized;
        }

        @Override
        public Row select(Row input) {
            if (this.rowSelector == null) {
                this.rowSelector = this.optimized ? SelectHelpers.getRowSelectorOptimized(this.inputSchema, this.fieldAccessDescriptor) : SelectHelpers.getRowSelector(this.inputSchema, this.fieldAccessDescriptor);
            }
            return this.rowSelector.select(input);
        }
    }
}

