/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.UnownedInputStream;
import org.apache.beam.sdk.util.UnownedOutputStream;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.CountingInputStream;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.CountingOutputStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class CoderProperties {
    public static final List<Coder.Context> ALL_CONTEXTS = ImmutableList.of(Coder.Context.OUTER, Coder.Context.NESTED);
    private static final String DECODING_WIRE_FORMAT_MESSAGE = "Decoded value from known wire format does not match expected value. This probably means that this Coder no longer correctly decodes a prior wire format. Changing the wire formats this Coder can read should be avoided, as it is likely to cause breakage.";
    private static final String ENCODING_WIRE_FORMAT_MESSAGE = "Encoded value does not match expected wire format. Changing the wire format should be avoided, as it is likely to cause breakage. If you truly intend to change the wire format for this Coder, See org.apache.beam.sdk.coders.PrintBase64Encoding for how to generate new test data.";

    public static <T> void coderDeterministic(Coder<T> coder, T value1, T value2) throws Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.coderDeterministicInContext(coder, context, value1, value2);
        }
    }

    public static <T> void coderDeterministicInContext(Coder<T> coder, Coder.Context context, T value1, T value2) throws Exception {
        try {
            coder.verifyDeterministic();
        }
        catch (Coder.NonDeterministicException e) {
            throw new AssertionError("Expected that the coder is deterministic", e);
        }
        MatcherAssert.assertThat((String)"Expected that the passed in values are equal()", value1, (Matcher)Matchers.equalTo(value2));
        MatcherAssert.assertThat((Object)CoderProperties.encode(coder, context, value1), (Matcher)Matchers.equalTo((Object)CoderProperties.encode(coder, context, value2)));
    }

    public static <T> void coderDecodeEncodeEqual(Coder<T> coder, T value) throws Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.coderDecodeEncodeEqualInContext(coder, context, value);
        }
    }

    public static <T> void coderDecodeEncodeEqualInContext(Coder<T> coder, Coder.Context context, T value) throws Exception {
        MatcherAssert.assertThat(CoderProperties.decodeEncode(coder, context, value), (Matcher)Matchers.equalTo(value));
    }

    public static <T> void coderDecodeEncodeInContext(Coder<T> coder, Coder.Context context, T value, Matcher<T> matcher) throws Exception {
        MatcherAssert.assertThat(CoderProperties.decodeEncode(coder, context, value), matcher);
    }

    public static <T, CollectionT extends Collection<T>> void coderDecodeEncodeContentsEqual(Coder<CollectionT> coder, CollectionT value) throws Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.coderDecodeEncodeContentsEqualInContext(coder, context, value);
        }
    }

    public static <T, CollectionT extends Collection<T>> void coderDecodeEncodeContentsEqualInContext(Coder<CollectionT> coder, Coder.Context context, CollectionT value) throws Exception {
        Collection result = (Collection)CoderProperties.decodeEncode(coder, context, value);
        if (value.isEmpty()) {
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.emptyIterable());
        } else {
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsInAnyOrder((Object[])value.toArray()));
        }
    }

    public static <T, IterableT extends Iterable<T>> void coderDecodeEncodeContentsInSameOrder(Coder<IterableT> coder, IterableT value) throws Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.coderDecodeEncodeContentsInSameOrderInContext(coder, context, value);
        }
    }

    public static <T, IterableT extends Iterable<T>> void coderDecodeEncodeContentsInSameOrderInContext(Coder<IterableT> coder, Coder.Context context, IterableT value) throws Exception {
        Iterable result = (Iterable)CoderProperties.decodeEncode(coder, context, value);
        if (Iterables.isEmpty(value)) {
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.emptyIterable());
        } else {
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.contains((Object[])Iterables.toArray(value, Object.class)));
        }
    }

    public static <T> void coderSerializable(Coder<T> coder) {
        SerializableUtils.ensureSerializable(coder);
    }

    public static <T> void coderConsistentWithEquals(Coder<T> coder, T value1, T value2) throws Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.coderConsistentWithEqualsInContext(coder, context, value1, value2);
        }
    }

    public static <T> void coderConsistentWithEqualsInContext(Coder<T> coder, Coder.Context context, T value1, T value2) throws Exception {
        Assert.assertEquals((Object)value1.equals(value2), (Object)Arrays.equals(CoderProperties.encode(coder, context, value1), CoderProperties.encode(coder, context, value2)));
    }

    public static <T> void structuralValueConsistentWithEquals(Coder<T> coder, T value1, T value2) throws Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.structuralValueConsistentWithEqualsInContext(coder, context, value1, value2);
        }
    }

    public static <T> void structuralValueConsistentWithEqualsInContext(Coder<T> coder, Coder.Context context, T value1, T value2) throws Exception {
        Assert.assertEquals((Object)coder.structuralValue(value1).equals(coder.structuralValue(value2)), (Object)Arrays.equals(CoderProperties.encode(coder, context, value1), CoderProperties.encode(coder, context, value2)));
    }

    public static <T> void structuralValueDecodeEncodeEqual(Coder<T> coder, T value) throws Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.structuralValueDecodeEncodeEqualInContext(coder, context, value);
        }
    }

    public static <T extends Iterable<?>> void structuralValueDecodeEncodeEqualIterable(Coder<T> coder, T value) throws Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.structuralValueDecodeEncodeEqualIterableInContext(coder, context, value);
        }
    }

    public static <T> void structuralValueDecodeEncodeEqualInContext(Coder<T> coder, Coder.Context context, T value) throws Exception {
        Assert.assertEquals((Object)coder.structuralValue(value), (Object)coder.structuralValue(CoderProperties.decodeEncode(coder, context, value)));
    }

    public static <T extends Iterable<?>> void structuralValueDecodeEncodeEqualIterableInContext(Coder<T> coder, Coder.Context context, T value) throws Exception {
        MatcherAssert.assertThat((String)"The original value changed after, encoding and decoding.", (boolean)Iterables.elementsEqual((Iterable)coder.structuralValue(value), (Iterable)coder.structuralValue((Iterable)CoderProperties.decodeEncode(coder, context, value))));
    }

    public static <T> void coderDecodesBase64(Coder<T> coder, String base64Encoding, T value) throws Exception {
        MatcherAssert.assertThat((String)DECODING_WIRE_FORMAT_MESSAGE, CoderUtils.decodeFromBase64(coder, base64Encoding), (Matcher)Matchers.equalTo(value));
    }

    public static <T> void coderDecodesBase64(Coder<T> coder, List<String> base64Encodings, List<T> values) throws Exception {
        MatcherAssert.assertThat((String)"List of base64 encodings has different size than List of values", (Object)base64Encodings.size(), (Matcher)Matchers.equalTo((Object)values.size()));
        for (int i = 0; i < base64Encodings.size(); ++i) {
            CoderProperties.coderDecodesBase64(coder, base64Encodings.get(i), values.get(i));
        }
    }

    public static <T> void coderEncodesBase64(Coder<T> coder, T value, String base64Encoding) throws Exception {
        MatcherAssert.assertThat((String)ENCODING_WIRE_FORMAT_MESSAGE, (Object)CoderUtils.encodeToBase64(coder, value), (Matcher)Matchers.equalTo((Object)base64Encoding));
    }

    public static <T> void coderEncodesBase64(Coder<T> coder, List<T> values, List<String> base64Encodings) throws Exception {
        MatcherAssert.assertThat((String)"List of base64 encodings has different size than List of values", (Object)base64Encodings.size(), (Matcher)Matchers.equalTo((Object)values.size()));
        for (int i = 0; i < base64Encodings.size(); ++i) {
            CoderProperties.coderEncodesBase64(coder, values.get(i), base64Encodings.get(i));
        }
    }

    public static <T, IterableT extends Iterable<T>> void coderDecodesBase64ContentsEqual(Coder<IterableT> coder, String base64Encoding, IterableT expected) throws Exception {
        Iterable result = (Iterable)CoderUtils.decodeFromBase64(coder, base64Encoding);
        if (Iterables.isEmpty(expected)) {
            MatcherAssert.assertThat((String)ENCODING_WIRE_FORMAT_MESSAGE, (Object)result, (Matcher)Matchers.emptyIterable());
        } else {
            MatcherAssert.assertThat((String)ENCODING_WIRE_FORMAT_MESSAGE, (Object)result, (Matcher)Matchers.containsInAnyOrder((Object[])Iterables.toArray(expected, Object.class)));
        }
    }

    public static <T, IterableT extends Iterable<T>> void coderDecodesBase64ContentsEqual(Coder<IterableT> coder, List<String> base64Encodings, List<IterableT> expected) throws Exception {
        MatcherAssert.assertThat((String)"List of base64 encodings has different size than List of values", (Object)base64Encodings.size(), (Matcher)Matchers.equalTo((Object)expected.size()));
        for (int i = 0; i < base64Encodings.size(); ++i) {
            CoderProperties.coderDecodesBase64ContentsEqual(coder, base64Encodings.get(i), (Iterable)expected.get(i));
        }
    }

    @VisibleForTesting
    static <T> byte[] encode(Coder<T> coder, Coder.Context context, T value) throws CoderException, IOException {
        Coder<T> deserializedCoder = SerializableUtils.clone(coder);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        deserializedCoder.encode(value, new UnownedOutputStream(os), context);
        return os.toByteArray();
    }

    @VisibleForTesting
    static <T> T decode(Coder<T> coder, Coder.Context context, byte[] bytes) throws CoderException, IOException {
        byte[] buffer;
        Coder<T> deserializedCoder = SerializableUtils.clone(coder);
        if (Objects.equals(context, Coder.Context.NESTED)) {
            buffer = new byte[bytes.length + 1];
            System.arraycopy(bytes, 0, buffer, 0, bytes.length);
            buffer[bytes.length] = 1;
        } else {
            buffer = bytes;
        }
        CountingInputStream cis = new CountingInputStream(new ByteArrayInputStream(buffer));
        T value = deserializedCoder.decode(new UnownedInputStream(cis), context);
        MatcherAssert.assertThat((String)"consumed bytes equal to encoded bytes", (Object)cis.getCount(), (Matcher)Matchers.equalTo((Object)bytes.length));
        return value;
    }

    private static <T> T decodeEncode(Coder<T> coder, Coder.Context context, T value) throws CoderException, IOException {
        return CoderProperties.decode(coder, context, CoderProperties.encode(coder, context, value));
    }

    public static <T> void testByteCount(Coder<T> coder, Coder.Context context, T[] elements) throws Exception {
        TestElementByteSizeObserver observer = new TestElementByteSizeObserver();
        try (CountingOutputStream os = new CountingOutputStream(ByteStreams.nullOutputStream());){
            for (T elem : elements) {
                coder.registerByteSizeObserver(elem, observer);
                coder.encode(elem, os, context);
                observer.advance();
            }
            long expectedLength = os.getCount();
            if (!context.isWholeStream) {
                Assert.assertEquals((long)expectedLength, (long)observer.getSum());
            }
            Assert.assertEquals((long)elements.length, (long)observer.getCount());
        }
    }

    public static class TestElementByteSizeObserver
    extends ElementByteSizeObserver {
        private long currentSum = 0L;
        private long count = 0L;

        @Override
        protected void reportElementSize(long elementByteSize) {
            ++this.count;
            this.currentSum += elementByteSize;
        }

        public double getMean() {
            return (double)this.currentSum / (double)this.count;
        }

        public long getSum() {
            return this.currentSum;
        }

        public long getCount() {
            return this.count;
        }

        public void reset() {
            this.currentSum = 0L;
            this.count = 0L;
        }

        public long getSumAndReset() {
            long returnValue = this.currentSum;
            this.reset();
            return returnValue;
        }
    }
}

