/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.beam.sdk.testing.SerializableMatcher;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.ShardedFile;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.HashCode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChecksumMatcher
extends TypeSafeMatcher<ShardedFile>
implements SerializableMatcher<ShardedFile> {
    private static final Logger LOG = LoggerFactory.getLogger(FileChecksumMatcher.class);
    static final int MAX_READ_RETRIES = 4;
    static final Duration DEFAULT_SLEEP_DURATION = Duration.standardSeconds(10L);
    static final FluentBackoff BACK_OFF_FACTORY = FluentBackoff.DEFAULT.withInitialBackoff(DEFAULT_SLEEP_DURATION).withMaxRetries(4);
    private final String expectedChecksum;
    private String actualChecksum;

    private FileChecksumMatcher(String checksum) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(checksum), "Expected valid checksum, but received %s", (Object)checksum);
        this.expectedChecksum = checksum;
    }

    public static FileChecksumMatcher fileContentsHaveChecksum(String checksum) {
        return new FileChecksumMatcher(checksum);
    }

    public boolean matchesSafely(ShardedFile shardedFile) {
        return this.getActualChecksum(shardedFile).equals(this.expectedChecksum);
    }

    private String getActualChecksum(ShardedFile shardedFile) {
        List<String> outputs;
        try {
            outputs = shardedFile.readFilesWithRetries(Sleeper.DEFAULT, BACK_OFF_FACTORY.backoff());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to read from: %s", shardedFile), e);
        }
        this.actualChecksum = FileChecksumMatcher.computeHash(outputs);
        LOG.debug("Generated checksum: {}", (Object)this.actualChecksum);
        return this.actualChecksum;
    }

    private static String computeHash(@Nonnull List<String> strs) {
        if (strs.isEmpty()) {
            return Hashing.sha1().hashString("", StandardCharsets.UTF_8).toString();
        }
        ArrayList<HashCode> hashCodes = new ArrayList<HashCode>();
        for (String str : strs) {
            hashCodes.add(Hashing.sha1().hashString(str, StandardCharsets.UTF_8));
        }
        return Hashing.combineUnordered(hashCodes).toString();
    }

    public void describeTo(Description description) {
        description.appendText("Expected checksum is (").appendText(this.expectedChecksum).appendText(")");
    }

    public void describeMismatchSafely(ShardedFile shardedFile, Description description) {
        description.appendText("was (").appendText(this.actualChecksum).appendText(")");
    }
}

