/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.testing.GatherAllPanes;
import org.apache.beam.sdk.testing.PaneExtractors;
import org.apache.beam.sdk.testing.SerializableMatcher;
import org.apache.beam.sdk.testing.SerializableMatchers;
import org.apache.beam.sdk.testing.StaticWindows;
import org.apache.beam.sdk.testing.SuccessOrFailure;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reify;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Never;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Objects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class PAssert {
    public static final String SUCCESS_COUNTER = "PAssertSuccess";
    public static final String FAILURE_COUNTER = "PAssertFailure";
    private static final Counter successCounter = Metrics.counter(PAssert.class, "PAssertSuccess");
    private static final Counter failureCounter = Metrics.counter(PAssert.class, "PAssertFailure");
    private static int assertCount = 0;

    private static String nextAssertionName() {
        return "PAssert$" + assertCount++;
    }

    private PAssert() {
    }

    public static <T> IterableAssert<T> that(PCollection<T> actual) {
        return PAssert.that(actual.getName(), actual);
    }

    public static <T> IterableAssert<T> that(String reason, PCollection<T> actual) {
        return new PCollectionContentsAssert<T>(actual, PAssertionSite.capture(reason));
    }

    public static <T> IterableAssert<T> thatSingletonIterable(PCollection<? extends Iterable<T>> actual) {
        return PAssert.thatSingletonIterable(actual.getName(), actual);
    }

    public static <T> IterableAssert<T> thatSingletonIterable(String reason, PCollection<? extends Iterable<T>> actual) {
        PCollection actualIterables = actual;
        return new PCollectionSingletonIterableAssert(actualIterables, PAssertionSite.capture(reason));
    }

    public static <T> SingletonAssert<T> thatSingleton(PCollection<T> actual) {
        return PAssert.thatSingleton(actual.getName(), actual);
    }

    public static <T> SingletonAssert<T> thatSingleton(String reason, PCollection<T> actual) {
        return new PCollectionSingletonAssert<T>(actual, PAssertionSite.capture(reason));
    }

    public static <K, V> SingletonAssert<Map<K, Iterable<V>>> thatMultimap(PCollection<KV<K, V>> actual) {
        return PAssert.thatMultimap(actual.getName(), actual);
    }

    public static <K, V> SingletonAssert<Map<K, Iterable<V>>> thatMultimap(String reason, PCollection<KV<K, V>> actual) {
        KvCoder kvCoder = (KvCoder)actual.getCoder();
        return new PCollectionViewAssert(actual, View.asMultimap(), MapCoder.of(kvCoder.getKeyCoder(), IterableCoder.of(kvCoder.getValueCoder())), PAssertionSite.capture(reason));
    }

    public static <K, V> SingletonAssert<Map<K, V>> thatMap(PCollection<KV<K, V>> actual) {
        return PAssert.thatMap(actual.getName(), actual);
    }

    public static <K, V> SingletonAssert<Map<K, V>> thatMap(String reason, PCollection<KV<K, V>> actual) {
        KvCoder kvCoder = (KvCoder)actual.getCoder();
        return new PCollectionViewAssert(actual, View.asMap(), MapCoder.of(kvCoder.getKeyCoder(), kvCoder.getValueCoder()), PAssertionSite.capture(reason));
    }

    public static <T> PCollectionListContentsAssert<T> thatList(PCollectionList<T> actual) {
        return new PCollectionListContentsAssert<T>(actual);
    }

    public static <T> IterableAssert<T> thatFlattened(PCollectionList<T> actual) {
        PCollection flatten = (PCollection)actual.apply(Flatten.pCollections());
        return PAssert.that(flatten.getName(), flatten);
    }

    public static <T> IterableAssert<T> thatFlattened(String reason, PCollectionList<T> actual) {
        return new PCollectionContentsAssert((PCollection)actual.apply(Flatten.pCollections()), PAssertionSite.capture(reason));
    }

    protected static <ActualT> SuccessOrFailure doChecks(PAssertionSite site, ActualT actualContents, SerializableFunction<ActualT, Void> checkerFn) {
        try {
            checkerFn.apply(actualContents);
            return SuccessOrFailure.success();
        }
        catch (Throwable t) {
            return SuccessOrFailure.failure(site, t);
        }
    }

    public static int countAsserts(Pipeline pipeline) {
        AssertionCountingVisitor visitor = new AssertionCountingVisitor();
        pipeline.traverseTopologically(visitor);
        return visitor.getPAssertCount();
    }

    private static class AssertionCountingVisitor
    extends Pipeline.PipelineVisitor.Defaults {
        private int assertCount = 0;
        private boolean pipelineVisited = false;

        private AssertionCountingVisitor() {
        }

        @Override
        public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
            if (node.isRootNode()) {
                Preconditions.checkState(!this.pipelineVisited, "Tried to visit a pipeline with an already used %s", (Object)AssertionCountingVisitor.class.getSimpleName());
            }
            if (!node.isRootNode() && (node.getTransform() instanceof OneSideInputAssert || node.getTransform() instanceof GroupThenAssert || node.getTransform() instanceof GroupThenAssertForSingleton)) {
                ++this.assertCount;
            }
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }

        @Override
        public void leaveCompositeTransform(TransformHierarchy.Node node) {
            if (node.isRootNode()) {
                this.pipelineVisited = true;
            }
        }

        @Override
        public void visitPrimitiveTransform(TransformHierarchy.Node node) {
            if (node.getTransform() instanceof OneSideInputAssert || node.getTransform() instanceof GroupThenAssert || node.getTransform() instanceof GroupThenAssertForSingleton) {
                ++this.assertCount;
            }
        }

        int getPAssertCount() {
            Preconditions.checkState(this.pipelineVisited);
            return this.assertCount;
        }
    }

    private static final class FilterWindows<T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private final StaticWindows windows;

        public FilterWindows(StaticWindows windows) {
            this.windows = windows;
        }

        @Override
        public PCollection<T> expand(PCollection<T> input) {
            return (PCollection)input.apply("FilterWindows", ParDo.of(new Fn()));
        }

        private class Fn
        extends DoFn<T, T> {
            private Fn() {
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c, BoundedWindow window) throws Exception {
                if (FilterWindows.this.windows.getWindows().contains(window)) {
                    c.output(c.element());
                }
            }
        }
    }

    private static class IntoStaticWindows
    implements AssertionWindows {
        private final StaticWindows windowFn;

        public static AssertionWindows of(Coder<BoundedWindow> windowCoder, BoundedWindow window) {
            return new IntoStaticWindows(StaticWindows.of(windowCoder, window));
        }

        private IntoStaticWindows(StaticWindows windowFn) {
            this.windowFn = windowFn;
        }

        @Override
        public <T> PTransform<PCollection<T>, PCollection<T>> windowDummy() {
            return Window.into(this.windowFn);
        }

        @Override
        public <T> PTransform<PCollection<T>, PCollection<T>> prepareActuals() {
            return new FilterWindows(this.windowFn);
        }

        @Override
        public <T> PTransform<PCollection<T>, PCollection<T>> windowActuals() {
            return Window.into(this.windowFn.intoOnlyExisting());
        }
    }

    private static class IntoGlobalWindow
    implements AssertionWindows,
    Serializable {
        private IntoGlobalWindow() {
        }

        public static AssertionWindows of() {
            return new IntoGlobalWindow();
        }

        private <T> PTransform<PCollection<T>, PCollection<T>> window() {
            return Window.into(new GlobalWindows());
        }

        @Override
        public <T> PTransform<PCollection<T>, PCollection<T>> windowDummy() {
            return this.window();
        }

        @Override
        public <T> PTransform<PCollection<T>, PCollection<T>> prepareActuals() {
            return this.window();
        }

        @Override
        public <T> PTransform<PCollection<T>, PCollection<T>> windowActuals() {
            return this.window();
        }
    }

    private static interface AssertionWindows {
        public <T> PTransform<PCollection<T>, PCollection<T>> windowDummy();

        public <T> PTransform<PCollection<T>, PCollection<T>> prepareActuals();

        public <T> PTransform<PCollection<T>, PCollection<T>> windowActuals();
    }

    private static class AssertContainsInAnyOrderRelation<T>
    implements AssertRelation<Iterable<T>, Iterable<T>> {
        private AssertContainsInAnyOrderRelation() {
        }

        @Override
        public SerializableFunction<Iterable<T>, Void> assertFor(Iterable<T> expectedElements) {
            return new AssertContainsInAnyOrder<T>(expectedElements);
        }
    }

    private static class AssertNotEqualToRelation<T>
    implements AssertRelation<T, T> {
        private AssertNotEqualToRelation() {
        }

        @Override
        public SerializableFunction<T, Void> assertFor(T expected) {
            return new AssertNotEqualTo<T>(expected);
        }
    }

    private static class AssertIsEqualToRelation<T>
    implements AssertRelation<T, T> {
        private AssertIsEqualToRelation() {
        }

        @Override
        public SerializableFunction<T, Void> assertFor(T expected) {
            return new AssertIsEqualTo<T>(expected);
        }
    }

    private static interface AssertRelation<ActualT, ExpectedT>
    extends Serializable {
        public SerializableFunction<ActualT, Void> assertFor(ExpectedT var1);
    }

    private static class AssertContainsInAnyOrder<T>
    implements SerializableFunction<Iterable<T>, Void> {
        private T[] expected;

        @SafeVarargs
        public AssertContainsInAnyOrder(T ... expected) {
            this.expected = expected;
        }

        public AssertContainsInAnyOrder(Collection<T> expected) {
            this(expected.toArray());
        }

        public AssertContainsInAnyOrder(Iterable<T> expected) {
            this((Collection<T>)Lists.newArrayList(expected));
        }

        @Override
        public @Nullable Void apply(Iterable<T> actual) {
            MatcherAssert.assertThat(actual, (Matcher)Matchers.containsInAnyOrder((Object[])this.expected));
            return null;
        }
    }

    private static class AssertNotEqualTo<T>
    implements SerializableFunction<T, Void> {
        private T expected;

        public AssertNotEqualTo(T expected) {
            this.expected = expected;
        }

        @Override
        public @Nullable Void apply(T actual) {
            MatcherAssert.assertThat(actual, (Matcher)Matchers.not((Matcher)Matchers.equalTo(this.expected)));
            return null;
        }
    }

    private static class AssertIsEqualTo<T>
    implements SerializableFunction<T, Void> {
        private T expected;

        public AssertIsEqualTo(T expected) {
            this.expected = expected;
        }

        @Override
        public @Nullable Void apply(T actual) {
            MatcherAssert.assertThat(actual, (Matcher)Matchers.equalTo(this.expected));
            return null;
        }
    }

    private static class SingletonCheckerDoFn<ActualT>
    extends DoFn<Iterable<ActualT>, SuccessOrFailure> {
        private final SerializableFunction<ActualT, Void> checkerFn;
        private final PAssertionSite site;

        private SingletonCheckerDoFn(SerializableFunction<ActualT, Void> checkerFn, PAssertionSite site) {
            this.checkerFn = checkerFn;
            this.site = site;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            Object actualContents = Iterables.getOnlyElement((Iterable)c.element());
            c.output(PAssert.doChecks(this.site, actualContents, this.checkerFn));
        }
    }

    private static class GroupedValuesCheckerDoFn<ActualT>
    extends DoFn<ActualT, SuccessOrFailure> {
        private final SerializableFunction<ActualT, Void> checkerFn;
        private final PAssertionSite site;

        private GroupedValuesCheckerDoFn(SerializableFunction<ActualT, Void> checkerFn, PAssertionSite site) {
            this.checkerFn = checkerFn;
            this.site = site;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output(PAssert.doChecks(this.site, c.element(), this.checkerFn));
        }
    }

    private static class SideInputCheckerDoFn<ActualT>
    extends DoFn<Integer, SuccessOrFailure> {
        private final SerializableFunction<ActualT, Void> checkerFn;
        private final PCollectionView<ActualT> actual;
        private final PAssertionSite site;

        private SideInputCheckerDoFn(SerializableFunction<ActualT, Void> checkerFn, PCollectionView<ActualT> actual, PAssertionSite site) {
            this.checkerFn = checkerFn;
            this.actual = actual;
            this.site = site;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            ActualT actualContents = c.sideInput(this.actual);
            c.output(PAssert.doChecks(this.site, actualContents, this.checkerFn));
        }
    }

    public static class OneSideInputAssert<ActualT>
    extends PTransform<PBegin, PDone>
    implements Serializable {
        private final transient PTransform<PBegin, PCollectionView<ActualT>> createActual;
        private final transient PTransform<PCollection<Integer>, PCollection<Integer>> windowToken;
        private final SerializableFunction<ActualT, Void> checkerFn;
        private final PAssertionSite site;

        private OneSideInputAssert(PTransform<PBegin, PCollectionView<ActualT>> createActual, PTransform<PCollection<Integer>, PCollection<Integer>> windowToken, SerializableFunction<ActualT, Void> checkerFn, PAssertionSite site) {
            this.createActual = createActual;
            this.windowToken = windowToken;
            this.checkerFn = checkerFn;
            this.site = site;
        }

        @Override
        public PDone expand(PBegin input) {
            PCollectionView<ActualT> actual = input.apply("CreateActual", this.createActual);
            ((PCollection)((Object)((PCollection)input.apply(Create.of(0, new Integer[0]).withCoder(VarIntCoder.of()))).apply("WindowToken", this.windowToken).apply("RunChecks", ParDo.of(new SideInputCheckerDoFn(this.checkerFn, actual, this.site)).withSideInputs(actual)))).apply("VerifyAssertions", new DefaultConcludeTransform());
            return PDone.in(input.getPipeline());
        }
    }

    public static class GroupThenAssertForSingleton<T>
    extends PTransform<PCollection<T>, PDone>
    implements Serializable {
        private final SerializableFunction<T, Void> checkerFn;
        private final AssertionWindows rewindowingStrategy;
        private final SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> paneExtractor;
        private final PAssertionSite site;

        private GroupThenAssertForSingleton(SerializableFunction<T, Void> checkerFn, AssertionWindows rewindowingStrategy, SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> paneExtractor, PAssertionSite site) {
            this.checkerFn = checkerFn;
            this.rewindowingStrategy = rewindowingStrategy;
            this.paneExtractor = paneExtractor;
            this.site = site;
        }

        @Override
        public PDone expand(PCollection<T> input) {
            ((PCollection)((PCollection)((Object)((PCollection)input.apply("GroupGlobally", new GroupGlobally(this.rewindowingStrategy))).apply("GetPane", MapElements.via(this.paneExtractor)))).setCoder(IterableCoder.of(input.getCoder())).apply("RunChecks", ParDo.of(new SingletonCheckerDoFn(this.checkerFn, this.site)))).apply("VerifyAssertions", new DefaultConcludeTransform());
            return PDone.in(input.getPipeline());
        }
    }

    public static class GroupThenAssert<T>
    extends PTransform<PCollection<T>, PDone>
    implements Serializable {
        private final SerializableFunction<Iterable<T>, Void> checkerFn;
        private final AssertionWindows rewindowingStrategy;
        private final SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> paneExtractor;
        private final PAssertionSite site;

        private GroupThenAssert(SerializableFunction<Iterable<T>, Void> checkerFn, AssertionWindows rewindowingStrategy, SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> paneExtractor, PAssertionSite site) {
            this.checkerFn = checkerFn;
            this.rewindowingStrategy = rewindowingStrategy;
            this.paneExtractor = paneExtractor;
            this.site = site;
        }

        @Override
        public PDone expand(PCollection<T> input) {
            ((PCollection)((PCollection)((Object)((PCollection)input.apply("GroupGlobally", new GroupGlobally(this.rewindowingStrategy))).apply("GetPane", MapElements.via(this.paneExtractor)))).setCoder(IterableCoder.of(input.getCoder())).apply("RunChecks", ParDo.of(new GroupedValuesCheckerDoFn(this.checkerFn, this.site)))).apply("VerifyAssertions", new DefaultConcludeTransform());
            return PDone.in(input.getPipeline());
        }
    }

    private static final class ConcatFn<T>
    extends DoFn<Iterable<Iterable<T>>, Iterable<T>> {
        private ConcatFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output(Iterables.concat((Iterable)c.element()));
        }
    }

    private static final class ToSingletonIterables<T>
    extends DoFn<T, Iterable<T>> {
        private ToSingletonIterables() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output(ImmutableList.of(c.element()));
        }
    }

    private static class GroupGlobally<T>
    extends PTransform<PCollection<T>, PCollection<Iterable<ValueInSingleWindow<T>>>>
    implements Serializable {
        private final AssertionWindows rewindowingStrategy;

        public GroupGlobally(AssertionWindows rewindowingStrategy) {
            this.rewindowingStrategy = rewindowingStrategy;
        }

        @Override
        public PCollection<Iterable<ValueInSingleWindow<T>>> expand(PCollection<T> input) {
            int combinedKey = 42;
            if (input.getWindowingStrategy().equals(WindowingStrategy.globalDefault()) && this.rewindowingStrategy instanceof IntoGlobalWindow) {
                PCollection actual = (PCollection)input.apply(Reify.windows()).apply(ParDo.of(new ToSingletonIterables()));
                PCollection dummy = (PCollection)input.getPipeline().apply(Create.of(ImmutableList.of(ImmutableList.of())).withCoder(actual.getCoder()));
                return (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)PCollectionList.of(dummy).and(actual).apply(Flatten.pCollections())).apply(input.isBounded() == PCollection.IsBounded.UNBOUNDED ? Window.configure().triggering(Never.ever()).discardingFiredPanes() : Window.configure())).apply(WithKeys.of(42))).apply(GroupByKey.create())).apply(Values.create())).apply(ParDo.of(new ConcatFn()));
            }
            Window removeTriggering = Window.configure().triggering(Never.ever()).discardingFiredPanes().withAllowedLateness(input.getWindowingStrategy().getAllowedLateness());
            PCollection groupedContents = (PCollection)((PCollection)((PCollection)input.apply(this.rewindowingStrategy.prepareActuals()).apply("GatherAllOutputs", GatherAllPanes.globally())).apply("RewindowActuals", this.rewindowingStrategy.windowActuals()).apply("KeyForDummy", WithKeys.of(42))).apply("RemoveActualsTriggering", removeTriggering);
            PCollection keyedDummy = (PCollection)((PCollection)input.getPipeline().apply(Create.of(KV.of(42, Collections.emptyList()), new KV[0]).withCoder(groupedContents.getCoder()))).apply("WindowIntoDummy", this.rewindowingStrategy.windowDummy()).apply("RemoveDummyTriggering", removeTriggering);
            PCollection dummyAndContents = (PCollection)((PCollection)((PCollection)PCollectionList.of(groupedContents).and(keyedDummy).apply("FlattenDummyAndContents", Flatten.pCollections())).apply("NeverTrigger", Window.configure().triggering(Never.ever()).withAllowedLateness(input.getWindowingStrategy().getAllowedLateness()).discardingFiredPanes())).apply("GroupDummyAndContents", GroupByKey.create());
            return (PCollection)((PCollection)dummyAndContents.apply(Values.create())).apply(ParDo.of(new ConcatFn()));
        }
    }

    private static class CheckRelationAgainstExpected<T>
    implements SerializableFunction<T, Void> {
        private final AssertRelation<T, T> relation;
        private final byte[] encodedExpected;
        private final Coder<T> coder;

        public CheckRelationAgainstExpected(AssertRelation<T, T> relation, T expected, Coder<T> coder) {
            this.relation = relation;
            this.coder = coder;
            try {
                this.encodedExpected = CoderUtils.encodeToByteArray(coder, expected);
            }
            catch (IOException coderException) {
                throw new RuntimeException(coderException);
            }
        }

        @Override
        public Void apply(T actual) {
            try {
                T expected = CoderUtils.decodeFromByteArray(this.coder, this.encodedExpected);
                return this.relation.assertFor(expected).apply(actual);
            }
            catch (IOException coderException) {
                throw new RuntimeException(coderException);
            }
        }
    }

    private static class CreateActual<T, ActualT>
    extends PTransform<PBegin, PCollectionView<ActualT>> {
        private final transient PCollection<T> actual;
        private final transient AssertionWindows rewindowActuals;
        private final transient SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> extractPane;
        private final transient PTransform<PCollection<T>, PCollectionView<ActualT>> actualView;

        public static <T, ActualT> CreateActual<T, ActualT> from(PCollection<T> actual, AssertionWindows rewindowActuals, SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> extractPane, PTransform<PCollection<T>, PCollectionView<ActualT>> actualView) {
            return new CreateActual<T, ActualT>(actual, rewindowActuals, extractPane, actualView);
        }

        private CreateActual(PCollection<T> actual, AssertionWindows rewindowActuals, SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> extractPane, PTransform<PCollection<T>, PCollectionView<ActualT>> actualView) {
            this.actual = actual;
            this.rewindowActuals = rewindowActuals;
            this.extractPane = extractPane;
            this.actualView = actualView;
        }

        @Override
        public PCollectionView<ActualT> expand(PBegin input) {
            final Coder<T> coder = this.actual.getCoder();
            return ((PCollection)((PCollection)((PCollection)((Object)((PCollection)this.actual.apply("FilterActuals", this.rewindowActuals.prepareActuals()).apply("GatherPanes", GatherAllPanes.globally())).apply("ExtractPane", MapElements.via(this.extractPane)))).setCoder(IterableCoder.of(this.actual.getCoder())).apply(Flatten.iterables())).apply("RewindowActuals", this.rewindowActuals.windowActuals()).apply(ParDo.of(new DoFn<T, T>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext context) throws CoderException {
                    context.output(CoderUtils.clone(coder, context.element()));
                }
            }))).apply(this.actualView);
        }
    }

    private static class PCollectionViewAssert<ElemT, ViewT>
    implements SingletonAssert<ViewT> {
        private final PCollection<ElemT> actual;
        private final PTransform<PCollection<ElemT>, PCollectionView<ViewT>> view;
        private final AssertionWindows rewindowActuals;
        private final SimpleFunction<Iterable<ValueInSingleWindow<ElemT>>, Iterable<ElemT>> paneExtractor;
        private final Coder<ViewT> coder;
        private final PAssertionSite site;

        protected PCollectionViewAssert(PCollection<ElemT> actual, PTransform<PCollection<ElemT>, PCollectionView<ViewT>> view, Coder<ViewT> coder, PAssertionSite site) {
            this(actual, view, IntoGlobalWindow.of(), PaneExtractors.allPanes(), coder, site);
        }

        private PCollectionViewAssert(PCollection<ElemT> actual, PTransform<PCollection<ElemT>, PCollectionView<ViewT>> view, AssertionWindows rewindowActuals, SimpleFunction<Iterable<ValueInSingleWindow<ElemT>>, Iterable<ElemT>> paneExtractor, Coder<ViewT> coder, PAssertionSite site) {
            this.actual = actual;
            this.view = view;
            this.rewindowActuals = rewindowActuals;
            this.paneExtractor = paneExtractor;
            this.coder = coder;
            this.site = site;
        }

        public PCollectionViewAssert<ElemT, ViewT> inOnlyPane(BoundedWindow window) {
            return this.inPane(window, PaneExtractors.onlyPane(this.site));
        }

        public PCollectionViewAssert<ElemT, ViewT> inFinalPane(BoundedWindow window) {
            return this.inPane(window, PaneExtractors.finalPane());
        }

        public PCollectionViewAssert<ElemT, ViewT> inOnTimePane(BoundedWindow window) {
            return this.inPane(window, PaneExtractors.onTimePane());
        }

        public PCollectionViewAssert<ElemT, ViewT> inEarlyPane(BoundedWindow window) {
            return this.inPane(window, PaneExtractors.earlyPanes());
        }

        public PCollectionViewAssert<ElemT, ViewT> inLatePane(BoundedWindow window) {
            return this.inPane(window, PaneExtractors.latePanes());
        }

        private PCollectionViewAssert<ElemT, ViewT> inPane(BoundedWindow window, SimpleFunction<Iterable<ValueInSingleWindow<ElemT>>, Iterable<ElemT>> paneExtractor) {
            return new PCollectionViewAssert<ElemT, ViewT>(this.actual, this.view, IntoStaticWindows.of(this.actual.getWindowingStrategy().getWindowFn().windowCoder(), window), paneExtractor, this.coder, this.site);
        }

        public PCollectionViewAssert<ElemT, ViewT> isEqualTo(ViewT expectedValue) {
            return this.satisfies(new AssertIsEqualToRelation(), expectedValue);
        }

        public PCollectionViewAssert<ElemT, ViewT> notEqualTo(ViewT expectedValue) {
            return this.satisfies(new AssertNotEqualToRelation(), expectedValue);
        }

        public PCollectionViewAssert<ElemT, ViewT> satisfies(SerializableFunction<ViewT, Void> checkerFn) {
            this.actual.getPipeline().apply("PAssert$" + assertCount++, new OneSideInputAssert(CreateActual.from(this.actual, this.rewindowActuals, this.paneExtractor, this.view), this.rewindowActuals.windowDummy(), checkerFn, this.site));
            return this;
        }

        private PCollectionViewAssert<ElemT, ViewT> satisfies(AssertRelation<ViewT, ViewT> relation, ViewT expectedValue) {
            return this.satisfies((SerializableFunction)new CheckRelationAgainstExpected<ViewT>(relation, expectedValue, this.coder));
        }

        @Deprecated
        @SuppressFBWarnings(value={"EQ_UNUSUAL"})
        public boolean equals(@Nullable Object o) {
            throw new UnsupportedOperationException(String.format("tests for Java equality of the %s object, not the PCollection in question. Call a test method, such as isEqualTo.", this.getClass().getSimpleName()));
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException(String.format("%s.hashCode() is not supported.", SingletonAssert.class.getSimpleName()));
        }
    }

    private static class PCollectionSingletonAssert<T>
    implements SingletonAssert<T> {
        private final PCollection<T> actual;
        private final Coder<T> coder;
        private final AssertionWindows rewindowingStrategy;
        private final SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> paneExtractor;
        private final PAssertionSite site;

        PCollectionSingletonAssert(PCollection<T> actual, PAssertionSite site) {
            this(actual, IntoGlobalWindow.of(), PaneExtractors.allPanes(), site);
        }

        PCollectionSingletonAssert(PCollection<T> actual, AssertionWindows rewindowingStrategy, SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> paneExtractor, PAssertionSite site) {
            this.actual = actual;
            this.coder = actual.getCoder();
            this.rewindowingStrategy = rewindowingStrategy;
            this.paneExtractor = paneExtractor;
            this.site = site;
        }

        @Override
        public PCollectionSingletonAssert<T> inFinalPane(BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.finalPane());
        }

        @Override
        public PCollectionSingletonAssert<T> inOnTimePane(BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.onTimePane());
        }

        @Override
        public PCollectionSingletonAssert<T> inEarlyPane(BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.earlyPanes());
        }

        @Override
        public PCollectionSingletonAssert<T> inLatePane(BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.latePanes());
        }

        @Override
        public SingletonAssert<T> isEqualTo(T expected) {
            return this.satisfies(new AssertIsEqualToRelation(), expected);
        }

        @Override
        public SingletonAssert<T> notEqualTo(T notExpected) {
            return this.satisfies(new AssertNotEqualToRelation(), notExpected);
        }

        @Override
        public PCollectionSingletonAssert<T> inOnlyPane(BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.onlyPane(this.site));
        }

        private PCollectionSingletonAssert<T> withPanes(BoundedWindow window, SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> paneExtractor) {
            Coder<BoundedWindow> windowCoder = this.actual.getWindowingStrategy().getWindowFn().windowCoder();
            return new PCollectionSingletonAssert<T>(this.actual, IntoStaticWindows.of(windowCoder, window), paneExtractor, this.site);
        }

        @Override
        public PCollectionSingletonAssert<T> satisfies(SerializableFunction<T, Void> checkerFn) {
            this.actual.apply("PAssert$" + assertCount++, new GroupThenAssertForSingleton(checkerFn, this.rewindowingStrategy, this.paneExtractor, this.site));
            return this;
        }

        private PCollectionSingletonAssert<T> satisfies(AssertRelation<T, T> relation, T expected) {
            return this.satisfies((SerializableFunction)new CheckRelationAgainstExpected<T>(relation, expected, this.coder));
        }

        @Deprecated
        @SuppressFBWarnings(value={"EQ_UNUSUAL"})
        public boolean equals(@Nullable Object o) {
            throw new UnsupportedOperationException(String.format("tests for Java equality of the %s object, not the PCollection in question. Call a test method, such as isEqualTo.", this.getClass().getSimpleName()));
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException(String.format("%s.hashCode() is not supported.", SingletonAssert.class.getSimpleName()));
        }
    }

    private static class PCollectionSingletonIterableAssert<T>
    implements IterableAssert<T> {
        private final PCollection<Iterable<T>> actual;
        private final Coder<T> elementCoder;
        private final AssertionWindows rewindowingStrategy;
        private final SimpleFunction<Iterable<ValueInSingleWindow<Iterable<T>>>, Iterable<Iterable<T>>> paneExtractor;
        private final PAssertionSite site;

        public PCollectionSingletonIterableAssert(PCollection<Iterable<T>> actual, PAssertionSite site) {
            this(actual, IntoGlobalWindow.of(), PaneExtractors.allPanes(), site);
        }

        public PCollectionSingletonIterableAssert(PCollection<Iterable<T>> actual, AssertionWindows rewindowingStrategy, SimpleFunction<Iterable<ValueInSingleWindow<Iterable<T>>>, Iterable<Iterable<T>>> paneExtractor, PAssertionSite site) {
            this.actual = actual;
            Coder<?> typedCoder = actual.getCoder().getCoderArguments().get(0);
            this.elementCoder = typedCoder;
            this.rewindowingStrategy = rewindowingStrategy;
            this.paneExtractor = paneExtractor;
            this.site = site;
        }

        @Override
        public PCollectionSingletonIterableAssert<T> inWindow(BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.allPanes());
        }

        @Override
        public PCollectionSingletonIterableAssert<T> inFinalPane(BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.finalPane());
        }

        @Override
        public PCollectionSingletonIterableAssert<T> inOnTimePane(BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.onTimePane());
        }

        @Override
        public PCollectionSingletonIterableAssert<T> inEarlyPane(BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.earlyPanes());
        }

        @Override
        public PCollectionSingletonIterableAssert<T> inLatePane(BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.latePanes());
        }

        @Override
        public PCollectionSingletonIterableAssert<T> inCombinedNonLatePanes(BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.nonLatePanes());
        }

        @Override
        public IterableAssert<T> inEarlyGlobalWindowPanes() {
            return this.withPanes(GlobalWindow.INSTANCE, PaneExtractors.earlyPanes());
        }

        private PCollectionSingletonIterableAssert<T> withPanes(BoundedWindow window, SimpleFunction<Iterable<ValueInSingleWindow<Iterable<T>>>, Iterable<Iterable<T>>> paneExtractor) {
            Coder<BoundedWindow> windowCoder = this.actual.getWindowingStrategy().getWindowFn().windowCoder();
            return new PCollectionSingletonIterableAssert<T>(this.actual, IntoStaticWindows.of(windowCoder, window), paneExtractor, this.site);
        }

        @Override
        @SafeVarargs
        public final PCollectionSingletonIterableAssert<T> containsInAnyOrder(T ... expectedElements) {
            return this.containsInAnyOrder(Arrays.asList(expectedElements));
        }

        @Override
        public PCollectionSingletonIterableAssert<T> empty() {
            return this.containsInAnyOrder((Iterable)Collections.emptyList());
        }

        @Override
        public PCollectionSingletonIterableAssert<T> containsInAnyOrder(Iterable<T> expectedElements) {
            return this.satisfies(new AssertContainsInAnyOrderRelation(), expectedElements);
        }

        @Override
        public PCollectionSingletonIterableAssert<T> satisfies(SerializableFunction<Iterable<T>, Void> checkerFn) {
            this.actual.apply("PAssert$" + assertCount++, new GroupThenAssertForSingleton(checkerFn, this.rewindowingStrategy, this.paneExtractor, this.site));
            return this;
        }

        private PCollectionSingletonIterableAssert<T> satisfies(AssertRelation<Iterable<T>, Iterable<T>> relation, Iterable<T> expectedElements) {
            return this.satisfies(new CheckRelationAgainstExpected<Iterable<T>>(relation, expectedElements, IterableCoder.of(this.elementCoder)));
        }
    }

    protected static class PCollectionContentsAssert<T>
    implements IterableAssert<T> {
        private final PCollection<T> actual;
        private final AssertionWindows rewindowingStrategy;
        private final SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> paneExtractor;
        private final PAssertionSite site;

        public PCollectionContentsAssert(PCollection<T> actual, PAssertionSite site) {
            this(actual, IntoGlobalWindow.of(), PaneExtractors.allPanes(), site);
        }

        public PCollectionContentsAssert(PCollection<T> actual, AssertionWindows rewindowingStrategy, SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> paneExtractor, PAssertionSite site) {
            this.actual = actual;
            this.rewindowingStrategy = rewindowingStrategy;
            this.paneExtractor = paneExtractor;
            this.site = site;
        }

        @Override
        public PCollectionContentsAssert<T> inWindow(BoundedWindow window) {
            return this.withPane(window, PaneExtractors.allPanes());
        }

        @Override
        public PCollectionContentsAssert<T> inFinalPane(BoundedWindow window) {
            return this.withPane(window, PaneExtractors.finalPane());
        }

        @Override
        public PCollectionContentsAssert<T> inOnTimePane(BoundedWindow window) {
            return this.withPane(window, PaneExtractors.onTimePane());
        }

        @Override
        public PCollectionContentsAssert<T> inEarlyPane(BoundedWindow window) {
            return this.withPane(window, PaneExtractors.earlyPanes());
        }

        @Override
        public PCollectionContentsAssert<T> inLatePane(BoundedWindow window) {
            return this.withPane(window, PaneExtractors.latePanes());
        }

        @Override
        public PCollectionContentsAssert<T> inCombinedNonLatePanes(BoundedWindow window) {
            return this.withPane(window, PaneExtractors.nonLatePanes());
        }

        @Override
        public IterableAssert<T> inEarlyGlobalWindowPanes() {
            return this.withPane(GlobalWindow.INSTANCE, PaneExtractors.earlyPanes());
        }

        private PCollectionContentsAssert<T> withPane(BoundedWindow window, SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> paneExtractor) {
            Coder<BoundedWindow> windowCoder = this.actual.getWindowingStrategy().getWindowFn().windowCoder();
            return new PCollectionContentsAssert<T>(this.actual, IntoStaticWindows.of(windowCoder, window), paneExtractor, this.site);
        }

        @Override
        @SafeVarargs
        public final PCollectionContentsAssert<T> containsInAnyOrder(T ... expectedElements) {
            return this.containsInAnyOrder(Arrays.asList(expectedElements));
        }

        @Override
        public PCollectionContentsAssert<T> containsInAnyOrder(Iterable<T> expectedElements) {
            return this.satisfies(new AssertContainsInAnyOrderRelation(), expectedElements);
        }

        @Override
        public PCollectionContentsAssert<T> empty() {
            this.containsInAnyOrder((Iterable)Collections.emptyList());
            return this;
        }

        @Override
        public PCollectionContentsAssert<T> satisfies(SerializableFunction<Iterable<T>, Void> checkerFn) {
            this.actual.apply(PAssert.nextAssertionName(), new GroupThenAssert(checkerFn, this.rewindowingStrategy, this.paneExtractor, this.site));
            return this;
        }

        @SafeVarargs
        final PCollectionContentsAssert<T> containsInAnyOrder(SerializableMatcher<? super T> ... elementMatchers) {
            return this.satisfies(SerializableMatchers.containsInAnyOrder(elementMatchers));
        }

        private PCollectionContentsAssert<T> satisfies(AssertRelation<Iterable<T>, Iterable<T>> relation, Iterable<T> expectedElements) {
            return this.satisfies(new CheckRelationAgainstExpected<Iterable<T>>(relation, expectedElements, IterableCoder.of(this.actual.getCoder())));
        }

        PCollectionContentsAssert<T> satisfies(SerializableMatcher<Iterable<? extends T>> matcher) {
            MatcherCheckerFn<Iterable<? extends T>> checkerFn = new MatcherCheckerFn<Iterable<? extends T>>(matcher);
            this.actual.apply("PAssert$" + assertCount++, new GroupThenAssert(checkerFn, this.rewindowingStrategy, this.paneExtractor, this.site));
            return this;
        }

        @Deprecated
        @SuppressFBWarnings(value={"EQ_UNUSUAL"})
        public boolean equals(@Nullable Object o) {
            throw new UnsupportedOperationException("If you meant to test object equality, use .containsInAnyOrder instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException(String.format("%s.hashCode() is not supported.", IterableAssert.class.getSimpleName()));
        }

        protected static class MatcherCheckerFn<T>
        implements SerializableFunction<T, Void> {
            private SerializableMatcher<T> matcher;

            public MatcherCheckerFn(SerializableMatcher<T> matcher) {
                this.matcher = matcher;
            }

            @Override
            public @Nullable Void apply(T actual) {
                MatcherAssert.assertThat(actual, this.matcher);
                return null;
            }
        }
    }

    protected static class PCollectionListContentsAssert<T> {
        private final PCollectionList<T> pCollectionList;

        public PCollectionListContentsAssert(PCollectionList<T> actual) {
            this.pCollectionList = actual;
        }

        public PCollectionListContentsAssert<T> satisfies(SerializableFunction<Iterable<T>, Void> checkerFn) {
            for (int i = 0; i < this.pCollectionList.size(); ++i) {
                PAssert.that(this.pCollectionList.get(i)).satisfies(checkerFn);
            }
            return this;
        }

        public PCollectionListContentsAssert<T> satisfies(List<SerializableFunction<Iterable<T>, Void>> checkerFnList) {
            if (checkerFnList == null) {
                throw new IllegalArgumentException("List of SerializableFunction must not be null");
            }
            if (checkerFnList.size() != this.pCollectionList.size()) {
                throw new IllegalArgumentException("List of SerializableFunction must be the same size as the PCollectionList");
            }
            for (int i = 0; i < this.pCollectionList.size(); ++i) {
                PAssert.that(this.pCollectionList.get(i)).satisfies(checkerFnList.get(i));
            }
            return this;
        }
    }

    public static interface SingletonAssert<T> {
        public SingletonAssert<T> inOnlyPane(BoundedWindow var1);

        public SingletonAssert<T> inFinalPane(BoundedWindow var1);

        public SingletonAssert<T> inOnTimePane(BoundedWindow var1);

        public SingletonAssert<T> inEarlyPane(BoundedWindow var1);

        public SingletonAssert<T> inLatePane(BoundedWindow var1);

        public SingletonAssert<T> isEqualTo(T var1);

        public SingletonAssert<T> notEqualTo(T var1);

        public SingletonAssert<T> satisfies(SerializableFunction<T, Void> var1);
    }

    public static interface IterableAssert<T> {
        public IterableAssert<T> inWindow(BoundedWindow var1);

        public IterableAssert<T> inFinalPane(BoundedWindow var1);

        public IterableAssert<T> inOnTimePane(BoundedWindow var1);

        public IterableAssert<T> inEarlyPane(BoundedWindow var1);

        public IterableAssert<T> inLatePane(BoundedWindow var1);

        public IterableAssert<T> inCombinedNonLatePanes(BoundedWindow var1);

        public IterableAssert<T> inEarlyGlobalWindowPanes();

        public IterableAssert<T> containsInAnyOrder(T ... var1);

        public IterableAssert<T> containsInAnyOrder(Iterable<T> var1);

        public IterableAssert<T> empty();

        public IterableAssert<T> satisfies(SerializableFunction<Iterable<T>, Void> var1);
    }

    public static class PAssertionSite
    implements Serializable {
        private final String message;
        private final StackTraceElement[] creationStackTrace;

        static PAssertionSite capture(String message) {
            return new PAssertionSite(message, new Throwable().getStackTrace());
        }

        PAssertionSite(String message, StackTraceElement[] creationStackTrace) {
            this.message = message;
            this.creationStackTrace = creationStackTrace;
        }

        public AssertionError wrap(Throwable t) {
            AssertionError res = new AssertionError(this.message.isEmpty() ? t.getMessage() : this.message + ": " + t.getMessage(), t);
            ((Throwable)((Object)res)).setStackTrace(this.creationStackTrace);
            return res;
        }

        public AssertionError wrap(String message) {
            String outputMessage = this.message == null || this.message.isEmpty() ? message : this.message + ": " + message;
            AssertionError res = new AssertionError((Object)outputMessage);
            ((Throwable)((Object)res)).setStackTrace(this.creationStackTrace);
            return res;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PAssertionSite that = (PAssertionSite)o;
            return Objects.equal(this.message, that.message) && Arrays.equals(this.creationStackTrace, that.creationStackTrace);
        }

        public int hashCode() {
            return Objects.hashCode(this.message, Arrays.asList(this.creationStackTrace));
        }
    }

    public static class DefaultConcludeTransform
    extends PTransform<PCollection<SuccessOrFailure>, PCollection<Void>> {
        @Override
        public PCollection<Void> expand(PCollection<SuccessOrFailure> input) {
            return (PCollection)((Object)input.apply(ParDo.of(new DefaultConcludeFn())));
        }
    }

    private static final class DefaultConcludeFn
    extends DoFn<SuccessOrFailure, Void> {
        private DefaultConcludeFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            SuccessOrFailure e = (SuccessOrFailure)c.element();
            if (!e.isSuccess()) {
                failureCounter.inc();
                throw e.assertionError();
            }
            successCounter.inc();
        }
    }
}

