/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Ordering;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class WindowFnTestUtils {
    public static Set<String> set(long ... timestamps) {
        HashSet<String> result = new HashSet<String>();
        for (long timestamp : timestamps) {
            result.add(WindowFnTestUtils.timestampValue(timestamp));
        }
        return result;
    }

    public static <T, W extends BoundedWindow> Map<W, Set<String>> runWindowFn(WindowFn<T, W> windowFn, List<Long> timestamps) throws Exception {
        ArrayList<TimestampedValue<T>> timestampedValues = new ArrayList<TimestampedValue<T>>();
        for (Long timestamp : timestamps) {
            timestampedValues.add(TimestampedValue.of(null, new Instant(timestamp)));
        }
        return WindowFnTestUtils.runWindowFnWithValue(windowFn, timestampedValues);
    }

    public static <T, W extends BoundedWindow> Map<W, Set<String>> runWindowFnWithValue(WindowFn<T, W> windowFn, List<TimestampedValue<T>> timestampedValues) throws Exception {
        TestWindowSet<BoundedWindow, String> windowSet = new TestWindowSet<BoundedWindow, String>();
        for (TimestampedValue<T> element : timestampedValues) {
            for (BoundedWindow window : WindowFnTestUtils.assignedWindowsWithValue(windowFn, element)) {
                windowSet.put(window, WindowFnTestUtils.timestampValue(element.getTimestamp().getMillis()));
            }
            TestMergeContext mergeContext = new TestMergeContext(windowSet, windowFn);
            windowFn.mergeWindows(mergeContext);
        }
        HashMap actual = new HashMap();
        for (BoundedWindow window : windowSet.windows()) {
            actual.put(window, windowSet.get(window));
        }
        return actual;
    }

    public static <T, W extends BoundedWindow> Collection<W> assignedWindows(WindowFn<T, W> windowFn, long timestamp) throws Exception {
        return WindowFnTestUtils.assignedWindowsWithValue(windowFn, TimestampedValue.of(null, new Instant(timestamp)));
    }

    public static <T, W extends BoundedWindow> Collection<W> assignedWindowsWithValue(WindowFn<T, W> windowFn, TimestampedValue<T> timestampedValue) throws Exception {
        TestAssignContext<T, W> assignContext = new TestAssignContext<T, W>(timestampedValue, windowFn);
        return windowFn.assignWindows(assignContext);
    }

    private static String timestampValue(long timestamp) {
        return "T" + new Instant(timestamp);
    }

    public static <T, W extends IntervalWindow> void validateGetOutputTimestamps(WindowFn<T, W> windowFn, TimestampCombiner timestampCombiner, List<List<Long>> timestampsPerWindow) throws Exception {
        ArrayList<List<TimestampedValue<T>>> timestampValuesPerWindow = new ArrayList<List<TimestampedValue<T>>>();
        for (List<Long> timestamps : timestampsPerWindow) {
            ArrayList<TimestampedValue<Object>> timestampedValues = new ArrayList<TimestampedValue<Object>>();
            for (Long timestamp : timestamps) {
                TimestampedValue<Object> tv = TimestampedValue.of(null, new Instant(timestamp));
                timestampedValues.add(tv);
            }
            timestampValuesPerWindow.add(timestampedValues);
        }
        WindowFnTestUtils.validateGetOutputTimestampsWithValue(windowFn, timestampCombiner, timestampValuesPerWindow);
    }

    public static <T, W extends IntervalWindow> void validateGetOutputTimestampsWithValue(WindowFn<T, W> windowFn, TimestampCombiner timestampCombiner, List<List<TimestampedValue<T>>> timestampValuesPerWindow) throws Exception {
        IntervalWindow window;
        final ArrayList windows = new ArrayList();
        for (List<TimestampedValue<T>> timestampValuesForWindow : timestampValuesPerWindow) {
            final HashSet<W> windowsToMerge = new HashSet<W>();
            for (TimestampedValue<T> element : timestampValuesForWindow) {
                windowsToMerge.addAll(WindowFnTestUtils.assignedWindowsWithValue(windowFn, element));
            }
            WindowFn<T, W> windowFn2 = windowFn;
            Objects.requireNonNull(windowFn2);
            windowFn.mergeWindows(new WindowFn.MergeContext(windowFn2){

                @Override
                public Collection<W> windows() {
                    return windowsToMerge;
                }

                @Override
                public void merge(Collection<W> toBeMerged, W mergeResult) throws Exception {
                    windows.add(mergeResult);
                }
            });
        }
        ArrayList<Instant> combinedOutputTimestamps = new ArrayList<Instant>();
        for (int i = 0; i < timestampValuesPerWindow.size(); ++i) {
            List<TimestampedValue<T>> timestampValuesForWindow = timestampValuesPerWindow.get(i);
            window = (IntervalWindow)windows.get(i);
            ArrayList<Instant> outputInstants = new ArrayList<Instant>();
            for (TimestampedValue<T> element : timestampValuesForWindow) {
                outputInstants.add(WindowFnTestUtils.assignOutputTime(timestampCombiner, new Instant(element.getTimestamp()), window));
            }
            combinedOutputTimestamps.add(WindowFnTestUtils.combineOutputTimes(timestampCombiner, outputInstants));
        }
        IntervalWindow earlierEndingWindow = null;
        for (int i = 0; i < windows.size(); ++i) {
            window = (IntervalWindow)windows.get(i);
            ReadableInstant outputTimestamp = (ReadableInstant)combinedOutputTimestamps.get(i);
            if (earlierEndingWindow != null) {
                MatcherAssert.assertThat((Object)outputTimestamp, (Matcher)Matchers.greaterThan((Comparable)earlierEndingWindow.maxTimestamp()));
            }
            earlierEndingWindow = window;
        }
    }

    private static Instant assignOutputTime(TimestampCombiner timestampCombiner, Instant inputTimestamp, BoundedWindow window) {
        switch (timestampCombiner) {
            case EARLIEST: 
            case LATEST: {
                return inputTimestamp;
            }
            case END_OF_WINDOW: {
                return window.maxTimestamp();
            }
        }
        throw new IllegalArgumentException(String.format("Unknown %s: %s", new Object[]{TimestampCombiner.class, timestampCombiner}));
    }

    private static Instant combineOutputTimes(TimestampCombiner timestampCombiner, Iterable<Instant> outputInstants) {
        Preconditions.checkArgument(!Iterables.isEmpty(outputInstants), "Cannot combine zero instants with %s", (Object)timestampCombiner);
        switch (timestampCombiner) {
            case EARLIEST: {
                return Ordering.natural().min(outputInstants);
            }
            case LATEST: {
                return Ordering.natural().max(outputInstants);
            }
            case END_OF_WINDOW: {
                return outputInstants.iterator().next();
            }
        }
        throw new IllegalArgumentException(String.format("Unknown %s: %s", new Object[]{TimestampCombiner.class, timestampCombiner}));
    }

    private static class TestWindowSet<W extends BoundedWindow, V> {
        private Map<W, Set<V>> elements = new HashMap<W, Set<V>>();

        private TestWindowSet() {
        }

        public void put(W window, V value) {
            Set all = this.elements.computeIfAbsent(window, k -> new HashSet());
            all.add(value);
        }

        public void merge(Collection<W> otherWindows, W window) {
            if (otherWindows.isEmpty()) {
                return;
            }
            HashSet merged = new HashSet();
            if (this.elements.containsKey(window) && !otherWindows.contains(window)) {
                merged.addAll(this.elements.get(window));
            }
            for (BoundedWindow w : otherWindows) {
                if (!this.elements.containsKey(w)) {
                    throw new IllegalArgumentException("Tried to merge a non-existent window:" + w);
                }
                merged.addAll(this.elements.get(w));
                this.elements.remove(w);
            }
            this.elements.put(window, merged);
        }

        public Collection<W> windows() {
            return this.elements.keySet();
        }

        public Set<V> get(W window) {
            return this.elements.get(window);
        }
    }

    private static class TestMergeContext<T, W extends BoundedWindow>
    extends WindowFn.MergeContext {
        private TestWindowSet<W, ?> windowSet;

        public TestMergeContext(TestWindowSet<W, ?> windowSet, WindowFn<T, W> windowFn) {
            super(windowFn);
            this.windowSet = windowSet;
        }

        @Override
        public Collection<W> windows() {
            return this.windowSet.windows();
        }

        @Override
        public void merge(Collection<W> toBeMerged, W mergeResult) {
            this.windowSet.merge(toBeMerged, mergeResult);
        }
    }

    private static class TestAssignContext<T, W extends BoundedWindow>
    extends WindowFn.AssignContext {
        private TimestampedValue<T> timestampedValue;

        public TestAssignContext(TimestampedValue<T> timestampedValue, WindowFn<T, W> windowFn) {
            super(windowFn);
            this.timestampedValue = timestampedValue;
        }

        @Override
        public T element() {
            return this.timestampedValue.getValue();
        }

        @Override
        public Instant timestamp() {
            return this.timestampedValue.getTimestamp();
        }

        @Override
        public BoundedWindow window() {
            return GlobalWindow.INSTANCE;
        }
    }
}

