/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Objects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.HashingOutputStream;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;
import org.checkerframework.checker.nullness.qual.Nullable;

@Deprecated
public class ApproximateUnique {
    public static <T> Globally<T> globally(int sampleSize) {
        return new Globally(sampleSize);
    }

    public static <T> Globally<T> globally(double maximumEstimationError) {
        return new Globally(maximumEstimationError);
    }

    public static <K, V> PerKey<K, V> perKey(int sampleSize) {
        return new PerKey(sampleSize);
    }

    public static <K, V> PerKey<K, V> perKey(double maximumEstimationError) {
        return new PerKey(maximumEstimationError);
    }

    static long sampleSizeFromEstimationError(double estimationError) {
        return Math.round(Math.ceil(4.0 / Math.pow(estimationError, 2.0)));
    }

    private static void populateDisplayData(DisplayData.Builder builder, long sampleSize, @Nullable Double maxEstimationError) {
        builder.add(DisplayData.item("sampleSize", sampleSize).withLabel("Sample Size")).addIfNotNull(DisplayData.item("maximumEstimationError", maxEstimationError).withLabel("Maximum Estimation Error"));
    }

    public static class ApproximateUniqueCombineFn<T>
    extends Combine.CombineFn<T, LargestUnique, Long> {
        static final double HASH_SPACE_SIZE = 1.8446744073709552E19;
        private final long sampleSize;
        private final Coder<T> coder;

        public ApproximateUniqueCombineFn(long sampleSize, Coder<T> coder) {
            this.sampleSize = sampleSize;
            this.coder = coder;
        }

        @Override
        public LargestUnique createAccumulator() {
            return new LargestUnique(this.sampleSize);
        }

        @Override
        public LargestUnique addInput(LargestUnique heap, T input) {
            try {
                heap.add(ApproximateUniqueCombineFn.hash(input, this.coder));
                return heap;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public LargestUnique mergeAccumulators(Iterable<LargestUnique> heaps) {
            Iterator<LargestUnique> iterator = heaps.iterator();
            LargestUnique accumulator = iterator.next();
            while (iterator.hasNext()) {
                iterator.next().heap.forEach(h2 -> accumulator.add((long)h2));
            }
            return accumulator;
        }

        @Override
        public Long extractOutput(LargestUnique heap) {
            return heap.getEstimate();
        }

        @Override
        public Coder<LargestUnique> getAccumulatorCoder(CoderRegistry registry, Coder<T> inputCoder) {
            return SerializableCoder.of(LargestUnique.class);
        }

        static <T> long hash(T element, Coder<T> coder) throws CoderException, IOException {
            try (HashingOutputStream stream = new HashingOutputStream(Hashing.murmur3_128(), ByteStreams.nullOutputStream());){
                coder.encode(element, stream, Coder.Context.OUTER);
                long l = stream.hash().asLong();
                return l;
            }
        }

        public static class LargestUnique
        implements Serializable {
            private TreeSet<Long> heap = new TreeSet();
            private long minHash = Long.MAX_VALUE;
            private final long sampleSize;

            public LargestUnique(long sampleSize) {
                this.sampleSize = sampleSize;
            }

            public boolean add(long value) {
                if ((long)this.heap.size() >= this.sampleSize && value < this.minHash) {
                    return false;
                }
                if (this.heap.add(value)) {
                    if ((long)this.heap.size() > this.sampleSize) {
                        this.heap.remove(this.minHash);
                        this.minHash = this.heap.first();
                    } else if (value < this.minHash) {
                        this.minHash = value;
                    }
                }
                return true;
            }

            long getEstimate() {
                if ((long)this.heap.size() < this.sampleSize) {
                    return this.heap.size();
                }
                double sampleSpaceSize = 9.223372036854776E18 - (double)this.minHash;
                double estimate = Math.log1p((double)(-this.sampleSize) / sampleSpaceSize) / Math.log1p(-1.0 / sampleSpaceSize) * 1.8446744073709552E19 / sampleSpaceSize;
                return Math.round(estimate);
            }

            public boolean equals(@Nullable Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LargestUnique that = (LargestUnique)o;
                return this.sampleSize == that.sampleSize && Iterables.elementsEqual(this.heap, that.heap);
            }

            public int hashCode() {
                return Objects.hashCode(Lists.newArrayList(this.heap), this.sampleSize);
            }
        }
    }

    public static final class PerKey<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Long>>> {
        private final long sampleSize;
        private final @Nullable Double maximumEstimationError;

        public PerKey(int sampleSize) {
            if (sampleSize < 16) {
                throw new IllegalArgumentException("ApproximateUnique needs a sampleSize >= 16 for an estimation error <= 50%.  In general, the estimation error is about 2 / sqrt(sampleSize).");
            }
            this.sampleSize = sampleSize;
            this.maximumEstimationError = null;
        }

        public PerKey(double estimationError) {
            if (estimationError < 0.01 || estimationError > 0.5) {
                throw new IllegalArgumentException("ApproximateUnique.PerKey needs an estimation error between 1% (0.01) and 50% (0.5).");
            }
            this.sampleSize = ApproximateUnique.sampleSizeFromEstimationError(estimationError);
            this.maximumEstimationError = estimationError;
        }

        @Override
        public PCollection<KV<K, Long>> expand(PCollection<KV<K, V>> input) {
            Coder<KV<K, V>> inputCoder = input.getCoder();
            if (!(inputCoder instanceof KvCoder)) {
                throw new IllegalStateException("ApproximateUnique.PerKey requires its input to use KvCoder");
            }
            Coder coder = ((KvCoder)inputCoder).getValueCoder();
            return (PCollection)input.apply(Combine.perKey(new ApproximateUniqueCombineFn(this.sampleSize, coder)));
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            ApproximateUnique.populateDisplayData(builder, this.sampleSize, this.maximumEstimationError);
        }
    }

    public static final class Globally<T>
    extends PTransform<PCollection<T>, PCollection<Long>> {
        private final long sampleSize;
        private final @Nullable Double maximumEstimationError;

        public Globally(int sampleSize) {
            if (sampleSize < 16) {
                throw new IllegalArgumentException("ApproximateUnique needs a sampleSize >= 16 for an estimation error <= 50%.  In general, the estimation error is about 2 / sqrt(sampleSize).");
            }
            this.sampleSize = sampleSize;
            this.maximumEstimationError = null;
        }

        public Globally(double maximumEstimationError) {
            if (maximumEstimationError < 0.01 || maximumEstimationError > 0.5) {
                throw new IllegalArgumentException("ApproximateUnique needs an estimation error between 1% (0.01) and 50% (0.5).");
            }
            this.sampleSize = ApproximateUnique.sampleSizeFromEstimationError(maximumEstimationError);
            this.maximumEstimationError = maximumEstimationError;
        }

        @Override
        public PCollection<Long> expand(PCollection<T> input) {
            Coder<T> coder = input.getCoder();
            return (PCollection)input.apply(Combine.globally(new ApproximateUniqueCombineFn<T>(this.sampleSize, coder)));
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            ApproximateUnique.populateDisplayData(builder, this.sampleSize, this.maximumEstimationError);
        }
    }
}

