/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.InferableFunction;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Requirements;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleMapWithFailures;
import org.apache.beam.sdk.transforms.WithFailures;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public class MapValues<K, V1, V2>
extends PTransform<PCollection<KV<K, V1>>, PCollection<KV<K, V2>>> {
    private final transient TypeDescriptor<V2> outputType;
    private final @Nullable Contextful<Contextful.Fn<KV<K, V1>, KV<K, V2>>> fn;

    public <NewKeyT, NewValueT> MapValues<NewKeyT, NewValueT, V2> via(SerializableFunction<NewValueT, V2> fn) {
        return new MapValues<K, V1, V2>(Contextful.fn((element, c) -> KV.of(element.getKey(), fn.apply(element.getValue())), Requirements.empty()), this.outputType);
    }

    public static <V2> MapValues<?, ?, V2> into(TypeDescriptor<V2> outputType) {
        return new MapValues(null, outputType);
    }

    private MapValues(@Nullable Contextful<Contextful.Fn<KV<K, V1>, KV<K, V2>>> fn, TypeDescriptor<V2> outputType) {
        this.fn = fn;
        this.outputType = outputType;
    }

    @RequiresNonNull(value={"fn"})
    public <FailureT> SimpleMapWithFailures<KV<K, V1>, KV<K, V2>, FailureT> exceptionsInto(TypeDescriptor<FailureT> failureTypeDescriptor) {
        return new SimpleMapWithFailures("MapValuesWithFailures", this.fn, this.getKvTypeDescriptor(), null, failureTypeDescriptor);
    }

    @RequiresNonNull(value={"fn"})
    public <FailureT> SimpleMapWithFailures<KV<K, V1>, KV<K, V2>, FailureT> exceptionsVia(InferableFunction<WithFailures.ExceptionElement<KV<K, V1>>, FailureT> exceptionHandler) {
        return new SimpleMapWithFailures<KV<K, V1>, KV<K, V2>, FailureT>("MapValuesWithFailures", this.fn, this.getKvTypeDescriptor(), exceptionHandler, exceptionHandler.getOutputTypeDescriptor());
    }

    @Override
    public PCollection<KV<K, V2>> expand(PCollection<KV<K, V1>> input) {
        return (PCollection)((Object)input.apply("MapValues", MapElements.into(this.getKvTypeDescriptor()).via(Preconditions.checkNotNull(this.fn, "Must specify a function on MapValues using .via()"))));
    }

    private TypeDescriptor<KV<K, V2>> getKvTypeDescriptor() {
        return new TypeDescriptor<KV<K, V2>>(){}.where(new TypeParameter<V2>(){}, this.outputType);
    }
}

